#include "mbed.h"
#define NUM_COUNTS 2
 
InterruptIn button(PB_9);
DigitalOut simulation(PA_8);
int count;
float t1 = 0, total = 0, RPM;
Timer t;
Serial pc(PA_9, PA_10); // tx and rx
 
void flip() {
    t.start();
    count++;
    total += t.read_ms() - t1;
    t1 = t.read_ms();
}
 
int main() {
    button.rise(&flip);  // attach the address of the flip function to the rising edge
    while(1) {           // wait around, interrupts will interrupt this!
        if(count >= NUM_COUNTS){
            t.stop();
            RPM = ((NUM_COUNTS-1)/(total/1000))*60;
            pc.printf("%.2f\n",RPM);
            count = 0;
            t1 = 0;
            total = 0;
            t.reset();
            }   
            simulation = 0;
            wait_ms(24);
            simulation = 1;
            wait_ms(1);
            }
    }