#include "accelerometer.h"

Accelerometer::Accelerometer() :
    i2c(p9, p10)
{
    initAccel();    
}

Accelerometer::~Accelerometer(){}

void Accelerometer::writeToRegister(int address, int startingRegister, int data2Write) 
{ 
    char data[2]; 
    data[0] = startingRegister; 
    data[1] = data2Write; 
  
    i2c.write(address, data, 2); 
} 
  
int Accelerometer::readRegister(int address, int startingRegister) 
{ 
    char content[1]; 
    char reg[1]; 
    reg[0] = startingRegister; 
      
    i2c.write(address, reg, 1, true); 
    i2c.read(address, content, 1); 
      
    return content[0]; 
} 
  
char Accelerometer::i2c_read_reg(char address) //fonction qui lit les valeurs des registres 
{    
    // Read from selected register adress 
    i2c.start();                                          
    i2c.write(MMA8452_WRITE_ADDRESS);    
    i2c.write(address);                  
    i2c.start();                         
    i2c.write(MMA8452_READ_ADDRESS);     
    char data = i2c.read(0);             
    i2c.stop();                          
   
    // return the data readed 
    return data;    
} 
  
bool Accelerometer::initAccel() //fonction qui initialise l'Accelerometer avec i2c 
{ 
    // Start I2C communication    
    char data = i2c_read_reg(WHO_AM_I); 
    if(data != 0x2A) 
    { 
        return false; 
    }
    
    // Put accelerometer in active mode at 6.25Hz 
    writeToRegister(MMA8452_WRITE_ADDRESS, CTRL_REG1, 0x31); 
      
    // Put accelerometer in standby mode at 6.25Hz 
    writeToRegister(MMA8452_WRITE_ADDRESS, CTRL_REG1, 0x30); 
       
    // Set accelerometer in 4g range 
    writeToRegister(MMA8452_WRITE_ADDRESS, XYZ_DATA_CFG, 0x1); 
       
    // Put accelerometer in active mode at 6.25Hz 
    writeToRegister(MMA8452_WRITE_ADDRESS, CTRL_REG1, 0x31);
    
    return true;      
}

unsigned short* Accelerometer::getAccelValue()
{
    unsigned short* values = new unsigned short[3];
    
    values[0] = i2c_read_reg(OUT_X_MSB);
    values[1] = i2c_read_reg(OUT_Y_MSB);
    values[2] = i2c_read_reg(OUT_Z_MSB);
    
    return values;
} 

extern void *Accelerometer_C_new()
{
    return new Accelerometer();
}

extern void  Accelerometer_C_delete(void *accelerometer)
{
    Accelerometer *acc = (Accelerometer*)accelerometer;
    delete acc;
}

extern unsigned short* Accelerometer_C_getAccelValue(void *accelerometer)
{
    Accelerometer *acc = (Accelerometer*)accelerometer;
    return acc->getAccelValue();
}
  