#include "accelerometer.h"
#include "interrupt.h"

Serial pc(USBTX, USBRX);
DigitalOut led1(LED1);

void *accelerometer = Accelerometer_C_new();
bool capture = false;
bool first = true;
bool ready = false;

extern "C" void interruptCapture(void)
{
    led1 = 1;
    pc.printf("ALLO");
    if ((LPC_TIM2->IR & 0x10) == 0x10) // Interrupt capture
    {
        ready = !ready;
        if (first)
        {
            capture = !capture;
            first = true;
            
            LPC_TIM2->TC = 0;       // clear timer counter
            LPC_TIM2->PC = 0;       // clear prescale counter
            LPC_TIM2->PR = 0;       // clear prescale register
            LPC_TIM2->MCR |= 0x03;  // interrupt and reset control
        }
        
    } 
    else if ((LPC_TIM2->IR & 0x01) == 0x01) // Interrupt match
    {
        if (ready)
        {
            if (capture)
            {
                LPC_TIM3->TC = 0;       // clear timer counter
                LPC_TIM3->PC = 0;       // clear prescale counter
                LPC_TIM3->PR = 0;       // clear prescale register
                LPC_TIM3->IR |= 0xFF;
                
                NVIC_EnableIRQ(TIMER3_IRQn); // Enable timer3 interrupt
            }
            else
            {
                NVIC_DisableIRQ(TIMER3_IRQn); // Enable timer3 interrupt
            }
            
            ready = false;
            first = false;
            LPC_TIM2->MCR = 0;
        } 
    }
    
    LPC_TIM2->IR |= 0xFF;
}

extern "C" void interruptMatch(void)
{
    unsigned short* values;
    
    values = Accelerometer_C_getAccelValue(accelerometer);
    
    for(int i = 0; i < 3; i++)
        pc.printf("%d\n", values[i]);
    

    LPC_TIM3->IR |= 0x01; // Reset timer  
}

void initialize()
{
    // Set system control
    LPC_SC->PCONP |= (3 << 22); // Enable Timer2 and Timer3
    LPC_SC->PCLKSEL1 |= (1 << 12); // PClk Timer2 = CCLK
    LPC_SC->PCLKSEL1 |= (1 << 14); // PClk Timer3 = CCLK
    
    // Set pin connection
    LPC_PINCON->PINSEL0 |= (3 << 8) | (3 << 12) | (3 << 20); // Capture 2.0 and Match 2.0 and Match 3.0
    
    // Set timer 2 for capture
    LPC_TIM2->TC = 0;               // clear timer counter
    LPC_TIM2->PC = 0;               // clear prescale counter
    LPC_TIM2->PR = 0;               // clear prescale register
    LPC_TIM2->MR0 = SystemCoreClock / 10000;
    LPC_TIM2->IR |= 0xFF;           // Clear interrupt flag
    LPC_TIM2->CCR |= (7 << 0);      // enable cap2.0 rising-edge capture and falling-edge; interrupt on cap2.0
    
    // Set timer 3 for match
    LPC_TIM3->MR0 = SystemCoreClock / 20;
    LPC_TIM3->MCR |= 0x03;              // interrupt and reset control
    LPC_TIM3->TC = 0;                   // clear timer counter
    LPC_TIM3->PC = 0;                   // clear prescale counter
    LPC_TIM3->PR = 0;                   // clear prescale register
    LPC_TIM3->TCR = 0x1;                // enable timer3
    LPC_TIM3->IR |= 1 << 0;             // Clear MR0 interrupt flag
    
    // Set call function
    NVIC_SetVector(TIMER2_IRQn, uint32_t(interruptCapture));
    NVIC_SetVector(TIMER3_IRQn, uint32_t(interruptMatch));
        
    NVIC_EnableIRQ(TIMER2_IRQn);    // enable timer2 interrupt
    LPC_TIM2->TCR = 0x01;           // start Timer2
}

int main()
{
    initialize();
    
    while(true)
    {
    }
}
