/******************************************************************************
 *Copyright (c)2020 Analog Devices, Inc.  
 *
 * Licensed under the 2020-04-27-CN0540EC License(the "License");
 * you may not use this file except in compliance with the License.
 *
 ****************************************************************************/
 
 #ifndef _WINDOWING_H_
#define _WINDOWING_H_				 

#include <arm_math.h>

//Windowing function coefficients for 7-term Blackman-Harris window
const double seven_term_BH_coefs[7] = { 0.27105140069342, -0.43329793923448, 0.21812299954311, -0.06592544638803, 0.01081174209837, -0.00077658482522, 0.00001388721735 };

//Sum of all 4096 coeficients as a gain factor after aplying the windowing and the FFT
const double Seven_Term_Blackman_Harris_4096_sum = 1109.9554550113426;

const float32_t Seven_Term_Blackman_Harris_4096[4096] = 
{
	0.0000000591045186,
	0.0000000591772285,
	0.0000000593954077,
	0.0000000597591949,
	0.0000000602688317,
	0.0000000609246413,
	0.0000000617270643,
	0.0000000626766195,
	0.0000000637739319,
	0.0000000650196981,
	0.0000000664147422,
	0.0000000679599736,
	0.0000000696563802,
	0.0000000715050774,
	0.0000000735072447,
	0.0000000756641896,
	0.0000000779772833,
	0.0000000804480322,
	0.0000000830780138,
	0.0000000858689049,
	0.0000000888224960,
	0.0000000919406702,
	0.0000000952253956,
	0.0000000986787683,
	0.0000001023029625,
	0.0000001061002592,
	0.0000001100730458,
	0.0000001142238020,
	0.0000001185551284,
	0.0000001230697109,
	0.0000001277703348,
	0.0000001326599204,
	0.0000001377414662,
	0.0000001430180845,
	0.0000001484929868,
	0.0000001541695127,
	0.0000001600510871,
	0.0000001661412625,
	0.0000001724436771,
	0.0000001789620967,
	0.0000001857004150,
	0.0000001926625970,
	0.0000001998527637,
	0.0000002072751215,
	0.0000002149339906,
	0.0000002228338332,
	0.0000002309792109,
	0.0000002393747991,
	0.0000002480254295,
	0.0000002569359765,
	0.0000002661114991,
	0.0000002755571700,
	0.0000002852782757,
	0.0000002952802447,
	0.0000003055685909,
	0.0000003161490270,
	0.0000003270272941,
	0.0000003382093325,
	0.0000003497012528,
	0.0000003615091657,
	0.0000003736394660,
	0.0000003860985487,
	0.0000003988930644,
	0.0000004120297206,
	0.0000004255153669,
	0.0000004393570805,
	0.0000004535619667,
	0.0000004681373582,
	0.0000004830906732,
	0.0000004984295288,
	0.0000005141616271,
	0.0000005302949262,
	0.0000005468373843,
	0.0000005637973004,
	0.0000005811829737,
	0.0000005990029308,
	0.0000006172658118,
	0.0000006359804274,
	0.0000006551558727,
	0.0000006748012424,
	0.0000006949258022,
	0.0000007155391586,
	0.0000007366509180,
	0.0000007582709145,
	0.0000007804091524,
	0.0000008030758067,
	0.0000008262812798,
	0.0000008500360877,
	0.0000008743509738,
	0.0000008992367952,
	0.0000009247047501,
	0.0000009507660366,
	0.0000009774321370,
	0.0000010047147043,
	0.0000010326257325,
	0.0000010611771586,
	0.0000010903812608,
	0.0000011202505448,
	0.0000011507976296,
	0.0000011820354757,
	0.0000012139770433,
	0.0000012466357475,
	0.0000012800250033,
	0.0000013141585669,
	0.0000013490505353,
	0.0000013847148921,
	0.0000014211661892,
	0.0000014584188648,
	0.0000014964879256,
	0.0000015353883782,
	0.0000015751356841,
	0.0000016157451910,
	0.0000016572329287,
	0.0000016996148133,
	0.0000017429071022,
	0.0000017871265072,
	0.0000018322896267,
	0.0000018784136273,
	0.0000019255157895,
	0.0000019736139620,
	0.0000020227255391,
	0.0000020728687105,
	0.0000021240621209,
	0.0000021763244149,
	0.0000022296742372,
	0.0000022841309146,
	0.0000023397142286,
	0.0000023964435059,
	0.0000024543392101,
	0.0000025134213502,
	0.0000025737108444,
	0.0000026352286113,
	0.0000026979960239,
	0.0000027620346827,
	0.0000028273661883,
	0.0000028940128232,
	0.0000029619975521,
	0.0000030313426578,
	0.0000031020715596,
	0.0000031742079045,
	0.0000032477753393,
	0.0000033227979657,
	0.0000033993005673,
	0.0000034773079278,
	0.0000035568450585,
	0.0000036379378798,
	0.0000037206118577,
	0.0000038048938222,
	0.0000038908101487,
	0.0000039783876673,
	0.0000040676541175,
	0.0000041586367843,
	0.0000042513643166,
	0.0000043458653636,
	0.0000044421681196,
	0.0000045403025979,
	0.0000046402983571,
	0.0000047421854106,
	0.0000048459946811,
	0.0000049517561820,
	0.0000050595022003,
	0.0000051692641136,
	0.0000052810742091,
	0.0000053949652283,
	0.0000055109703681,
	0.0000056291228248,
	0.0000057494567045,
	0.0000058720061133,
	0.0000059968065216,
	0.0000061238929447,
	0.0000062533008531,
	0.0000063850670813,
	0.0000065192284637,
	0.0000066558213803,
	0.0000067948840297,
	0.0000069364550654,
	0.0000070805726864,
	0.0000072272755460,
	0.0000073766045716,
	0.0000075285988714,
	0.0000076833002822,
	0.0000078407483670,
	0.0000080009867816,
	0.0000081640564531,
	0.0000083300010374,
	0.0000084988632807,
	0.0000086706877482,
	0.0000088455190053,
	0.0000090234016170,
	0.0000092043810582,
	0.0000093885037131,
	0.0000095758168754,
	0.0000097663669294,
	0.0000099602029877,
	0.0000101573732536,
	0.0000103579259303,
	0.0000105619110400,
	0.0000107693804239,
	0.0000109803841042,
	0.0000111949730126,
	0.0000114131998998,
	0.0000116351184261,
	0.0000118607813420,
	0.0000120902423077,
	0.0000123235577121,
	0.0000125607821246,
	0.0000128019719341,
	0.0000130471835291,
	0.0000132964751174,
	0.0000135499049065,
	0.0000138075311042,
	0.0000140694146467,
	0.0000143356155604,
	0.0000146061938722,
	0.0000148812123371,
	0.0000151607337102,
	0.0000154448207468,
	0.0000157335380209,
	0.0000160269482876,
	0.0000163251206686,
	0.0000166281188285,
	0.0000169360118889,
	0.0000172488653334,
	0.0000175667482836,
	0.0000178897334990,
	0.0000182178882824,
	0.0000185512835742,
	0.0000188899921341,
	0.0000192340867216,
	0.0000195836419152,
	0.0000199387304747,
	0.0000202994287974,
	0.0000206658114621,
	0.0000210379585042,
	0.0000214159463212,
	0.0000217998531298,
	0.0000221897589654,
	0.0000225857456826,
	0.0000229878914979,
	0.0000233962837228,
	0.0000238110023929,
	0.0000242321330006,
	0.0000246597592195,
	0.0000250939701800,
	0.0000255348495557,
	0.0000259824901150,
	0.0000264369755314,
	0.0000268984003924,
	0.0000273668538284,
	0.0000278424286080,
	0.0000283252174995,
	0.0000288153150905,
	0.0000293128177873,
	0.0000298178183584,
	0.0000303304168483,
	0.0000308507114823,
	0.0000313788004860,
	0.0000319147875416,
	0.0000324587708747,
	0.0000330108523485,
	0.0000335711411026,
	0.0000341397353623,
	0.0000347167479049,
	0.0000353022805939,
	0.0000358964462066,
	0.0000364993502444,
	0.0000371111091226,
	0.0000377318283427,
	0.0000383616243198,
	0.0000390006098314,
	0.0000396489012928,
	0.0000403066151193,
	0.0000409738713643,
	0.0000416507864429,
	0.0000423374804086,
	0.0000430340769526,
	0.0000437407034042,
	0.0000444574725407,
	0.0000451845226053,
	0.0000459219700133,
	0.0000466699493700,
	0.0000474285880045,
	0.0000481980205222,
	0.0000489783706143,
	0.0000497697801620,
	0.0000505723801325,
	0.0000513863087690,
	0.0000522117043147,
	0.0000530487013748,
	0.0000538974454685,
	0.0000547580784769,
	0.0000556307386432,
	0.0000565155751246,
	0.0000574127370783,
	0.0000583223663853,
	0.0000592446158407,
	0.0000601796346018,
	0.0000611275754636,
	0.0000620885912213,
	0.0000630628419458,
	0.0000640504804323,
	0.0000650516667520,
	0.0000660665609757,
	0.0000670953231747,
	0.0000681381206959,
	0.0000691951136105,
	0.0000702664692653,
	0.0000713523622835,
	0.0000724529527361,
	0.0000735684152460,
	0.0000746989317122,
	0.0000758446622058,
	0.0000770057959016,
	0.0000781825001468,
	0.0000793749641161,
	0.0000805833697086,
	0.0000818078915472,
	0.0000830487260828,
	0.0000843060552143,
	0.0000855800608406,
	0.0000868709466886,
	0.0000881788946572,
	0.0000895041084732,
	0.0000908467700356,
	0.0000922070976230,
	0.0000935852731345,
	0.0000949815075728,
	0.0000963960046647,
	0.0000978289681370,
	0.0000992806017166,
	0.0001007511236821,
	0.0001022407377604,
	0.0001037496549543,
	0.0001052781080944,
	0.0001068262936315,
	0.0001083944443963,
	0.0001099827786675,
	0.0001115915219998,
	0.0001132208926720,
	0.0001148711307906,
	0.0001165424473584,
	0.0001182350970339,
	0.0001199492980959,
	0.0001216852906509,
	0.0001234433148056,
	0.0001252236252185,
	0.0001270264328923,
	0.0001288519997615,
	0.0001307005877607,
	0.0001325724151684,
	0.0001344677730231,
	0.0001363868796034,
	0.0001383299968438,
	0.0001402974012308,
	0.0001422893546987,
	0.0001443060900783,
	0.0001463479129598,
	0.0001484150561737,
	0.0001505078107584,
	0.0001526264532004,
	0.0001547712308820,
	0.0001569424493937,
	0.0001591403852217,
	0.0001613653148524,
	0.0001636175293243,
	0.0001658972905716,
	0.0001682049332885,
	0.0001705407048576,
	0.0001729049399728,
	0.0001752979151206,
	0.0001777199213393,
	0.0001801712933229,
	0.0001826523075579,
	0.0001851632841863,
	0.0001877045287983,
	0.0001902763615362,
	0.0001928790879901,
	0.0001955130574061,
	0.0001981785462704,
	0.0002008759183809,
	0.0002036054647760,
	0.0002063675492536,
	0.0002091624919558,
	0.0002119906275766,
	0.0002148522908101,
	0.0002177478309022,
	0.0002206775825471,
	0.0002236419095425,
	0.0002266411465826,
	0.0002296756429132,
	0.0002327457768843,
	0.0002358518831898,
	0.0002389943401795,
	0.0002421734970994,
	0.0002453897322994,
	0.0002486434241291,
	0.0002519349509384,
	0.0002552646619733,
	0.0002586329355836,
	0.0002620402083267,
	0.0002654868003447,
	0.0002689731481951,
	0.0002724996302277,
	0.0002760666538961,
	0.0002796745975502,
	0.0002833238686435,
	0.0002870148746297,
	0.0002907480229624,
	0.0002945237501990,
	0.0002983424346894,
	0.0003022045129910,
	0.0003061104216613,
	0.0003100605681539,
	0.0003140553599223,
	0.0003180952917319,
	0.0003221807419322,
	0.0003263122052886,
	0.0003304900601506,
	0.0003347148012836,
	0.0003389868652448,
	0.0003433066885918,
	0.0003476747660898,
	0.0003520915051922,
	0.0003565574297681,
	0.0003610729763750,
	0.0003656386106741,
	0.0003702548274305,
	0.0003749220923055,
	0.0003796409000643,
	0.0003844117163680,
	0.0003892350650858,
	0.0003941114118788,
	0.0003990412515122,
	0.0004040251078550,
	0.0004090634756722,
	0.0004141568788327,
	0.0004193058121018,
	0.0004245107993484,
	0.0004297723644413,
	0.0004350910312496,
	0.0004404673236422,
	0.0004459017945919,
	0.0004513949388638,
	0.0004569473385345,
	0.0004625595465768,
	0.0004682320577558,
	0.0004739654832520,
	0.0004797603760380,
	0.0004856172599830,
	0.0004915367462672,
	0.0004975193296559,
	0.0005035657086410,
	0.0005096763488837,
	0.0005158518324606,
	0.0005220928578638,
	0.0005283999489620,
	0.0005347736878321,
	0.0005412146565504,
	0.0005477235536091,
	0.0005543009028770,
	0.0005609473446384,
	0.0005676634609699,
	0.0005744499503635,
	0.0005813073948957,
	0.0005882364348508,
	0.0005952377105132,
	0.0006023118621670,
	0.0006094595300965,
	0.0006166813545860,
	0.0006239779759198,
	0.0006313501507975,
	0.0006387984030880,
	0.0006463235476986,
	0.0006539261084981,
	0.0006616069003940,
	0.0006693665054627,
	0.0006772056221962,
	0.0006851250655018,
	0.0006931253592484,
	0.0007012073183432,
	0.0007093716412783,
	0.0007176190265454,
	0.0007259501726367,
	0.0007343657780439,
	0.0007428666576743,
	0.0007514535100199,
	0.0007601270335726,
	0.0007688879850321,
	0.0007777371210977,
	0.0007866752566770,
	0.0007957030902617,
	0.0008048213203438,
	0.0008140308200382,
	0.0008233323460445,
	0.0008327266550623,
	0.0008422145619988,
	0.0008517968235537,
	0.0008614742546342,
	0.0008712476119399,
	0.0008811177685857,
	0.0008910854812711,
	0.0009011516231112,
	0.0009113169508055,
	0.0009215823374689,
	0.0009319486562163,
	0.0009424166637473,
	0.0009529872331768,
	0.0009636612376198,
	0.0009744394919835,
	0.0009853228693828,
	0.0009963123593479,
	0.0010074086021632,
	0.0010186126455665,
	0.0010299254208803,
	0.0010413476265967,
	0.0010528803104535,
	0.0010645242873579,
	0.0010762804886326,
	0.0010881498456001,
	0.0011001334059983,
	0.0011122318683192,
	0.0011244462803006,
	0.0011367775732651,
	0.0011492265621200,
	0.0011617945274338,
	0.0011744820512831,
	0.0011872902978212,
	0.0012002201983705,
	0.0012132728006691,
	0.0012264489196241,
	0.0012397497193888,
	0.0012531761312857,
	0.0012667289702222,
	0.0012804095167667,
	0.0012942187022418,
	0.0013081574579701,
	0.0013222268316895,
	0.0013364279875532,
	0.0013507617404684,
	0.0013652293710038,
	0.0013798316940665,
	0.0013945699902251,
	0.0014094451908022,
	0.0014244584599510,
	0.0014396107289940,
	0.0014549031620845,
	0.0014703368069604,
	0.0014859129441902,
	0.0015016323886812,
	0.0015174965374172,
	0.0015335063217208,
	0.0015496629057452,
	0.0015659673372284,
	0.0015824208967388,
	0.0015990247484297,
	0.0016157799400389,
	0.0016326875193045,
	0.0016497489996254,
	0.0016669651959091,
	0.0016843375051394,
	0.0017018669750541,
	0.0017195548862219,
	0.0017374025192112,
	0.0017554108053446,
	0.0017735812580213,
	0.0017919149249792,
	0.0018104130867869,
	0.0018290770240128,
	0.0018479077843949,
	0.0018669068813324,
	0.0018860754789785,
	0.0019054147414863,
	0.0019249260658398,
	0.0019446106161922,
	0.0019644696731120,
	0.0019845047499985,
	0.0020047170110047,
	0.0020251076202840,
	0.0020456782076508,
	0.0020664297044277,
	0.0020873637404293,
	0.0021084817126393,
	0.0021297845523804,
	0.0021512741222978,
	0.0021729513537139,
	0.0021948178764433,
	0.0022168750874698,
	0.0022391241509467,
	0.0022615666966885,
	0.0022842038888484,
	0.0023070373572409,
	0.0023300682660192,
	0.0023532982449979,
	0.0023767289239913,
	0.0024003612343222,
	0.0024241970386356,
	0.0024482375010848,
	0.0024724842514843,
	0.0024969386868179,
	0.0025216024369001,
	0.0025464768987149,
	0.0025715634692460,
	0.0025968637783080,
	0.0026223792228848,
	0.0026481114327908,
	0.0026740620378405,
	0.0027002322021872,
	0.0027266237884760,
	0.0027532381936908,
	0.0027800772804767,
	0.0028071419801563,
	0.0028344346210361,
	0.0028619563672692,
	0.0028897086158395,
	0.0029176934622228,
	0.0029459123034030,
	0.0029743667691946,
	0.0030030582565814,
	0.0030319888610393,
	0.0030611597467214,
	0.0030905727762729,
	0.0031202298123389,
	0.0031501322519034,
	0.0031802819576114,
	0.0032106803264469,
	0.0032413294538856,
	0.0032722307369113,
	0.0033033858053386,
	0.0033347967546433,
	0.0033664652146399,
	0.0033983925823122,
	0.0034305811859667,
	0.0034630321897566,
	0.0034957476891577,
	0.0035287293139845,
	0.0035619791597128,
	0.0035954986233264,
	0.0036292895674706,
	0.0036633540876210,
	0.0036976938135922,
	0.0037323106080294,
	0.0037672061007470,
	0.0038023823872209,
	0.0038378413300961,
	0.0038735845591873,
	0.0039096144028008,
	0.0039459322579205,
	0.0039825402200222,
	0.0040194396860898,
	0.0040566339157522,
	0.0040941233746707,
	0.0041319108568132,
	0.0041699977591634,
	0.0042083864100277,
	0.0042470786720514,
	0.0042860764078796,
	0.0043253819458187,
	0.0043649966828525,
	0.0044049229472876,
	0.0044451630674303,
	0.0044857184402645,
	0.0045265913940966,
	0.0045677837915719,
	0.0046092974953353,
	0.0046511352993548,
	0.0046932990662754,
	0.0047357901930809,
	0.0047786110080779,
	0.0048217643052340,
	0.0048652514815331,
	0.0049090743996203,
	0.0049532363191247,
	0.0049977381713688,
	0.0050425822846591,
	0.0050877714529634,
	0.0051333075389266,
	0.0051791924051940,
	0.0052254283800721,
	0.0052720177918673,
	0.0053189629688859,
	0.0053662657737732,
	0.0054139285348356,
	0.0054619535803795,
	0.0055103427730501,
	0.0055590989068151,
	0.0056082233786583,
	0.0056577194482088,
	0.0057075889781117,
	0.0057578342966735,
	0.0058084577322006,
	0.0058594611473382,
	0.0059108473360538,
	0.0059626186266541,
	0.0060147773474455,
	0.0060673253610730,
	0.0061202654615045,
	0.0061735995113850,
	0.0062273307703435,
	0.0062814611010253,
	0.0063359928317368,
	0.0063909282907844,
	0.0064462702721357,
	0.0065020206384361,
	0.0065581826493144,
	0.0066147577017546,
	0.0066717490553856,
	0.0067291590385139,
	0.0067869899794459,
	0.0068452442064881,
	0.0069039245136082,
	0.0069630332291126,
	0.0070225726813078,
	0.0070825461298227,
	0.0071429549716413,
	0.0072038029320538,
	0.0072650918737054,
	0.0073268241249025,
	0.0073890029452741,
	0.0074516306631267,
	0.0075147096067667,
	0.0075782425701618,
	0.0076422323472798,
	0.0077066812664270,
	0.0077715921215713,
	0.0078369677066803,
	0.0079028103500605,
	0.0079691223800182,
	0.0080359075218439,
	0.0081031676381826,
	0.0081709064543247,
	0.0082391249015927,
	0.0083078276365995,
	0.0083770155906677,
	0.0084466924890876,
	0.0085168611258268,
	0.0085875242948532,
	0.0086586847901344,
	0.0087303444743156,
	0.0088025070726871,
	0.0088751753792167,
	0.0089483512565494,
	0.0090220384299755,
	0.0090962396934628,
	0.0091709578409791,
	0.0092461956664920,
	0.0093219559639692,
	0.0093982415273786,
	0.0094750560820103,
	0.0095524005591869,
	0.0096302796155214,
	0.0097086951136589,
	0.0097876517102122,
	0.0098671494051814,
	0.0099471937865019,
	0.0100277876481414,
	0.0101089319214225,
	0.0101906312629580,
	0.0102728884667158,
	0.0103557063266635,
	0.0104390867054462,
	0.0105230351909995,
	0.0106075527146459,
	0.0106926430016756,
	0.0107783088460565,
	0.0108645539730787,
	0.0109513811767101,
	0.0110387923195958,
	0.0111267920583487,
	0.0112153831869364,
	0.0113045684993267,
	0.0113943517208099,
	0.0114847347140312,
	0.0115757212042809,
	0.0116673149168491,
	0.0117595186457038,
	0.0118523361161351,
	0.0119457691907883,
	0.0120398215949535,
	0.0121344970539212,
	0.0122297983616590,
	0.0123257292434573,
	0.0124222924932837,
	0.0125194909051061,
	0.0126173282042146,
	0.0127158081158996,
	0.0128149334341288,
	0.0129147069528699,
	0.0130151333287358,
	0.0131162144243717,
	0.0132179548963904,
	0.0133203566074371,
	0.0134234242141247,
	0.0135271595790982,
	0.0136315673589706,
	0.0137366512790322,
	0.0138424132019281,
	0.0139488577842712,
	0.0140559868887067,
	0.0141638061031699,
	0.0142723172903061,
	0.0143815241754055,
	0.0144914304837584,
	0.0146020390093327,
	0.0147133544087410,
	0.0148253785446286,
	0.0149381160736084,
	0.0150515707209706,
	0.0151657452806830,
	0.0152806425467134,
	0.0153962681069970,
	0.0155126238241792,
	0.0156297124922276,
	0.0157475396990776,
	0.0158661101013422,
	0.0159854236990213,
	0.0161054842174053,
	0.0162262991070747,
	0.0163478683680296,
	0.0164701975882053,
	0.0165932886302471,
	0.0167171452194452,
	0.0168417748063803,
	0.0169671755284071,
	0.0170933548361063,
	0.0172203145921230,
	0.0173480585217476,
	0.0174765922129154,
	0.0176059175282717,
	0.0177360381931067,
	0.0178669579327106,
	0.0179986823350191,
	0.0181312132626772,
	0.0182645544409752,
	0.0183987095952034,
	0.0185336824506521,
	0.0186694785952568,
	0.0188060998916626,
	0.0189435500651598,
	0.0190818347036839,
	0.0192209556698799,
	0.0193609185516834,
	0.0195017252117395,
	0.0196433793753386,
	0.0197858866304159,
	0.0199292507022619,
	0.0200734753161669,
	0.0202185641974211,
	0.0203645192086697,
	0.0205113459378481,
	0.0206590499728918,
	0.0208076313138008,
	0.0209570974111557,
	0.0211074519902468,
	0.0212586969137192,
	0.0214108359068632,
	0.0215638745576143,
	0.0217178165912628,
	0.0218726657330990,
	0.0220284257084131,
	0.0221851021051407,
	0.0223426949232817,
	0.0225012134760618,
	0.0226606559008360,
	0.0228210315108299,
	0.0229823421686888,
	0.0231445915997028,
	0.0233077835291624,
	0.0234719235450029,
	0.0236370135098696,
	0.0238030590116978,
	0.0239700656384230,
	0.0241380333900452,
	0.0243069697171450,
	0.0244768783450127,
	0.0246477611362934,
	0.0248196236789227,
	0.0249924715608358,
	0.0251663066446781,
	0.0253411345183849,
	0.0255169589072466,
	0.0256937816739082,
	0.0258716102689505,
	0.0260504484176636,
	0.0262302998453379,
	0.0264111664146185,
	0.0265930555760860,
	0.0267759710550308,
	0.0269599147140980,
	0.0271448921412230,
	0.0273309089243412,
	0.0275179669260979,
	0.0277060717344284,
	0.0278952289372683,
	0.0280854385346174,
	0.0282767098397017,
	0.0284690428525209,
	0.0286624450236559,
	0.0288569182157516,
	0.0290524680167437,
	0.0292491000145674,
	0.0294468160718679,
	0.0296456199139357,
	0.0298455189913511,
	0.0300465151667595,
	0.0302486140280962,
	0.0304518174380064,
	0.0306561347097158,
	0.0308615639805794,
	0.0310681145638227,
	0.0312757901847363,
	0.0314845927059650,
	0.0316945277154446,
	0.0319055989384651,
	0.0321178101003170,
	0.0323311686515808,
	0.0325456783175468,
	0.0327613428235054,
	0.0329781621694565,
	0.0331961475312710,
	0.0334152989089489,
	0.0336356237530708,
	0.0338571257889271,
	0.0340798087418079,
	0.0343036763370037,
	0.0345287322998047,
	0.0347549840807915,
	0.0349824316799641,
	0.0352110862731934,
	0.0354409441351891,
	0.0356720164418221,
	0.0359043031930923,
	0.0361378118395805,
	0.0363725461065769,
	0.0366085134446621,
	0.0368457101285458,
	0.0370841473340988,
	0.0373238250613213,
	0.0375647544860840,
	0.0378069356083870,
	0.0380503721535206,
	0.0382950678467751,
	0.0385410338640213,
	0.0387882664799690,
	0.0390367731451988,
	0.0392865613102913,
	0.0395376347005367,
	0.0397899933159351,
	0.0400436446070671,
	0.0402985960245132,
	0.0405548438429832,
	0.0408124029636383,
	0.0410712733864784,
	0.0413314551115036,
	0.0415929593145847,
	0.0418557897210121,
	0.0421199463307858,
	0.0423854365944862,
	0.0426522679626942,
	0.0429204404354095,
	0.0431899577379227,
	0.0434608310461044,
	0.0437330566346645,
	0.0440066456794739,
	0.0442816019058228,
	0.0445579253137112,
	0.0448356270790100,
	0.0451147034764290,
	0.0453951656818390,
	0.0456770174205303,
	0.0459602624177933,
	0.0462449043989182,
	0.0465309470891953,
	0.0468183979392052,
	0.0471072606742382,
	0.0473975390195847,
	0.0476892367005348,
	0.0479823574423790,
	0.0482769124209881,
	0.0485728979110718,
	0.0488703250885010,
	0.0491691976785660,
	0.0494695156812668,
	0.0497712828218937,
	0.0500745140016079,
	0.0503792017698288,
	0.0506853573024273,
	0.0509929843246937,
	0.0513020865619183,
	0.0516126714646816,
	0.0519247390329838,
	0.0522382967174053,
	0.0525533482432365,
	0.0528698973357677,
	0.0531879514455795,
	0.0535075105726719,
	0.0538285858929157,
	0.0541511736810207,
	0.0544752851128578,
	0.0548009239137173,
	0.0551280938088894,
	0.0554567947983742,
	0.0557870380580425,
	0.0561188273131847,
	0.0564521625638008,
	0.0567870549857616,
	0.0571235045790672,
	0.0574615150690079,
	0.0578010939061642,
	0.0581422448158264,
	0.0584849715232849,
	0.0588292814791203,
	0.0591751746833324,
	0.0595226585865021,
	0.0598717369139194,
	0.0602224133908749,
	0.0605746954679489,
	0.0609285868704319,
	0.0612840875983238,
	0.0616412088274956,
	0.0619999505579472,
	0.0623603202402592,
	0.0627223178744316,
	0.0630859583616257,
	0.0634512305259705,
	0.0638181492686272,
	0.0641867220401764,
	0.0645569413900375,
	0.0649288222193718,
	0.0653023645281792,
	0.0656775757670403,
	0.0660544633865356,
	0.0664330199360847,
	0.0668132603168488,
	0.0671951845288277,
	0.0675787925720215,
	0.0679640993475914,
	0.0683511123061180,
	0.0687398165464401,
	0.0691302344202995,
	0.0695223584771156,
	0.0699162036180496,
	0.0703117698431015,
	0.0707090646028519,
	0.0711080804467201,
	0.0715088322758675,
	0.0719113275408745,
	0.0723155662417412,
	0.0727215483784676,
	0.0731292814016342,
	0.0735387727618217,
	0.0739500224590302,
	0.0743630379438400,
	0.0747778192162514,
	0.0751943737268448,
	0.0756127089262009,
	0.0760328248143196,
	0.0764547288417816,
	0.0768784284591675,
	0.0773039162158966,
	0.0777312070131302,
	0.0781603008508682,
	0.0785911977291107,
	0.0790239125490189,
	0.0794584378600121,
	0.0798947885632515,
	0.0803329646587372,
	0.0807729735970497,
	0.0812148079276085,
	0.0816584825515747,
	0.0821040049195290,
	0.0825513675808907,
	0.0830005854368210,
	0.0834516510367393,
	0.0839045792818069,
	0.0843593701720238,
	0.0848160311579704,
	0.0852745622396469,
	0.0857349634170532,
	0.0861972495913506,
	0.0866614207625389,
	0.0871274769306183,
	0.0875954255461693,
	0.0880652666091919,
	0.0885370150208473,
	0.0890106633305550,
	0.0894862189888954,
	0.0899636894464493,
	0.0904430747032166,
	0.0909243822097778,
	0.0914076119661331,
	0.0918927714228630,
	0.0923798605799675,
	0.0928688868880272,
	0.0933598503470421,
	0.0938527658581734,
	0.0943476259708405,
	0.0948444381356239,
	0.0953432023525238,
	0.0958439335227013,
	0.0963466241955757,
	0.0968512818217278,
	0.0973579138517380,
	0.0978665202856064,
	0.0983771011233330,
	0.0988896712660789,
	0.0994042232632637,
	0.0999207720160484,
	0.1004393100738525,
	0.1009598448872566,
	0.1014823839068413,
	0.1020069271326065,
	0.1025334820151329,
	0.1030620485544205,
	0.1035926342010498,
	0.1041252389550209,
	0.1046598702669144,
	0.1051965206861496,
	0.1057352125644684,
	0.1062759310007095,
	0.1068186908960342,
	0.1073634922504425,
	0.1079103425145149,
	0.1084592342376709,
	0.1090101897716522,
	0.1095631942152977,
	0.1101182550191879,
	0.1106753870844841,
	0.1112345829606056,
	0.1117958426475525,
	0.1123591810464859,
	0.1129245981574059,
	0.1134920939803123,
	0.1140616759657860,
	0.1146333366632462,
	0.1152070984244347,
	0.1157829463481903,
	0.1163608878850937,
	0.1169409379363060,
	0.1175230890512466,
	0.1181073486804962,
	0.1186937093734741,
	0.1192821934819221,
	0.1198727861046791,
	0.1204655021429062,
	0.1210603415966034,
	0.1216573044657707,
	0.1222563982009888,
	0.1228576228022575,
	0.1234609857201576,
	0.1240664795041084,
	0.1246741190552711,
	0.1252839118242264,
	0.1258958280086517,
	0.1265099197626114,
	0.1271261423826218,
	0.1277445405721664,
	0.1283650845289230,
	0.1289877891540527,
	0.1296126693487167,
	0.1302397102117538,
	0.1308689266443253,
	0.1315003037452698,
	0.1321338713169098,
	0.1327696144580841,
	0.1334075331687927,
	0.1340476274490356,
	0.1346899271011353,
	0.1353344023227692,
	0.1359810829162598,
	0.1366299390792847,
	0.1372810155153275,
	0.1379342675209045,
	0.1385897397994995,
	0.1392474025487900,
	0.1399072855710983,
	0.1405693739652634,
	0.1412336677312851,
	0.1419001966714859,
	0.1425689160823822,
	0.1432398706674576,
	0.1439130455255508,
	0.1445884406566620,
	0.1452660709619522,
	0.1459459215402603,
	0.1466280072927475,
	0.1473123133182526,
	0.1479988694190979,
	0.1486876606941223,
	0.1493786871433258,
	0.1500719636678696,
	0.1507674753665924,
	0.1514652371406555,
	0.1521652489900589,
	0.1528675109148026,
	0.1535720229148865,
	0.1542787849903107,
	0.1549877971410751,
	0.1556990742683411,
	0.1564126163721085,
	0.1571284234523773,
	0.1578464806079865,
	0.1585668176412582,
	0.1592894047498703,
	0.1600142717361450,
	0.1607414186000824,
	0.1614708155393600,
	0.1622025072574615,
	0.1629364639520645,
	0.1636727005243301,
	0.1644112020730972,
	0.1651519984006882,
	0.1658950746059418,
	0.1666404306888580,
	0.1673880815505981,
	0.1681380122900009,
	0.1688902229070663,
	0.1696447432041168,
	0.1704015284776688,
	0.1711606234312057,
	0.1719219982624054,
	0.1726856827735901,
	0.1734516471624374,
	0.1742199212312698,
	0.1749904900789261,
	0.1757633537054062,
	0.1765385121107101,
	0.1773159801959991,
	0.1780957579612732,
	0.1788778156042099,
	0.1796621978282928,
	0.1804488748311996,
	0.1812378615140915,
	0.1820291578769684,
	0.1828227639198303,
	0.1836186796426773,
	0.1844168901443481,
	0.1852174252271652,
	0.1860202699899673,
	0.1868254244327545,
	0.1876328885555267,
	0.1884426623582840,
	0.1892547607421875,
	0.1900691539049149,
	0.1908858865499496,
	0.1917049139738083,
	0.1925262659788132,
	0.1933499276638031,
	0.1941759139299393,
	0.1950042247772217,
	0.1958348304033279,
	0.1966677755117416,
	0.1975030303001404,
	0.1983405947685242,
	0.1991804838180542,
	0.2000226974487305,
	0.2008672207593918,
	0.2017140537500381,
	0.2025632262229919,
	0.2034147083759308,
	0.2042685002088547,
	0.2051246166229248,
	0.2059830576181412,
	0.2068438082933426,
	0.2077068835496902,
	0.2085722833871841,
	0.2094399929046631,
	0.2103100121021271,
	0.2111823558807373,
	0.2120570242404938,
	0.2129340022802353,
	0.2138132899999619,
	0.2146949023008347,
	0.2155788242816925,
	0.2164650708436966,
	0.2173536121845245,
	0.2182444781064987,
	0.2191376686096191,
	0.2200331538915634,
	0.2209309637546539,
	0.2218310683965683,
	0.2227334976196289,
	0.2236382365226746,
	0.2245452702045441,
	0.2254546284675598,
	0.2263662815093994,
	0.2272802442312241,
	0.2281965166330338,
	0.2291150838136673,
	0.2300359457731247,
	0.2309591323137283,
	0.2318845987319946,
	0.2328123748302460,
	0.2337424457073212,
	0.2346748113632202,
	0.2356094717979431,
	0.2365464419126511,
	0.2374856919050217,
	0.2384272217750549,
	0.2393710613250732,
	0.2403171807527542,
	0.2412655800580978,
	0.2422162741422653,
	0.2431692481040955,
	0.2441245019435883,
	0.2450820356607437,
	0.2460418492555618,
	0.2470039427280426,
	0.2479683011770248,
	0.2489349395036697,
	0.2499038577079773,
	0.2508750259876251,
	0.2518484890460968,
	0.2528241872787476,
	0.2538021504878998,
	0.2547823786735535,
	0.2557648718357086,
	0.2567496299743652,
	0.2577366530895233,
	0.2587258815765381,
	0.2597174048423767,
	0.2607111632823944,
	0.2617071568965912,
	0.2627053856849670,
	0.2637058794498444,
	0.2647085785865784,
	0.2657135426998138,
	0.2667207121849060,
	0.2677301466464996,
	0.2687417864799500,
	0.2697556614875793,
	0.2707717418670654,
	0.2717900574207306,
	0.2728105783462524,
	0.2738333046436310,
	0.2748582363128662,
	0.2758854031562805,
	0.2769147455692291,
	0.2779463231563568,
	0.2789800763130188,
	0.2800160348415375,
	0.2810541689395905,
	0.2820945084095001,
	0.2831370234489441,
	0.2841817140579224,
	0.2852285802364349,
	0.2862776219844818,
	0.2873288691043854,
	0.2883822619915009,
	0.2894378006458282,
	0.2904955148696899,
	0.2915554046630859,
	0.2926174104213715,
	0.2936815917491913,
	0.2947479188442230,
	0.2958163917064667,
	0.2968869805335999,
	0.2979597151279449,
	0.2990345954895020,
	0.3001115918159485,
	0.3011907041072845,
	0.3022719621658325,
	0.3033553063869476,
	0.3044407665729523,
	0.3055283427238464,
	0.3066180050373077,
	0.3077097833156586,
	0.3088036477565765,
	0.3098995983600616,
	0.3109976351261139,
	0.3120977282524109,
	0.3131999373435974,
	0.3143042027950287,
	0.3154105246067047,
	0.3165189027786255,
	0.3176293671131134,
	0.3187418580055237,
	0.3198564052581787,
	0.3209730088710785,
	0.3220916390419006,
	0.3232122957706451,
	0.3243349790573120,
	0.3254597187042236,
	0.3265864253044128,
	0.3277151882648468,
	0.3288459479808807,
	0.3299787044525146,
	0.3311134576797485,
	0.3322502076625824,
	0.3333889245986938,
	0.3345296382904053,
	0.3356723487377167,
	0.3368169963359833,
	0.3379636108875275,
	0.3391122221946716,
	0.3402627408504486,
	0.3414152562618256,
	0.3425696790218353,
	0.3437260389328003,
	0.3448843359947205,
	0.3460445702075958,
	0.3472067117691040,
	0.3483707904815674,
	0.3495367467403412,
	0.3507046401500702,
	0.3518743813037872,
	0.3530460596084595,
	0.3542195856571198,
	0.3553950190544128,
	0.3565723001956940,
	0.3577514588832855,
	0.3589324653148651,
	0.3601153492927551,
	0.3613000512123108,
	0.3624866008758545,
	0.3636749982833862,
	0.3648651838302612,
	0.3660572171211243,
	0.3672510683536530,
	0.3684467375278473,
	0.3696441650390625,
	0.3708434402942657,
	0.3720444440841675,
	0.3732472658157349,
	0.3744518458843231,
	0.3756582140922546,
	0.3768663108348846,
	0.3780761659145355,
	0.3792877793312073,
	0.3805011212825775,
	0.3817161917686462,
	0.3829329907894135,
	0.3841515183448792,
	0.3853717446327209,
	0.3865936696529388,
	0.3878172636032104,
	0.3890425860881805,
	0.3902695477008820,
	0.3914982080459595,
	0.3927285373210907,
	0.3939605057239532,
	0.3951941430568695,
	0.3964293897151947,
	0.3976663053035736,
	0.3989048302173615,
	0.4001449644565582,
	0.4013867080211639,
	0.4026300609111786,
	0.4038750231266022,
	0.4051215350627899,
	0.4063696563243866,
	0.4076193273067474,
	0.4088705778121948,
	0.4101233780384064,
	0.4113776981830597,
	0.4126335978507996,
	0.4138909876346588,
	0.4151499271392822,
	0.4164103567600250,
	0.4176723062992096,
	0.4189357161521912,
	0.4202006459236145,
	0.4214670360088348,
	0.4227349162101746,
	0.4240042567253113,
	0.4252750277519226,
	0.4265472590923309,
	0.4278208911418915,
	0.4290959835052490,
	0.4303724765777588,
	0.4316504001617432,
	0.4329296946525574,
	0.4342103898525238,
	0.4354924559593201,
	0.4367758929729462,
	0.4380607008934021,
	0.4393468797206879,
	0.4406343698501587,
	0.4419232010841370,
	0.4432133734226227,
	0.4445048272609711,
	0.4457976222038269,
	0.4470916986465454,
	0.4483870565891266,
	0.4496837258338928,
	0.4509816169738770,
	0.4522807896137238,
	0.4535812139511108,
	0.4548828601837158,
	0.4561857581138611,
	0.4574898779392242,
	0.4587951898574829,
	0.4601016938686371,
	0.4614093899726868,
	0.4627182781696320,
	0.4640283286571503,
	0.4653395712375641,
	0.4666519165039062,
	0.4679654240608215,
	0.4692800641059875,
	0.4705958068370819,
	0.4719126820564270,
	0.4732306301593781,
	0.4745496809482574,
	0.4758698046207428,
	0.4771910011768341,
	0.4785132408142090,
	0.4798365533351898,
	0.4811608791351318,
	0.4824862480163574,
	0.4838126003742218,
	0.4851399958133698,
	0.4864683449268341,
	0.4877977073192596,
	0.4891280233860016,
	0.4904593229293823,
	0.4917915463447571,
	0.4931247234344482,
	0.4944588243961334,
	0.4957938492298126,
	0.4971297681331635,
	0.4984666109085083,
	0.4998043179512024,
	0.5011428594589233,
	0.5024823546409607,
	0.5038226246833801,
	0.5051637291908264,
	0.5065057277679443,
	0.5078485012054443,
	0.5091920495033264,
	0.5105364322662354,
	0.5118815898895264,
	0.5132275223731995,
	0.5145742297172546,
	0.5159216523170471,
	0.5172698497772217,
	0.5186187624931335,
	0.5199683308601379,
	0.5213186740875244,
	0.5226696729660034,
	0.5240213871002197,
	0.5253736972808838,
	0.5267267227172852,
	0.5280803442001343,
	0.5294346213340759,
	0.5307895541191101,
	0.5321450233459473,
	0.5335011482238770,
	0.5348578095436096,
	0.5362150669097900,
	0.5375728607177734,
	0.5389311909675598,
	0.5402901172637939,
	0.5416495203971863,
	0.5430094599723816,
	0.5443698763847351,
	0.5457307696342468,
	0.5470921397209167,
	0.5484539866447449,
	0.5498162508010864,
	0.5511789917945862,
	0.5525420904159546,
	0.5539056658744812,
	0.5552695989608765,
	0.5566339492797852,
	0.5579986572265625,
	0.5593637228012085,
	0.5607291460037231,
	0.5620948672294617,
	0.5634609460830688,
	0.5648273229598999,
	0.5661939978599548,
	0.5675609707832336,
	0.5689282417297363,
	0.5702956914901733,
	0.5716634392738342,
	0.5730314254760742,
	0.5743995904922485,
	0.5757679939270020,
	0.5771365761756897,
	0.5785053372383118,
	0.5798742175102234,
	0.5812433362007141,
	0.5826125144958496,
	0.5839818716049194,
	0.5853513479232788,
	0.5867208838462830,
	0.5880905389785767,
	0.5894602537155151,
	0.5908300876617432,
	0.5921998620033264,
	0.5935697555541992,
	0.5949396491050720,
	0.5963095426559448,
	0.5976794362068176,
	0.5990492701530457,
	0.6004191040992737,
	0.6017888784408569,
	0.6031585931777954,
	0.6045282483100891,
	0.6058977842330933,
	0.6072672605514526,
	0.6086366176605225,
	0.6100057959556580,
	0.6113749146461487,
	0.6127437949180603,
	0.6141125559806824,
	0.6154810786247253,
	0.6168494820594788,
	0.6182175874710083,
	0.6195855140686035,
	0.6209532022476196,
	0.6223206520080566,
	0.6236878037452698,
	0.6250546574592590,
	0.6264212727546692,
	0.6277875304222107,
	0.6291534900665283,
	0.6305190920829773,
	0.6318843364715576,
	0.6332492232322693,
	0.6346137523651123,
	0.6359778642654419,
	0.6373416185379028,
	0.6387048959732056,
	0.6400677561759949,
	0.6414301395416260,
	0.6427920460700989,
	0.6441535353660583,
	0.6455144882202148,
	0.6468749642372131,
	0.6482348442077637,
	0.6495942473411560,
	0.6509531140327454,
	0.6523113846778870,
	0.6536690592765808,
	0.6550261974334717,
	0.6563826799392700,
	0.6577385663986206,
	0.6590937972068787,
	0.6604483723640442,
	0.6618022918701172,
	0.6631554961204529,
	0.6645080447196960,
	0.6658598780632019,
	0.6672109961509705,
	0.6685613393783569,
	0.6699109673500061,
	0.6712598204612732,
	0.6726078391075134,
	0.6739550828933716,
	0.6753015518188477,
	0.6766471862792969,
	0.6779919266700745,
	0.6793358922004700,
	0.6806789040565491,
	0.6820210814476013,
	0.6833623647689819,
	0.6847026944160461,
	0.6860421299934387,
	0.6873805522918701,
	0.6887180805206299,
	0.6900546550750732,
	0.6913901567459106,
	0.6927247047424316,
	0.6940582394599915,
	0.6953907608985901,
	0.6967221498489380,
	0.6980525851249695,
	0.6993818283081055,
	0.7007100582122803,
	0.7020371556282043,
	0.7033631205558777,
	0.7046879529953003,
	0.7060116529464722,
	0.7073341608047485,
	0.7086555361747742,
	0.7099756598472595,
	0.7112945914268494,
	0.7126122713088989,
	0.7139286994934082,
	0.7152439355850220,
	0.7165578603744507,
	0.7178704738616943,
	0.7191818356513977,
	0.7204918265342712,
	0.7218005061149597,
	0.7231078743934631,
	0.7244138121604919,
	0.7257184386253357,
	0.7270216345787048,
	0.7283234596252441,
	0.7296237945556641,
	0.7309227585792542,
	0.7322202324867249,
	0.7335162758827209,
	0.7348108291625977,
	0.7361038327217102,
	0.7373954057693481,
	0.7386853694915771,
	0.7399738430976868,
	0.7412607669830322,
	0.7425460815429688,
	0.7438298463821411,
	0.7451119422912598,
	0.7463924884796143,
	0.7476713657379150,
	0.7489486336708069,
	0.7502242326736450,
	0.7514981031417847,
	0.7527703046798706,
	0.7540408372879028,
	0.7553096413612366,
	0.7565766572952271,
	0.7578419446945190,
	0.7591055035591125,
	0.7603672146797180,
	0.7616271972656250,
	0.7628853321075439,
	0.7641416192054749,
	0.7653960585594177,
	0.7666487097740173,
	0.7678994536399841,
	0.7691482901573181,
	0.7703952193260193,
	0.7716402411460876,
	0.7728833556175232,
	0.7741245031356812,
	0.7753636837005615,
	0.7766008973121643,
	0.7778361439704895,
	0.7790693044662476,
	0.7803004980087280,
	0.7815296649932861,
	0.7827568054199219,
	0.7839818000793457,
	0.7852047681808472,
	0.7864256501197815,
	0.7876443862915039,
	0.7888610363006592,
	0.7900754809379578,
	0.7912878394126892,
	0.7924979925155640,
	0.7937059402465820,
	0.7949117422103882,
	0.7961152791976929,
	0.7973166108131409,
	0.7985157370567322,
	0.7997125387191772,
	0.8009071350097656,
	0.8020994067192078,
	0.8032893538475037,
	0.8044769763946533,
	0.8056623339653015,
	0.8068453073501587,
	0.8080258965492249,
	0.8092041015625000,
	0.8103799819946289,
	0.8115534186363220,
	0.8127244114875793,
	0.8138930201530457,
	0.8150591254234314,
	0.8162228465080261,
	0.8173840045928955,
	0.8185427188873291,
	0.8196989297866821,
	0.8208525776863098,
	0.8220037221908569,
	0.8231523036956787,
	0.8242983222007751,
	0.8254417777061462,
	0.8265826702117920,
	0.8277208805084229,
	0.8288565278053284,
	0.8299894928932190,
	0.8311198353767395,
	0.8322474956512451,
	0.8333725333213806,
	0.8344948291778564,
	0.8356144428253174,
	0.8367313146591187,
	0.8378454446792603,
	0.8389568328857422,
	0.8400654196739197,
	0.8411712646484375,
	0.8422743678092957,
	0.8433746099472046,
	0.8444720506668091,
	0.8455666303634644,
	0.8466583490371704,
	0.8477472662925720,
	0.8488332629203796,
	0.8499163985252380,
	0.8509966135025024,
	0.8520739078521729,
	0.8531482815742493,
	0.8542197346687317,
	0.8552882075309753,
	0.8563537001609802,
	0.8574162125587463,
	0.8584756851196289,
	0.8595321774482727,
	0.8605856299400330,
	0.8616361021995544,
	0.8626834750175476,
	0.8637277483940125,
	0.8647689819335938,
	0.8658071160316467,
	0.8668421506881714,
	0.8678740859031677,
	0.8689028024673462,
	0.8699284791946411,
	0.8709509372711182,
	0.8719701766967773,
	0.8729863166809082,
	0.8739991784095764,
	0.8750088810920715,
	0.8760153055191040,
	0.8770185112953186,
	0.8780184984207153,
	0.8790152072906494,
	0.8800085783004761,
	0.8809987306594849,
	0.8819855451583862,
	0.8829690217971802,
	0.8839492201805115,
	0.8849260210990906,
	0.8858994841575623,
	0.8868696093559265,
	0.8878362774848938,
	0.8887996077537537,
	0.8897595405578613,
	0.8907160162925720,
	0.8916690349578857,
	0.8926186561584473,
	0.8935648202896118,
	0.8945075273513794,
	0.8954467177391052,
	0.8963823914527893,
	0.8973146080970764,
	0.8982432484626770,
	0.8991683721542358,
	0.9000899791717529,
	0.9010080099105835,
	0.9019225239753723,
	0.9028334021568298,
	0.9037407040596008,
	0.9046443700790405,
	0.9055444598197937,
	0.9064408540725708,
	0.9073336720466614,
	0.9082227945327759,
	0.9091082811355591,
	0.9099900722503662,
	0.9108682274818420,
	0.9117426276206970,
	0.9126133322715759,
	0.9134802818298340,
	0.9143435359001160,
	0.9152030348777771,
	0.9160587787628174,
	0.9169107079505920,
	0.9177589416503906,
	0.9186033010482788,
	0.9194439053535461,
	0.9202806353569031,
	0.9211136102676392,
	0.9219427108764648,
	0.9227679967880249,
	0.9235893487930298,
	0.9244068861007690,
	0.9252205491065979,
	0.9260302782058716,
	0.9268361330032349,
	0.9276380538940430,
	0.9284360408782959,
	0.9292301535606384,
	0.9300202727317810,
	0.9308063983917236,
	0.9315885901451111,
	0.9323668479919434,
	0.9331410527229309,
	0.9339112639427185,
	0.9346774816513062,
	0.9354397058486938,
	0.9361978769302368,
	0.9369519948959351,
	0.9377020597457886,
	0.9384480118751526,
	0.9391899704933167,
	0.9399278163909912,
	0.9406616091728210,
	0.9413912296295166,
	0.9421167969703674,
	0.9428381919860840,
	0.9435554742813110,
	0.9442686438560486,
	0.9449776411056519,
	0.9456824660301208,
	0.9463831186294556,
	0.9470795989036560,
	0.9477719068527222,
	0.9484599828720093,
	0.9491438865661621,
	0.9498235583305359,
	0.9504989981651306,
	0.9511702060699463,
	0.9518371224403381,
	0.9524998664855957,
	0.9531582593917847,
	0.9538124203681946,
	0.9544622898101807,
	0.9551079273223877,
	0.9557492136955261,
	0.9563861489295959,
	0.9570188522338867,
	0.9576472043991089,
	0.9582712054252625,
	0.9588908553123474,
	0.9595061540603638,
	0.9601171016693115,
	0.9607236385345459,
	0.9613258838653564,
	0.9619236588478088,
	0.9625170826911926,
	0.9631060957908630,
	0.9636906981468201,
	0.9642708897590637,
	0.9648466706275940,
	0.9654179811477661,
	0.9659848809242249,
	0.9665473103523254,
	0.9671052694320679,
	0.9676588177680969,
	0.9682078361511230,
	0.9687523841857910,
	0.9692924618721008,
	0.9698280692100525,
	0.9703590869903564,
	0.9708856940269470,
	0.9714077115058899,
	0.9719252586364746,
	0.9724382162094116,
	0.9729466438293457,
	0.9734505414962769,
	0.9739499092102051,
	0.9744446873664856,
	0.9749349355697632,
	0.9754205346107483,
	0.9759016036987305,
	0.9763780832290649,
	0.9768499732017517,
	0.9773172736167908,
	0.9777799248695374,
	0.9782379865646362,
	0.9786914587020874,
	0.9791402220726013,
	0.9795844554901123,
	0.9800239801406860,
	0.9804588556289673,
	0.9808891415596008,
	0.9813147187232971,
	0.9817356467247009,
	0.9821518659591675,
	0.9825634956359863,
	0.9829703569412231,
	0.9833725690841675,
	0.9837701320648193,
	0.9841629266738892,
	0.9845510721206665,
	0.9849345088005066,
	0.9853131771087646,
	0.9856871962547302,
	0.9860564470291138,
	0.9864209294319153,
	0.9867807626724243,
	0.9871358275413513,
	0.9874861240386963,
	0.9878317117691040,
	0.9881724715232849,
	0.9885085225105286,
	0.9888398051261902,
	0.9891663789749146,
	0.9894881248474121,
	0.9898050427436829,
	0.9901172518730164,
	0.9904246330261230,
	0.9907272458076477,
	0.9910250902175903,
	0.9913181066513062,
	0.9916062951087952,
	0.9918897151947021,
	0.9921683073043823,
	0.9924420714378357,
	0.9927110671997070,
	0.9929751753807068,
	0.9932345151901245,
	0.9934889674186707,
	0.9937386512756348,
	0.9939834475517273,
	0.9942234158515930,
	0.9944585561752319,
	0.9946888685226440,
	0.9949142932891846,
	0.9951348304748535,
	0.9953505992889404,
	0.9955614209175110,
	0.9957674145698547,
	0.9959685802459717,
	0.9961648583412170,
	0.9963562488555908,
	0.9965427517890930,
	0.9967243671417236,
	0.9969011545181274,
	0.9970730543136597,
	0.9972400069236755,
	0.9974021315574646,
	0.9975593686103821,
	0.9977117180824280,
	0.9978591203689575,
	0.9980016946792603,
	0.9981393218040466,
	0.9982721209526062,
	0.9983999729156494,
	0.9985228776931763,
	0.9986409544944763,
	0.9987540841102600,
	0.9988623261451721,
	0.9989656209945679,
	0.9990640282630920,
	0.9991575479507446,
	0.9992461204528809,
	0.9993298053741455,
	0.9994085431098938,
	0.9994823932647705,
	0.9995512962341309,
	0.9996153116226196,
	0.9996743798255920,
	0.9997285604476929,
	0.9997777938842773,
	0.9998220801353455,
	0.9998614788055420,
	0.9998959898948669,
	0.9999254941940308,
	0.9999501109123230,
	0.9999698400497437,
	0.9999846220016479,
	0.9999944567680359,
	0.9999994039535522,
	0.9999994039535522,
	0.9999944567680359,
	0.9999846220016479,
	0.9999698400497437,
	0.9999501109123230,
	0.9999254941940308,
	0.9998959302902222,
	0.9998614788055420,
	0.9998220801353455,
	0.9997777938842773,
	0.9997285604476929,
	0.9996743798255920,
	0.9996153116226196,
	0.9995512962341309,
	0.9994823932647705,
	0.9994085431098938,
	0.9993298053741455,
	0.9992461204528809,
	0.9991575479507446,
	0.9990640282630920,
	0.9989656209945679,
	0.9988622665405273,
	0.9987540841102600,
	0.9986408948898315,
	0.9985228776931763,
	0.9983999133110046,
	0.9982720613479614,
	0.9981393218040466,
	0.9980016946792603,
	0.9978591203689575,
	0.9977117180824280,
	0.9975593686103821,
	0.9974021315574646,
	0.9972400069236755,
	0.9970729947090149,
	0.9969011545181274,
	0.9967243671417236,
	0.9965427517890930,
	0.9963561892509460,
	0.9961647987365723,
	0.9959685206413269,
	0.9957674145698547,
	0.9955614209175110,
	0.9953505396842957,
	0.9951348304748535,
	0.9949142336845398,
	0.9946888089179993,
	0.9944585561752319,
	0.9942234158515930,
	0.9939834475517273,
	0.9937385916709900,
	0.9934889674186707,
	0.9932344555854797,
	0.9929751753807068,
	0.9927110075950623,
	0.9924420714378357,
	0.9921683073043823,
	0.9918897151947021,
	0.9916062951087952,
	0.9913180470466614,
	0.9910250306129456,
	0.9907272458076477,
	0.9904246330261230,
	0.9901171922683716,
	0.9898050427436829,
	0.9894880652427673,
	0.9891663193702698,
	0.9888398051261902,
	0.9885085225105286,
	0.9881724715232849,
	0.9878316521644592,
	0.9874860644340515,
	0.9871357679367065,
	0.9867807030677795,
	0.9864209294319153,
	0.9860563874244690,
	0.9856871366500854,
	0.9853131175041199,
	0.9849344491958618,
	0.9845510125160217,
	0.9841628670692444,
	0.9837700724601746,
	0.9833725690841675,
	0.9829703569412231,
	0.9825634360313416,
	0.9821518659591675,
	0.9817355871200562,
	0.9813146591186523,
	0.9808890819549561,
	0.9804587960243225,
	0.9800239205360413,
	0.9795843958854675,
	0.9791402220726013,
	0.9786913990974426,
	0.9782379269599915,
	0.9777798652648926,
	0.9773172140121460,
	0.9768499135971069,
	0.9763780236244202,
	0.9759015440940857,
	0.9754205346107483,
	0.9749348759651184,
	0.9744446277618408,
	0.9739498496055603,
	0.9734504818916321,
	0.9729465842247009,
	0.9724381566047668,
	0.9719251990318298,
	0.9714076519012451,
	0.9708856344223022,
	0.9703590273857117,
	0.9698280096054077,
	0.9692924022674561,
	0.9687523245811462,
	0.9682077765464783,
	0.9676587581634521,
	0.9671052098274231,
	0.9665472507476807,
	0.9659848213195801,
	0.9654179215431213,
	0.9648466110229492,
	0.9642708301544189,
	0.9636906385421753,
	0.9631060361862183,
	0.9625170230865479,
	0.9619235992431641,
	0.9613257646560669,
	0.9607235789299011,
	0.9601170420646667,
	0.9595060944557190,
	0.9588907361030579,
	0.9582710862159729,
	0.9576470851898193,
	0.9570187926292419,
	0.9563860893249512,
	0.9557490944862366,
	0.9551078081130981,
	0.9544622302055359,
	0.9538123607635498,
	0.9531581997871399,
	0.9524997472763062,
	0.9518370628356934,
	0.9511700868606567,
	0.9504988789558411,
	0.9498234391212463,
	0.9491438269615173,
	0.9484599232673645,
	0.9477718472480774,
	0.9470795392990112,
	0.9463830590248108,
	0.9456824064254761,
	0.9449775218963623,
	0.9442685842514038,
	0.9435554146766663,
	0.9428381323814392,
	0.9421166777610779,
	0.9413911700248718,
	0.9406614899635315,
	0.9399277567863464,
	0.9391899108886719,
	0.9384479522705078,
	0.9377019405364990,
	0.9369518756866455,
	0.9361977577209473,
	0.9354395866394043,
	0.9346774220466614,
	0.9339112043380737,
	0.9331409931182861,
	0.9323667287826538,
	0.9315885305404663,
	0.9308063387870789,
	0.9300201535224915,
	0.9292300343513489,
	0.9284359812736511,
	0.9276379942893982,
	0.9268360137939453,
	0.9260302186012268,
	0.9252204298973083,
	0.9244068264961243,
	0.9235892891883850,
	0.9227678775787354,
	0.9219425916671753,
	0.9211134910583496,
	0.9202805757522583,
	0.9194437861442566,
	0.9186031818389893,
	0.9177588224411011,
	0.9169106483459473,
	0.9160586595535278,
	0.9152029156684875,
	0.9143434166908264,
	0.9134802222251892,
	0.9126132130622864,
	0.9117425084114075,
	0.9108681082725525,
	0.9099900126457214,
	0.9091082215309143,
	0.9082227349281311,
	0.9073335528373718,
	0.9064407944679260,
	0.9055443406105042,
	0.9046442508697510,
	0.9037405848503113,
	0.9028332829475403,
	0.9019224047660828,
	0.9010079503059387,
	0.9000898599624634,
	0.8991683125495911,
	0.8982431292533875,
	0.8973144888877869,
	0.8963822722434998,
	0.8954465985298157,
	0.8945074081420898,
	0.8935647010803223,
	0.8926185369491577,
	0.8916689753532410,
	0.8907158970832825,
	0.8897594213485718,
	0.8887994885444641,
	0.8878361582756042,
	0.8868694901466370,
	0.8858993649482727,
	0.8849259018898010,
	0.8839491009712219,
	0.8829689025878906,
	0.8819854259490967,
	0.8809986114501953,
	0.8800085186958313,
	0.8790150880813599,
	0.8780183792114258,
	0.8770184516906738,
	0.8760151863098145,
	0.8750087618827820,
	0.8739990592002869,
	0.8729861974716187,
	0.8719700574874878,
	0.8709508180618286,
	0.8699283599853516,
	0.8689026832580566,
	0.8678739666938782,
	0.8668420314788818,
	0.8658069968223572,
	0.8647688627243042,
	0.8637276291847229,
	0.8626833558082581,
	0.8616359829902649,
	0.8605855107307434,
	0.8595320582389832,
	0.8584755659103394,
	0.8574160337448120,
	0.8563535809516907,
	0.8552880287170410,
	0.8542196154594421,
	0.8531481623649597,
	0.8520737886428833,
	0.8509964942932129,
	0.8499162793159485,
	0.8488331437110901,
	0.8477471470832825,
	0.8466582298278809,
	0.8455665111541748,
	0.8444718718528748,
	0.8433744907379150,
	0.8422742486000061,
	0.8411711454391479,
	0.8400653004646301,
	0.8389567136764526,
	0.8378453254699707,
	0.8367311358451843,
	0.8356142640113831,
	0.8344947099685669,
	0.8333724141120911,
	0.8322473764419556,
	0.8311197161674500,
	0.8299893736839294,
	0.8288564085960388,
	0.8277207612991333,
	0.8265824913978577,
	0.8254416584968567,
	0.8242982029914856,
	0.8231521844863892,
	0.8220036029815674,
	0.8208524584770203,
	0.8196988105773926,
	0.8185425996780396,
	0.8173838853836060,
	0.8162226676940918,
	0.8150590062141418,
	0.8138929009437561,
	0.8127242922782898,
	0.8115532994270325,
	0.8103798627853394,
	0.8092039823532104,
	0.8080257773399353,
	0.8068451285362244,
	0.8056621551513672,
	0.8044768571853638,
	0.8032892346382141,
	0.8020992279052734,
	0.8009069561958313,
	0.7997124195098877,
	0.7985155582427979,
	0.7973164916038513,
	0.7961151599884033,
	0.7949116230010986,
	0.7937058210372925,
	0.7924978733062744,
	0.7912877202033997,
	0.7900753617286682,
	0.7888608574867249,
	0.7876442670822144,
	0.7864255309104919,
	0.7852046489715576,
	0.7839816808700562,
	0.7827566266059875,
	0.7815295457839966,
	0.7803003787994385,
	0.7790691852569580,
	0.7778359651565552,
	0.7766007781028748,
	0.7753635644912720,
	0.7741243839263916,
	0.7728832364082336,
	0.7716401219367981,
	0.7703951001167297,
	0.7691481113433838,
	0.7678992748260498,
	0.7666485309600830,
	0.7653959393501282,
	0.7641414999961853,
	0.7628851532936096,
	0.7616270184516907,
	0.7603670954704285,
	0.7591053247451782,
	0.7578418254852295,
	0.7565765380859375,
	0.7553094625473022,
	0.7540407180786133,
	0.7527701854705811,
	0.7514979839324951,
	0.7502240538597107,
	0.7489485144615173,
	0.7476712465286255,
	0.7463923692703247,
	0.7451118230819702,
	0.7438296675682068,
	0.7425459623336792,
	0.7412605881690979,
	0.7399737238883972,
	0.7386852502822876,
	0.7373952269554138,
	0.7361037135124207,
	0.7348106503486633,
	0.7335160970687866,
	0.7322201132774353,
	0.7309226393699646,
	0.7296236753463745,
	0.7283232808113098,
	0.7270215153694153,
	0.7257182598114014,
	0.7244136929512024,
	0.7231076955795288,
	0.7218003869056702,
	0.7204917073249817,
	0.7191816568374634,
	0.7178703546524048,
	0.7165576815605164,
	0.7152437567710876,
	0.7139285802841187,
	0.7126120924949646,
	0.7112944126129150,
	0.7099754810333252,
	0.7086553573608398,
	0.7073340415954590,
	0.7060115337371826,
	0.7046878337860107,
	0.7033630013465881,
	0.7020370364189148,
	0.7007099390029907,
	0.6993817090988159,
	0.6980524063110352,
	0.6967220306396484,
	0.6953905820846558,
	0.6940581202507019,
	0.6927245855331421,
	0.6913900375366211,
	0.6900544762611389,
	0.6887179613113403,
	0.6873804330825806,
	0.6860419511795044,
	0.6847025156021118,
	0.6833621859550476,
	0.6820209026336670,
	0.6806787848472595,
	0.6793357133865356,
	0.6779918074607849,
	0.6766470074653625,
	0.6753013730049133,
	0.6739549636840820,
	0.6726077198982239,
	0.6712596416473389,
	0.6699107885360718,
	0.6685612201690674,
	0.6672108173370361,
	0.6658596992492676,
	0.6645079255104065,
	0.6631553769111633,
	0.6618021130561829,
	0.6604481935501099,
	0.6590936183929443,
	0.6577383875846863,
	0.6563825011253357,
	0.6550260186195374,
	0.6536689400672913,
	0.6523112058639526,
	0.6509529352188110,
	0.6495941281318665,
	0.6482347249984741,
	0.6468747854232788,
	0.6455143094062805,
	0.6441533565521240,
	0.6427919268608093,
	0.6414299607276917,
	0.6400675773620605,
	0.6387047171592712,
	0.6373414397239685,
	0.6359777450561523,
	0.6346136331558228,
	0.6332491040229797,
	0.6318842172622681,
	0.6305189132690430,
	0.6291533112525940,
	0.6277873516082764,
	0.6264210939407349,
	0.6250545382499695,
	0.6236876249313354,
	0.6223204731941223,
	0.6209530830383301,
	0.6195853948593140,
	0.6182174682617188,
	0.6168493032455444,
	0.6154809594154358,
	0.6141123771667480,
	0.6127436161041260,
	0.6113747358322144,
	0.6100056767463684,
	0.6086364388465881,
	0.6072670817375183,
	0.6058976650238037,
	0.6045280694961548,
	0.6031584739685059,
	0.6017886996269226,
	0.6004189252853394,
	0.5990490913391113,
	0.5976792573928833,
	0.5963093638420105,
	0.5949394702911377,
	0.5935695767402649,
	0.5921997427940369,
	0.5908299088478088,
	0.5894601345062256,
	0.5880904197692871,
	0.5867207646369934,
	0.5853511691093445,
	0.5839817523956299,
	0.5826123952865601,
	0.5812431573867798,
	0.5798740983009338,
	0.5785051584243774,
	0.5771363973617554,
	0.5757678151130676,
	0.5743994116783142,
	0.5730312466621399,
	0.5716632604598999,
	0.5702955722808838,
	0.5689280629158020,
	0.5675608515739441,
	0.5661938786506653,
	0.5648272037506104,
	0.5634608268737793,
	0.5620947480201721,
	0.5607289671897888,
	0.5593635439872742,
	0.5579984784126282,
	0.5566337704658508,
	0.5552694797515869,
	0.5539054870605469,
	0.5525419712066650,
	0.5511788129806519,
	0.5498160719871521,
	0.5484538078308105,
	0.5470919609069824,
	0.5457305908203125,
	0.5443696975708008,
	0.5430092811584473,
	0.5416493415832520,
	0.5402899384498596,
	0.5389310717582703,
	0.5375726819038391,
	0.5362148880958557,
	0.5348576307296753,
	0.5335009694099426,
	0.5321449041366577,
	0.5307893753051758,
	0.5294345021247864,
	0.5280802249908447,
	0.5267265439033508,
	0.5253735780715942,
	0.5240212082862854,
	0.5226694941520691,
	0.5213184952735901,
	0.5199682116508484,
	0.5186185836791992,
	0.5172696709632874,
	0.5159215331077576,
	0.5145740509033203,
	0.5132274031639099,
	0.5118814706802368,
	0.5105363130569458,
	0.5091919302940369,
	0.5078483223915100,
	0.5065055489540100,
	0.5051636099815369,
	0.5038224458694458,
	0.5024821758270264,
	0.5011427402496338,
	0.4998041689395905,
	0.4984664618968964,
	0.4971296191215515,
	0.4957937002182007,
	0.4944586753845215,
	0.4931245744228363,
	0.4917913973331451,
	0.4904591739177704,
	0.4891278743743896,
	0.4877975583076477,
	0.4864681959152222,
	0.4851398468017578,
	0.4838124513626099,
	0.4824860692024231,
	0.4811607301235199,
	0.4798364043235779,
	0.4785130918025970,
	0.4771908521652222,
	0.4758696556091309,
	0.4745495319366455,
	0.4732304811477661,
	0.4719125330448151,
	0.4705956578254700,
	0.4692799150943756,
	0.4679652750492096,
	0.4666517674922943,
	0.4653394222259521,
	0.4640281796455383,
	0.4627181291580200,
	0.4614092409610748,
	0.4601015448570251,
	0.4587950408458710,
	0.4574897289276123,
	0.4561856091022491,
	0.4548827111721039,
	0.4535810649394989,
	0.4522806406021118,
	0.4509814679622650,
	0.4496835768222809,
	0.4483869075775146,
	0.4470915496349335,
	0.4457974731922150,
	0.4445047080516815,
	0.4432132244110107,
	0.4419230520725250,
	0.4406342208385468,
	0.4393467307090759,
	0.4380605518817902,
	0.4367757439613342,
	0.4354923069477081,
	0.4342102408409119,
	0.4329295456409454,
	0.4316502511501312,
	0.4303723275661469,
	0.4290958344936371,
	0.4278207719326019,
	0.4265471100807190,
	0.4252748787403107,
	0.4240041077136993,
	0.4227347671985626,
	0.4214669167995453,
	0.4202004969120026,
	0.4189355969429016,
	0.4176721572875977,
	0.4164102077484131,
	0.4151497781276703,
	0.4138908386230469,
	0.4126334488391876,
	0.4113775789737701,
	0.4101232290267944,
	0.4088704288005829,
	0.4076191782951355,
	0.4063695073127747,
	0.4051213860511780,
	0.4038748741149902,
	0.4026299118995667,
	0.4013865590095520,
	0.4001448154449463,
	0.3989046812057495,
	0.3976661562919617,
	0.3964292705059052,
	0.3951939940452576,
	0.3939603567123413,
	0.3927283883094788,
	0.3914980888366699,
	0.3902694284915924,
	0.3890424370765686,
	0.3878171443939209,
	0.3865935206413269,
	0.3853715956211090,
	0.3841513693332672,
	0.3829328715801239,
	0.3817160725593567,
	0.3805009722709656,
	0.3792876303195953,
	0.3780760467052460,
	0.3768661618232727,
	0.3756580650806427,
	0.3744517266750336,
	0.3732471466064453,
	0.3720443248748779,
	0.3708432912826538,
	0.3696440458297729,
	0.3684465885162354,
	0.3672509491443634,
	0.3660570979118347,
	0.3648650646209717,
	0.3636748492717743,
	0.3624864518642426,
	0.3612999022006989,
	0.3601152002811432,
	0.3589323461055756,
	0.3577513098716736,
	0.3565721809864044,
	0.3553948700428009,
	0.3542194664478302,
	0.3530459105968475,
	0.3518742620944977,
	0.3507044911384583,
	0.3495366275310516,
	0.3483706414699554,
	0.3472065925598145,
	0.3460444509983063,
	0.3448842167854309,
	0.3437259197235107,
	0.3425695598125458,
	0.3414151072502136,
	0.3402626216411591,
	0.3391120731830597,
	0.3379634916782379,
	0.3368168771266937,
	0.3356721997261047,
	0.3345295190811157,
	0.3333888053894043,
	0.3322500586509705,
	0.3311133086681366,
	0.3299785554409027,
	0.3288457989692688,
	0.3277150690555573,
	0.3265863060951233,
	0.3254595696926117,
	0.3243348598480225,
	0.3232121765613556,
	0.3220915198326111,
	0.3209728896617889,
	0.3198562860488892,
	0.3187417387962341,
	0.3176292479038239,
	0.3165187835693359,
	0.3154104053974152,
	0.3143040835857391,
	0.3131998181343079,
	0.3120976090431213,
	0.3109974861145020,
	0.3098994493484497,
	0.3088034987449646,
	0.3077096641063690,
	0.3066178858280182,
	0.3055282235145569,
	0.3044406473636627,
	0.3033551871776581,
	0.3022718131542206,
	0.3011905848979950,
	0.3001114726066589,
	0.2990344762802124,
	0.2979595959186554,
	0.2968868613243103,
	0.2958162724971771,
	0.2947477996349335,
	0.2936814725399017,
	0.2926172912120819,
	0.2915552854537964,
	0.2904953956604004,
	0.2894376814365387,
	0.2883821129798889,
	0.2873287498950958,
	0.2862775027751923,
	0.2852284610271454,
	0.2841815948486328,
	0.2831369042396545,
	0.2820943892002106,
	0.2810540497303009,
	0.2800159156322479,
	0.2789799571037292,
	0.2779462039470673,
	0.2769146263599396,
	0.2758852839469910,
	0.2748581171035767,
	0.2738331854343414,
	0.2728104591369629,
	0.2717899382114410,
	0.2707716226577759,
	0.2697555422782898,
	0.2687416672706604,
	0.2677300274372101,
	0.2667206227779388,
	0.2657134234905243,
	0.2647084593772888,
	0.2637057602405548,
	0.2627052664756775,
	0.2617070376873016,
	0.2607110440731049,
	0.2597172856330872,
	0.2587257921695709,
	0.2577365338802338,
	0.2567495107650757,
	0.2557647824287415,
	0.2547822892665863,
	0.2538020610809326,
	0.2528240680694580,
	0.2518483698368073,
	0.2508749067783356,
	0.2499037384986877,
	0.2489348351955414,
	0.2479681968688965,
	0.2470038235187531,
	0.2460417449474335,
	0.2450819313526154,
	0.2441243976354599,
	0.2431691288948059,
	0.2422161698341370,
	0.2412654757499695,
	0.2403170615434647,
	0.2393709421157837,
	0.2384271174669266,
	0.2374855726957321,
	0.2365463227033615,
	0.2356093674898148,
	0.2346747070550919,
	0.2337423413991928,
	0.2328122705221176,
	0.2318844944238663,
	0.2309590280056000,
	0.2300358414649963,
	0.2291149795055389,
	0.2281964123249054,
	0.2272801399230957,
	0.2263661772012711,
	0.2254545241594315,
	0.2245451658964157,
	0.2236381322145462,
	0.2227333933115005,
	0.2218309789896011,
	0.2209308594465256,
	0.2200330495834351,
	0.2191375643014908,
	0.2182443886995316,
	0.2173535227775574,
	0.2164649665355682,
	0.2155787199735641,
	0.2146947979927063,
	0.2138131856918335,
	0.2129338979721069,
	0.2120569199323654,
	0.2111822664737701,
	0.2103099226951599,
	0.2094398885965347,
	0.2085721790790558,
	0.2077067941427231,
	0.2068437188863754,
	0.2059829682111740,
	0.2051245272159576,
	0.2042684108018875,
	0.2034146040678024,
	0.2025631219148636,
	0.2017139643430710,
	0.2008671164512634,
	0.2000225931406021,
	0.1991803944110870,
	0.1983405053615570,
	0.1975029259920120,
	0.1966676712036133,
	0.1958347409963608,
	0.1950041204690933,
	0.1941758245229721,
	0.1933498382568359,
	0.1925261765718460,
	0.1917048245668411,
	0.1908857822418213,
	0.1900690644979477,
	0.1892546564340591,
	0.1884425729513168,
	0.1876327991485596,
	0.1868253201246262,
	0.1860201805830002,
	0.1852173358201981,
	0.1844168007373810,
	0.1836185902357101,
	0.1828226745128632,
	0.1820290684700012,
	0.1812377721071243,
	0.1804487854242325,
	0.1796621084213257,
	0.1788777261972427,
	0.1780956685543060,
	0.1773158907890320,
	0.1765384227037430,
	0.1757632642984390,
	0.1749904006719589,
	0.1742198318243027,
	0.1734515577554703,
	0.1726855933666229,
	0.1719219237565994,
	0.1711605340242386,
	0.1704014539718628,
	0.1696446537971497,
	0.1688901484012604,
	0.1681379228830338,
	0.1673879921436310,
	0.1666403561830521,
	0.1658950001001358,
	0.1651519238948822,
	0.1644111275672913,
	0.1636726111173630,
	0.1629363745450974,
	0.1622024178504944,
	0.1614707410335541,
	0.1607413291931152,
	0.1600141972303391,
	0.1592893302440643,
	0.1585667282342911,
	0.1578464061021805,
	0.1571283340454102,
	0.1564125418663025,
	0.1556989997625351,
	0.1549877226352692,
	0.1542786955833435,
	0.1535719335079193,
	0.1528674215078354,
	0.1521651595830917,
	0.1514651626348495,
	0.1507674008607864,
	0.1500718742609024,
	0.1493786126375198,
	0.1486875861883163,
	0.1479987949132919,
	0.1473122388124466,
	0.1466279178857803,
	0.1459458470344543,
	0.1452659964561462,
	0.1445883661508560,
	0.1439129710197449,
	0.1432397961616516,
	0.1425688415765762,
	0.1419001072645187,
	0.1412335932254791,
	0.1405692994594574,
	0.1399072110652924,
	0.1392473280429840,
	0.1385896652936935,
	0.1379341930150986,
	0.1372809410095215,
	0.1366298645734787,
	0.1359810084104538,
	0.1353343278169632,
	0.1346898525953293,
	0.1340475529432297,
	0.1334074586629868,
	0.1327695399522781,
	0.1321337968111038,
	0.1315002292394638,
	0.1308688521385193,
	0.1302396357059479,
	0.1296125948429108,
	0.1289877295494080,
	0.1283650100231171,
	0.1277444660663605,
	0.1271260827779770,
	0.1265098452568054,
	0.1258957684040070,
	0.1252838373184204,
	0.1246740520000458,
	0.1240664124488831,
	0.1234609186649323,
	0.1228575557470322,
	0.1222563311457634,
	0.1216572374105453,
	0.1210602745413780,
	0.1204654350876808,
	0.1198727190494537,
	0.1192821264266968,
	0.1186936423182487,
	0.1181072816252708,
	0.1175230219960213,
	0.1169408708810806,
	0.1163608282804489,
	0.1157828792929649,
	0.1152070313692093,
	0.1146332770586014,
	0.1140616089105606,
	0.1134920269250870,
	0.1129245311021805,
	0.1123591214418411,
	0.1117957830429077,
	0.1112345159053802,
	0.1106753200292587,
	0.1101181954145432,
	0.1095631271600723,
	0.1090101227164268,
	0.1084591746330261,
	0.1079102754592896,
	0.1073634326457977,
	0.1068186312913895,
	0.1062758713960648,
	0.1057351455092430,
	0.1051964610815048,
	0.1046598032116890,
	0.1041251793503761,
	0.1035925745964050,
	0.1030619889497757,
	0.1025334224104881,
	0.1020068675279617,
	0.1014823243021965,
	0.1009597852826118,
	0.1004392504692078,
	0.0999207124114037,
	0.0994041636586189,
	0.0988896116614342,
	0.0983770415186882,
	0.0978664606809616,
	0.0973578542470932,
	0.0968512222170830,
	0.0963465645909309,
	0.0958438739180565,
	0.0953431501984596,
	0.0948443785309792,
	0.0943475663661957,
	0.0938527062535286,
	0.0933597981929779,
	0.0928688272833824,
	0.0923798009753227,
	0.0918927118182182,
	0.0914075523614883,
	0.0909243226051331,
	0.0904430225491524,
	0.0899636372923851,
	0.0894861668348312,
	0.0890106111764908,
	0.0885369628667831,
	0.0880652144551277,
	0.0875953733921051,
	0.0871274247765541,
	0.0866613686084747,
	0.0861971974372864,
	0.0857349112629890,
	0.0852745100855827,
	0.0848159790039062,
	0.0843593180179596,
	0.0839045271277428,
	0.0834515988826752,
	0.0830005332827568,
	0.0825513154268265,
	0.0821039527654648,
	0.0816584378480911,
	0.0812147632241249,
	0.0807729214429855,
	0.0803329199552536,
	0.0798947438597679,
	0.0794583931565285,
	0.0790238603949547,
	0.0785911455750465,
	0.0781602486968040,
	0.0777311548590660,
	0.0773038640618324,
	0.0768783763051033,
	0.0764546841382980,
	0.0760327801108360,
	0.0756126642227173,
	0.0751943290233612,
	0.0747777745127678,
	0.0743629857897758,
	0.0739499703049660,
	0.0735387206077576,
	0.0731292292475700,
	0.0727214962244034,
	0.0723155140876770,
	0.0719112828373909,
	0.0715087875723839,
	0.0711080357432365,
	0.0707090198993683,
	0.0703117251396179,
	0.0699161589145660,
	0.0695223137736320,
	0.0691301897168159,
	0.0687397718429565,
	0.0683510676026344,
	0.0679640620946884,
	0.0675787478685379,
	0.0671951398253441,
	0.0668132156133652,
	0.0664329752326012,
	0.0660544186830521,
	0.0656775385141373,
	0.0653023272752762,
	0.0649287775158882,
	0.0645569041371346,
	0.0641866773366928,
	0.0638181120157242,
	0.0634511858224869,
	0.0630859136581421,
	0.0627222806215286,
	0.0623602792620659,
	0.0619999095797539,
	0.0616411678493023,
	0.0612840466201305,
	0.0609285458922386,
	0.0605746544897556,
	0.0602223761379719,
	0.0598716959357262,
	0.0595226176083088,
	0.0591751337051392,
	0.0588292405009270,
	0.0584849342703819,
	0.0581422075629234,
	0.0578010566532612,
	0.0574614778161049,
	0.0571234636008739,
	0.0567870177328587,
	0.0564521253108978,
	0.0561187900602818,
	0.0557870008051395,
	0.0554567575454712,
	0.0551280528306961,
	0.0548008866608143,
	0.0544752478599548,
	0.0541511364281178,
	0.0538285486400127,
	0.0535074733197689,
	0.0531879141926765,
	0.0528698600828648,
	0.0525533109903336,
	0.0522382594645023,
	0.0519247017800808,
	0.0516126342117786,
	0.0513020530343056,
	0.0509929507970810,
	0.0506853237748146,
	0.0503791682422161,
	0.0500744767487049,
	0.0497712492942810,
	0.0494694784283638,
	0.0491691604256630,
	0.0488702915608883,
	0.0485728643834591,
	0.0482768788933754,
	0.0479823239147663,
	0.0476892031729221,
	0.0473975054919720,
	0.0471072271466255,
	0.0468183644115925,
	0.0465309135615826,
	0.0462448708713055,
	0.0459602288901806,
	0.0456769838929176,
	0.0453951358795166,
	0.0451146736741066,
	0.0448355935513973,
	0.0445578955113888,
	0.0442815721035004,
	0.0440066158771515,
	0.0437330268323421,
	0.0434608012437820,
	0.0431899279356003,
	0.0429204106330872,
	0.0426522381603718,
	0.0423854067921638,
	0.0421199165284634,
	0.0418557599186897,
	0.0415929295122623,
	0.0413314253091812,
	0.0410712435841560,
	0.0408123731613159,
	0.0405548177659512,
	0.0402985662221909,
	0.0400436148047447,
	0.0397899635136127,
	0.0395376048982143,
	0.0392865315079689,
	0.0390367470681667,
	0.0387882366776466,
	0.0385410040616989,
	0.0382950417697430,
	0.0380503423511982,
	0.0378069058060646,
	0.0375647284090519,
	0.0373237989842892,
	0.0370841212570667,
	0.0368456840515137,
	0.0366084836423397,
	0.0363725200295448,
	0.0361377857625484,
	0.0359042771160603,
	0.0356719903647900,
	0.0354409180581570,
	0.0352110601961613,
	0.0349824056029320,
	0.0347549580037594,
	0.0345287062227726,
	0.0343036502599716,
	0.0340797826647758,
	0.0338570997118950,
	0.0336356014013290,
	0.0334152765572071,
	0.0331961214542389,
	0.0329781398177147,
	0.0327613167464733,
	0.0325456522405148,
	0.0323311462998390,
	0.0321177877485752,
	0.0319055728614330,
	0.0316945016384125,
	0.0314845666289330,
	0.0312757641077042,
	0.0310680922120810,
	0.0308615416288376,
	0.0306561104953289,
	0.0304517950862646,
	0.0302485898137093,
	0.0300464909523726,
	0.0298454947769642,
	0.0296455975621939,
	0.0294467918574810,
	0.0292490776628256,
	0.0290524456650019,
	0.0288568958640099,
	0.0286624226719141,
	0.0284690205007792,
	0.0282766874879599,
	0.0280854180455208,
	0.0278952065855265,
	0.0277060512453318,
	0.0275179464370012,
	0.0273308865725994,
	0.0271448716521263,
	0.0269598942250013,
	0.0267759487032890,
	0.0265930350869894,
	0.0264111459255219,
	0.0262302793562412,
	0.0260504279285669,
	0.0258715897798538,
	0.0256937611848116,
	0.0255169384181499,
	0.0253411140292883,
	0.0251662880182266,
	0.0249924510717392,
	0.0248196050524712,
	0.0246477425098419,
	0.0244768578559160,
	0.0243069510906935,
	0.0241380147635937,
	0.0239700451493263,
	0.0238030403852463,
	0.0236369948834181,
	0.0234719049185514,
	0.0233077649027109,
	0.0231445729732513,
	0.0229823235422373,
	0.0228210128843784,
	0.0226606391370296,
	0.0225011948496103,
	0.0223426781594753,
	0.0221850834786892,
	0.0220284089446068,
	0.0218726489692926,
	0.0217177998274565,
	0.0215638577938080,
	0.0214108191430569,
	0.0212586782872677,
	0.0211074352264404,
	0.0209570806473494,
	0.0208076145499945,
	0.0206590332090855,
	0.0205113291740417,
	0.0203645024448633,
	0.0202185474336147,
	0.0200734585523605,
	0.0199292358011007,
	0.0197858717292547,
	0.0196433644741774,
	0.0195017084479332,
	0.0193609017878771,
	0.0192209407687187,
	0.0190818198025227,
	0.0189435351639986,
	0.0188060849905014,
	0.0186694636940956,
	0.0185336675494909,
	0.0183986946940422,
	0.0182645395398140,
	0.0181311983615160,
	0.0179986674338579,
	0.0178669430315495,
	0.0177360232919455,
	0.0176059026271105,
	0.0174765773117542,
	0.0173480454832315,
	0.0172202996909618,
	0.0170933399349451,
	0.0169671606272459,
	0.0168417599052191,
	0.0167171321809292,
	0.0165932737290859,
	0.0164701826870441,
	0.0163478534668684,
	0.0162262842059135,
	0.0161054711788893,
	0.0159854087978601,
	0.0158660952001810,
	0.0157475266605616,
	0.0156296994537115,
	0.0155126098543406,
	0.0153962541371584,
	0.0152806295081973,
	0.0151657322421670,
	0.0150515576824546,
	0.0149381030350924,
	0.0148253655061126,
	0.0147133413702250,
	0.0146020269021392,
	0.0144914174452424,
	0.0143815120682120,
	0.0142723051831126,
	0.0141637939959764,
	0.0140559747815132,
	0.0139488456770778,
	0.0138424010947347,
	0.0137366391718388,
	0.0136315561830997,
	0.0135271484032273,
	0.0134234121069312,
	0.0133203445002437,
	0.0132179427891970,
	0.0131162032485008,
	0.0130151221528649,
	0.0129146957769990,
	0.0128149222582579,
	0.0127157969400287,
	0.0126173170283437,
	0.0125194797292352,
	0.0124222813174129,
	0.0123257180675864,
	0.0122297881171107,
	0.0121344858780503,
	0.0120398113504052,
	0.0119457580149174,
	0.0118523249402642,
	0.0117595084011555,
	0.0116673046723008,
	0.0115757109597325,
	0.0114847244694829,
	0.0113943414762616,
	0.0113045582547784,
	0.0112153729423881,
	0.0111267827451229,
	0.0110387820750475,
	0.0109513709321618,
	0.0108645437285304,
	0.0107782995328307,
	0.0106926327571273,
	0.0106075434014201,
	0.0105230258777738,
	0.0104390773922205,
	0.0103556960821152,
	0.0102728791534901,
	0.0101906219497323,
	0.0101089226081967,
	0.0100277783349156,
	0.0099471854045987,
	0.0098671410232782,
	0.0097876423969865,
	0.0097086867317557,
	0.0096302703022957,
	0.0095523921772838,
	0.0094750467687845,
	0.0093982331454754,
	0.0093219475820661,
	0.0092461872845888,
	0.0091709494590759,
	0.0090962313115597,
	0.0090220300480723,
	0.0089483428746462,
	0.0088751669973135,
	0.0088024986907840,
	0.0087303360924125,
	0.0086586764082313,
	0.0085875159129500,
	0.0085168536752462,
	0.0084466850385070,
	0.0083770072087646,
	0.0083078192546964,
	0.0082391174510121,
	0.0081708980724216,
	0.0081031601876020,
	0.0080359000712633,
	0.0079691149294376,
	0.0079028028994799,
	0.0078369602560997,
	0.0077715846709907,
	0.0077066738158464,
	0.0076422248966992,
	0.0075782355852425,
	0.0075147021561861,
	0.0074516232125461,
	0.0073889959603548,
	0.0073268171399832,
	0.0072650848887861,
	0.0072037959471345,
	0.0071429484523833,
	0.0070825391449034,
	0.0070225661620498,
	0.0069630262441933,
	0.0069039179943502,
	0.0068452376872301,
	0.0067869834601879,
	0.0067291525192559,
	0.0066717425361276,
	0.0066147511824965,
	0.0065581761300564,
	0.0065020145848393,
	0.0064462637528777,
	0.0063909222371876,
	0.0063359863124788,
	0.0062814550474286,
	0.0062273247167468,
	0.0061735934577882,
	0.0061202594079077,
	0.0060673193074763,
	0.0060147712938488,
	0.0059626125730574,
	0.0059108417481184,
	0.0058594555594027,
	0.0058084521442652,
	0.0057578287087381,
	0.0057075833901763,
	0.0056577138602734,
	0.0056082177907228,
	0.0055590933188796,
	0.0055103371851146,
	0.0054619479924440,
	0.0054139229469001,
	0.0053662601858377,
	0.0053189578466117,
	0.0052720126695931,
	0.0052254232577980,
	0.0051791872829199,
	0.0051333024166524,
	0.0050877663306892,
	0.0050425771623850,
	0.0049977330490947,
	0.0049532311968505,
	0.0049090697430074,
	0.0048652463592589,
	0.0048217591829598,
	0.0047786063514650,
	0.0047357850708067,
	0.0046932939440012,
	0.0046511306427419,
	0.0046092928387225,
	0.0045677791349590,
	0.0045265862718225,
	0.0044857137836516,
	0.0044451584108174,
	0.0044049182906747,
	0.0043649920262396,
	0.0043253772892058,
	0.0042860722169280,
	0.0042470744810998,
	0.0042083822190762,
	0.0041699935682118,
	0.0041319062002003,
	0.0040941191837192,
	0.0040566292591393,
	0.0040194354951382,
	0.0039825360290706,
	0.0039459280669689,
	0.0039096102118492,
	0.0038735806010664,
	0.0038378371391445,
	0.0038023784290999,
	0.0037672021426260,
	0.0037323066499084,
	0.0036976898554713,
	0.0036633501295000,
	0.0036292858421803,
	0.0035954946652055,
	0.0035619752015918,
	0.0035287255886942,
	0.0034957439638674,
	0.0034630284644663,
	0.0034305774606764,
	0.0033983890898526,
	0.0033664614893496,
	0.0033347932621837,
	0.0033033823128790,
	0.0032722270116210,
	0.0032413259614259,
	0.0032106768339872,
	0.0031802784651518,
	0.0031501287594438,
	0.0031202263198793,
	0.0030905695166439,
	0.0030611564870924,
	0.0030319853685796,
	0.0030030549969524,
	0.0029743635095656,
	0.0029459090437740,
	0.0029176902025938,
	0.0028897055890411,
	0.0028619531076401,
	0.0028344313614070,
	0.0028071389533579,
	0.0027800740208477,
	0.0027532351668924,
	0.0027266207616776,
	0.0027002291753888,
	0.0026740590110421,
	0.0026481086388230,
	0.0026223764289171,
	0.0025968609843403,
	0.0025715606752783,
	0.0025464741047472,
	0.0025215996429324,
	0.0024969358928502,
	0.0024724814575166,
	0.0024482347071171,
	0.0024241942446679,
	0.0024003584403545,
	0.0023767261300236,
	0.0023532956838608,
	0.0023300657048821,
	0.0023070345632732,
	0.0022842013277113,
	0.0022615639027208,
	0.0022391215898097,
	0.0022168725263327,
	0.0021948153153062,
	0.0021729487925768,
	0.0021512715611607,
	0.0021297822240740,
	0.0021084791515023,
	0.0020873614121228,
	0.0020664273761213,
	0.0020456758793443,
	0.0020251052919775,
	0.0020047146826982,
	0.0019845024216920,
	0.0019644675776362,
	0.0019446084043011,
	0.0019249237375334,
	0.0019054125295952,
	0.0018860732670873,
	0.0018669047858566,
	0.0018479056889191,
	0.0018290748121217,
	0.0018104109913111,
	0.0017919128295034,
	0.0017735791625455,
	0.0017554088262841,
	0.0017374004237354,
	0.0017195529071614,
	0.0017018649959937,
	0.0016843355260789,
	0.0016669632168487,
	0.0016497470205650,
	0.0016326856566593,
	0.0016157779609784,
	0.0015990227693692,
	0.0015824190340936,
	0.0015659654745832,
	0.0015496610431001,
	0.0015335044590756,
	0.0015174946747720,
	0.0015016306424513,
	0.0014859111979604,
	0.0014703350607306,
	0.0014549014158547,
	0.0014396089827642,
	0.0014244567137212,
	0.0014094435609877,
	0.0013945683604106,
	0.0013798300642520,
	0.0013652277411893,
	0.0013507601106539,
	0.0013364263577387,
	0.0013222252018750,
	0.0013081558281556,
	0.0012942170724273,
	0.0012804080033675,
	0.0012667274568230,
	0.0012531745014712,
	0.0012397482059896,
	0.0012264474062249,
	0.0012132712872699,
	0.0012002188013867,
	0.0011872889008373,
	0.0011744806542993,
	0.0011617930140346,
	0.0011492251651362,
	0.0011367760598660,
	0.0011244448833168,
	0.0011122304713354,
	0.0011001320090145,
	0.0010881485650316,
	0.0010762790916488,
	0.0010645228903741,
	0.0010528789134696,
	0.0010413463460281,
	0.0010299240238965,
	0.0010186113649979,
	0.0010074073215947,
	0.0009963110787794,
	0.0009853217052296,
	0.0009744382696226,
	0.0009636600152589,
	0.0009529860108159,
	0.0009424154413864,
	0.0009319474338554,
	0.0009215811733156,
	0.0009113157866523,
	0.0009011504589580,
	0.0008910843171179,
	0.0008811166044325,
	0.0008712465059943,
	0.0008614731486887,
	0.0008517957176082,
	0.0008422134560533,
	0.0008327256073244,
	0.0008233312983066,
	0.0008140297723003,
	0.0008048202726059,
	0.0007957020425238,
	0.0007866742089391,
	0.0007777361315675,
	0.0007688869955018,
	0.0007601260440424,
	0.0007514525204897,
	0.0007428656681441,
	0.0007343648467213,
	0.0007259491831064,
	0.0007176180370152,
	0.0007093707099557,
	0.0007012063870206,
	0.0006931244279258,
	0.0006851241341792,
	0.0006772047490813,
	0.0006693655741401,
	0.0006616059690714,
	0.0006539252353832,
	0.0006463226745836,
	0.0006387975881808,
	0.0006313492776826,
	0.0006239771610126,
	0.0006166805396788,
	0.0006094587151892,
	0.0006023110472597,
	0.0005952368956059,
	0.0005882356781512,
	0.0005813066381961,
	0.0005744491936639,
	0.0005676627042703,
	0.0005609465879388,
	0.0005543001461774,
	0.0005477227969095,
	0.0005412139580585,
	0.0005347729311325,
	0.0005283991922624,
	0.0005220921593718,
	0.0005158511339687,
	0.0005096756503917,
	0.0005035650101490,
	0.0004975186311640,
	0.0004915360477753,
	0.0004856165905949,
	0.0004797597066499,
	0.0004739648429677,
	0.0004682314174715,
	0.0004625589062925,
	0.0004569466982502,
	0.0004513943276834,
	0.0004459011543076,
	0.0004404667124618,
	0.0004350904200692,
	0.0004297717532609,
	0.0004245102172717,
	0.0004193052300252,
	0.0004141562967561,
	0.0004090628935955,
	0.0004040245548822,
	0.0003990406985395,
	0.0003941108298022,
	0.0003892345121130,
	0.0003844111633953,
	0.0003796403470915,
	0.0003749215684365,
	0.0003702543035615,
	0.0003656380868051,
	0.0003610724525061,
	0.0003565569058992,
	0.0003520910104271,
	0.0003476742422208,
	0.0003433061938267,
	0.0003389863704797,
	0.0003347143065184,
	0.0003304895944893,
	0.0003263117105234,
	0.0003221802762710,
	0.0003180948260706,
	0.0003140549233649,
	0.0003100601024926,
	0.0003061099560000,
	0.0003022040764336,
	0.0002983419981319,
	0.0002945233136415,
	0.0002907475864049,
	0.0002870144380722,
	0.0002833234320860,
	0.0002796741900966,
	0.0002760662464425,
	0.0002724992518779,
	0.0002689727698453,
	0.0002654864219949,
	0.0002620398008730,
	0.0002586325572338,
	0.0002552642836235,
	0.0002519345725887,
	0.0002486430457793,
	0.0002453893830534,
	0.0002421731333015,
	0.0002389939763816,
	0.0002358515339438,
	0.0002327454276383,
	0.0002296752936672,
	0.0002266407973366,
	0.0002236415748484,
	0.0002206772478530,
	0.0002177474962082,
	0.0002148519706680,
	0.0002119903074345,
	0.0002091621718137,
	0.0002063672436634,
	0.0002036051591858,
	0.0002008755982388,
	0.0001981782406801,
	0.0001955127518158,
	0.0001928787969518,
	0.0001902760704979,
	0.0001877042377600,
	0.0001851629931480,
	0.0001826520165196,
	0.0001801710022846,
	0.0001777196448529,
	0.0001752976386342,
	0.0001729046634864,
	0.0001705404429231,
	0.0001682046713540,
	0.0001658970286371,
	0.0001636172673898,
	0.0001613650529180,
	0.0001591401378391,
	0.0001569422020111,
	0.0001547709834995,
	0.0001526262058178,
	0.0001505075779278,
	0.0001484148233430,
	0.0001463476801291,
	0.0001443058717996,
	0.0001422891218681,
	0.0001402971829521,
	0.0001383297785651,
	0.0001363866613247,
	0.0001344675547443,
	0.0001325722114416,
	0.0001307003694819,
	0.0001288517960347,
	0.0001270262291655,
	0.0001252234214917,
	0.0001234431256307,
	0.0001216850942001,
	0.0001199491016450,
	0.0001182349005830,
	0.0001165422581835,
	0.0001148709343397,
	0.0001132207034971,
	0.0001115913328249,
	0.0001099825967685,
	0.0001083942697733,
	0.0001068261190085,
	0.0001052779334714,
	0.0001037494876073,
	0.0001022405631375,
	0.0001007509490591,
	0.0000992804343696,
	0.0000978288007900,
	0.0000963958373177,
	0.0000949813475017,
	0.0000935851130635,
	0.0000922069375520,
	0.0000908466172405,
	0.0000895039556781,
	0.0000881787418621,
	0.0000868707938935,
	0.0000855799153214,
	0.0000843059096951,
	0.0000830485805636,
	0.0000818077533040,
	0.0000805832314654,
	0.0000793748258729,
	0.0000781823691796,
	0.0000770056576584,
	0.0000758445312385,
	0.0000746988007450,
	0.0000735682915547,
	0.0000724528290448,
	0.0000713522385922,
	0.0000702663455741,
	0.0000691949899192,
	0.0000681380042806,
	0.0000670952067594,
	0.0000660664445604,
	0.0000650515576126,
	0.0000640503712930,
	0.0000630627328064,
	0.0000620884820819,
	0.0000611274663243,
	0.0000601795254624,
	0.0000592445103393,
	0.0000583222608839,
	0.0000574126352149,
	0.0000565154768992,
	0.0000556306404178,
	0.0000547579802515,
	0.0000538973472430,
	0.0000530486067873,
	0.0000522116097272,
	0.0000513862178195,
	0.0000505722891830,
	0.0000497696892126,
	0.0000489782833029,
	0.0000481979295728,
	0.0000474285006931,
	0.0000466698656965,
	0.0000459218863398,
	0.0000451844389318,
	0.0000444573925051,
	0.0000437406197307,
	0.0000430340005551,
	0.0000423374040111,
	0.0000416507064074,
	0.0000409737949667,
	0.0000403065387218,
	0.0000396488248953,
	0.0000390005370718,
	0.0000383615515602,
	0.0000377317555831,
	0.0000371110363631,
	0.0000364992811228,
	0.0000358963770850,
	0.0000353022151103,
	0.0000347166824213,
	0.0000341396698786,
	0.0000335710756190,
	0.0000330107905029,
	0.0000324587090290,
	0.0000319147256960,
	0.0000313787422783,
	0.0000308506532747,
	0.0000303303586406,
	0.0000298177601508,
	0.0000293127595796,
	0.0000288152587018,
	0.0000283251629298,
	0.0000278423740383,
	0.0000273668010777,
	0.0000268983476417,
	0.0000264369245997,
	0.0000259824373643,
	0.0000255347986240,
	0.0000250939192483,
	0.0000246597101068,
	0.0000242320838879,
	0.0000238109550992,
	0.0000233962364291,
	0.0000229878460232,
	0.0000225857002079,
	0.0000221897134907,
	0.0000217998094740,
	0.0000214159026655,
	0.0000210379166674,
	0.0000206657696253,
	0.0000202993869607,
	0.0000199386886379,
	0.0000195836018975,
	0.0000192340467038,
	0.0000188899521163,
	0.0000185512453754,
	0.0000182178500836,
	0.0000178896953003,
	0.0000175667119038,
	0.0000172488289536,
	0.0000169359755091,
	0.0000166280842677,
	0.0000163250861078,
	0.0000160269155458,
	0.0000157335034601,
	0.0000154447880050,
	0.0000151607009684,
	0.0000148811805047,
	0.0000146061629493,
	0.0000143355846376,
	0.0000140693846333,
	0.0000138075020004,
	0.0000135498758027,
	0.0000132964469231,
	0.0000130471553348,
	0.0000128019437398,
	0.0000125607548398,
	0.0000123235304272,
	0.0000120902159324,
	0.0000118607549666,
	0.0000116350929602,
	0.0000114131744340,
	0.0000111949484563,
	0.0000109803595478,
	0.0000107693567770,
	0.0000105618883026,
	0.0000103579022834,
	0.0000101573505162,
	0.0000099601811598,
	0.0000097663451015,
	0.0000095757950476,
	0.0000093884827947,
	0.0000092043601398,
	0.0000090233806986,
	0.0000088454989964,
	0.0000086706686488,
	0.0000084988441813,
	0.0000083299819380,
	0.0000081640382632,
	0.0000080009685917,
	0.0000078407301771,
	0.0000076832820923,
	0.0000075285815910,
	0.0000073765872912,
	0.0000072272587204,
	0.0000070805558607,
	0.0000069364386945,
	0.0000067948681135,
	0.0000066558054641,
	0.0000065192130023,
	0.0000063850520746,
	0.0000062532858465,
	0.0000061238779381,
	0.0000059967919697,
	0.0000058719920162,
	0.0000057494426073,
	0.0000056291091823,
	0.0000055109571804,
	0.0000053949524954,
	0.0000052810614761,
	0.0000051692513807,
	0.0000050594899221,
	0.0000049517439038,
	0.0000048459824029,
	0.0000047421740419,
	0.0000046402869884,
	0.0000045402916840,
	0.0000044421572056,
	0.0000043458544496,
	0.0000042513538574,
	0.0000041586263251,
	0.0000040676436583,
	0.0000039783776629,
	0.0000038908001443,
	0.0000038048840452,
	0.0000037206025354,
	0.0000036379285575,
	0.0000035568359635,
	0.0000034772988329,
	0.0000033992916997,
	0.0000033227893255,
	0.0000032477666991,
	0.0000031741994917,
	0.0000031020633742,
	0.0000030313346997,
	0.0000029619895940,
	0.0000028940053198,
	0.0000028273586850,
	0.0000027620271794,
	0.0000026979889753,
	0.0000026352215627,
	0.0000025737040232,
	0.0000025134145289,
	0.0000024543323889,
	0.0000023964369120,
	0.0000023397078621,
	0.0000022841247755,
	0.0000022296680982,
	0.0000021763182758,
	0.0000021240562091,
	0.0000020728630261,
	0.0000020227198547,
	0.0000019736082777,
	0.0000019255105599,
	0.0000018784083977,
	0.0000018322843971,
	0.0000017871213913,
	0.0000017429021000,
	0.0000016996099248,
	0.0000016572281538,
	0.0000016157405298,
	0.0000015751310229,
	0.0000015353839444,
	0.0000014964834918,
	0.0000014584145447,
	0.0000014211619828,
	0.0000013847107994,
	0.0000013490465562,
	0.0000013141547015,
	0.0000012800211380,
	0.0000012466318822,
	0.0000012139732917,
	0.0000011820318377,
	0.0000011507941053,
	0.0000011202471342,
	0.0000010903778502,
	0.0000010611738617,
	0.0000010326225492,
	0.0000010047116348,
	0.0000009774290675,
	0.0000009507630239,
	0.0000009247017942,
	0.0000008992339531,
	0.0000008743481885,
	0.0000008500333593,
	0.0000008262786082,
	0.0000008030731919,
	0.0000007804065945,
	0.0000007582684134,
	0.0000007366484738,
	0.0000007155367712,
	0.0000006949234717,
	0.0000006747989687,
	0.0000006551536558,
	0.0000006359782674,
	0.0000006172636517,
	0.0000005990008276,
	0.0000005811809842,
	0.0000005637953677,
	0.0000005468355084,
	0.0000005302930504,
	0.0000005141598081,
	0.0000004984277666,
	0.0000004830889679,
	0.0000004681356813,
	0.0000004535603182,
	0.0000004393554889,
	0.0000004255138322,
	0.0000004120281858,
	0.0000003988915864,
	0.0000003860970992,
	0.0000003736380449,
	0.0000003615078015,
	0.0000003496999170,
	0.0000003382080536,
	0.0000003270260436,
	0.0000003161478048,
	0.0000003055673972,
	0.0000002952790794,
	0.0000002852771672,
	0.0000002755560899,
	0.0000002661104190,
	0.0000002569349249,
	0.0000002480244063,
	0.0000002393738328,
	0.0000002309782730,
	0.0000002228329237,
	0.0000002149331095,
	0.0000002072742546,
	0.0000001998519252,
	0.0000001926617870,
	0.0000001856996334,
	0.0000001789613435,
	0.0000001724429382,
	0.0000001661405520,
	0.0000001600504049,
	0.0000001541688590,
	0.0000001484923615,
	0.0000001430174734,
	0.0000001377408836,
	0.0000001326593519,
	0.0000001277697947,
	0.0000001230691851,
	0.0000001185546239,
	0.0000001142233188,
	0.0000001100725768,
	0.0000001060998116,
	0.0000001023025362,
	0.0000000986783633,
	0.0000000952250119,
	0.0000000919403007,
	0.0000000888221479,
	0.0000000858685780,
	0.0000000830777012,
	0.0000000804477409,
	0.0000000779770133,
	0.0000000756639338,
	0.0000000735070103,
	0.0000000715048571,
	0.0000000696561813,
	0.0000000679597889,
	0.0000000664145787,
	0.0000000650195489,
	0.0000000637737969,
	0.0000000626765058,
	0.0000000617269649,
	0.0000000609245632,
	0.0000000602687606,
	0.0000000597591452,
	0.0000000593953757,
	0.0000000591772142,
	0.0000000591045186
};


#endif // !_WINDOWING_H_


