#include "mbed.h"
#include "AT42QT1010.h"

DigitalOut read_led(LED1);
DigitalOut auto_led(LED2);
DigitalOut i_led1(LED3);
DigitalOut i_led2(LED4);
AT42QT1010 touch_sensor(p23,p21);

//Global variables to control interrupt timing
int _old_sig=0;
int _new_sig=0;

void rise_interrupt(){
    static int count=0;
    //Only execute on true rise
    if(_old_sig==0 && _new_sig==1){
        _old_sig=1;
        //Use LED3 and LED4 to display count
        count++;
        i_led2=(count)%2;
        i_led1=(count>>1)%2;
    }  
}
void fall_interrupt(){
    //Trigger indication of true fall
    if(_new_sig==0) _old_sig=0;
}

int main() {
    //Set up the rising and falling edge interrupts
    touch_sensor.attach_rise(&rise_interrupt);
    touch_sensor.attach_fall(&fall_interrupt);
    while(1) {
        //Declare the current status of the sensor,
        //and give a window of time to process.
        _new_sig = touch_sensor;
        wait(.1);
        //Member function demonstration
        read_led = touch_sensor.read();
        auto_led = touch_sensor;
        touch_sensor.write(!auto_led);
    }
}
