#ifndef AT42QT1010_H
#define AT42QT1010_H

#include "mbed.h"

///Class for the AT42QT1010 Capactitive Touch Sensor
class AT42QT1010 {
    
    public:
    /**Define the device without use of the on-board LED*/
        explicit AT42QT1010(PinName);
    /**Define the device using both breakout I/O pins.  Requires manual modification to the breakout before use.*/
        explicit AT42QT1010(PinName, PinName);
        ~AT42QT1010();
    /**Writes to the LED, if defined.
    @param state 0 or 1 to power the LED
    */
        void write(int state);
    /**Take in the current value being output by the device.*/
        int read();
    /**Shorthand for read().*/
        operator int(){return _data;}
    /**Initiate interrupts for the rising edge of data.
    @param fpr Function pointer to interrupt routine.
    */
        void attach_rise(void (*fpr)(void));
        /**Initiate interrupts for the falling edge of data.
    @param fpr Function pointer to interrupt routine.
    */
        void attach_fall(void (*fpr)(void));
    private:
        InterruptIn _data;
        DigitalOut *_led_state;
};

AT42QT1010::AT42QT1010(PinName data) : _data(data) {
    _led_state=NULL;
}

AT42QT1010::AT42QT1010(PinName data, PinName led_pin) : _data(data){
    _led_state = (DigitalOut *) new DigitalOut(led_pin);
}

AT42QT1010::~AT42QT1010(){
    if(_led_state!=NULL){
        delete _led_state;
    }
}

void AT42QT1010::write(int state){
    if(_led_state!=NULL){
        if(state!=0) (*_led_state)=1;
        else (*_led_state)=0;
    }
}

int AT42QT1010::read(){
    return _data;
}

void AT42QT1010::attach_rise(void (*fpr)(void)){
    _data.rise(fpr);
}
void AT42QT1010::attach_fall(void (*fpr)(void)){
    _data.fall(fpr);
}

#endif