#include "mbed.h"

#include "LSM9DS0.h"

class VelocityTracker {

public:
    VelocityTracker(PinName sda, PinName scl, float updateRate, float biasRate);
    
    void updateBias();
    
    void updateVelocity();
    
    float getVelocity();
    
private:
    LSM9DS0 *imu;
    Ticker biasTicker, updateTicker;
    float _bias[3];
    float _vx, _vy, _vz;
    float _velocity;
    float _biasRate, _updateRate;
    int sampleCount;
};
