#include "mbed.h"
#include "vector.h"
#include "LSM303DLHC.h"
#include "USBKeyboard.h"
 
Serial pc(USBTX, USBRX); // tx, rx
USBKeyboard keyboard;
 // top face
LSM303DLHC lsm(PTE0,PTE1);
AnalogIn pU1(A0); // up
AnalogIn pD1(A1); //down
AnalogIn pR1(A2); //right
AnalogIn pL1(A3); //left

// bottom face
AnalogIn pU(PTE20);     //up
AnalogIn pD(PTE21);     //down
AnalogIn pR(PTE22);   //right
AnalogIn pL(PTE23);   //left

//switches
DigitalIn s1(D6);
DigitalIn s2(D7);

// Integers
int counter = 0;

// Levels for photocells
float covered = 0.5; // maximum value to be considered covered
float opened = 0.8; // minimum value to be considered open (ambient)

// boolean variables for different wait states
bool waitingUP = false;
bool waitingDOWN = false;
bool waitingRIGHT = false;
bool waitingLEFT = false;

class Orientation {
    vector a, m;
    bool rightSideUp, movingDown, movingUp, movedDown, movedUp;
    float top_threshold, bottom_threshold;
    public: Orientation() {
        top_threshold = -0.3;
        bottom_threshold = 0.3;
        rightSideUp = true;
        movingDown = false;
        movingUp = false;
        movedDown = false;
        movedUp = true;
    }
    bool isRightSideUp() {
        
        bool check = lsm.read(&a.x,&a.y,&a.z,&m.x,&m.y,&m.z);
        //pc.printf("x %f y %f z %f",a.z,a.y,a.z);
        pc.printf("{ \"x\": %f, \"y\": %f, \"z\": %f}\r\n",a.x,a.y,a.z);
        if (check) {
            if (a.x > top_threshold) {
                movingDown = true;
                movingUp = false;
            } else if (a.x < bottom_threshold) {
                movingUp = true;
                movingDown = false;
            }
            if (movingDown && a.x > bottom_threshold) {
                movingDown = false;
                movedUp = false;
                movedDown = true;
            } else if (movingUp && a.x < top_threshold) {
                movingUp = false;
                movedDown = false;
                movedUp = true;
            }
            if (!rightSideUp && movedUp) {
                rightSideUp = true;
            } else if (rightSideUp && movedDown) {
                rightSideUp = false;
            }
        }
        return rightSideUp;
    }
};

bool isCovered(AnalogIn p) {
    return p < covered;
}

bool isOpen(AnalogIn p) {
    return p > opened;
}

bool photoCellUp(AnalogIn pUp,AnalogIn pDown,AnalogIn pRight,AnalogIn pLeft) {
   // pc.printf("covered only up\r\n");
    return isCovered(pUp) && isOpen(pDown) && isOpen(pRight) && isOpen(pLeft);
}

bool photoCellDown(AnalogIn pUp,AnalogIn pDown,AnalogIn pRight,AnalogIn pLeft) {
    //pc.printf("covered only down\r\n");
    return isOpen(pUp) && isCovered(pDown) && isOpen(pRight) && isOpen(pLeft);
}

bool photoCellLeft(AnalogIn pUp,AnalogIn pDown,AnalogIn pRight,AnalogIn pLeft) {
    //pc.printf("covered only right\r\n");
    return isOpen(pUp) && isOpen(pDown) && isOpen(pRight) && isCovered(pLeft);
}

bool photoCellRight(AnalogIn pUp,AnalogIn pDown,AnalogIn pRight,AnalogIn pLeft) {
    //pc.printf("covered only left\r\n");
    return isOpen(pUp) && isOpen(pDown) && isCovered(pRight) && isOpen(pLeft);
}


int main() {
    pc.printf("hello\r\n");
    Orientation up;
    bool lastRightSideUp = true;

    while (1) {
            bool rightSideUp = up.isRightSideUp();
            if (rightSideUp != lastRightSideUp) {
               pc.printf("flipped\r\n");
               //keyboard.printf("f\r");
            }
            if (rightSideUp) {
                pc.printf("RIGHT SIDE UP\r\n");
            } else {
                pc.printf("UP SIDE DOWN\r\n");
            }
            lastRightSideUp = rightSideUp;
                // LISTENING FOR UP & DOWN SWIPES
    if ((rightSideUp && photoCellUp(pU1,pD1,pR1,pL1)) || (!rightSideUp && photoCellUp(pU,pD,pR,pL)))
    {   
        if (waitingUP)
        {
            pc.printf("Swiped UP \r\n");
            //keyboard.printf("w\r");
            counter = 0;
            waitingUP = false;
            wait(0.2);
        }
            else
            {
                waitingDOWN = true;
               // pc.printf("Waiting to Swipe Down \r\n");
               // keyboard.printf("Waiting to Swipe Down\r");
            }
        }

        else if ((rightSideUp && photoCellDown(pU1,pD1,pR1,pL1)) || (!rightSideUp && photoCellDown(pU,pD,pR,pL)))
        {
            if (waitingDOWN)
            {
                pc.printf("Swiped DOWN \r\n");
                //keyboard.printf("s\r");
                counter = 0;
                waitingDOWN = false;
                wait(0.2);
            }
                else
                {
                    waitingUP = true;
                    //pc.printf("Waiting to Swipe Up \r\n");
                    //keyboard.printf("Waiting to Swipe Up\r");
                }
        }
        else if ((rightSideUp && photoCellRight(pU1,pD1,pR1,pL1)) || (!rightSideUp && photoCellRight(pU,pD,pR,pL))) {
            if (waitingRIGHT)
            {
            pc.printf("Swiped RIGHT \r\n");
            //keyboard.printf("e\r");
            counter = 0;
            waitingRIGHT = false;
            wait(0.2);
            }
            else
            {
                waitingLEFT = true;
                //pc.printf("Waiting to Swipe LEFT \r\n");
                //keyboard.printf("Waiting to Swipe Left\r");
            }
        } else if ((rightSideUp && photoCellLeft(pU1,pD1,pR1,pL1)) || (!rightSideUp && photoCellLeft(pU,pD,pR,pL))) {
            if (waitingLEFT)
            {
                pc.printf("Swiped LEFT \r\n");
                //keyboard.printf("w\r");
                counter = 0;
                waitingLEFT = false;
                wait(0.2);
            }
            else
            {
                waitingRIGHT = true;
                //pc.printf("Waiting to Swipe RIGHT \r\n");
                //keyboard.printf("Waiting to Swipe Right\r");
            }
        } else if ((rightSideUp && s1 == 0) || (!rightSideUp && s2 == 0)) {
            pc.printf("Pressed button!\r\n");
            // keyboard.printf("m\r");
        }

    if (counter > 40)
    {
        waitingUP = false;
        waitingDOWN = false;
        waitingRIGHT = false;
        waitingDOWN = false;
        counter = 0;
        //printf("Counter Reset \r\n");
    }
        wait(0.1); 
    }
    
    
}