
// Template of player header file
#ifndef PLAYER_H
#define PLAYER_H

typedef enum {
    ALIVE=1,      // The game screen will be shown 
    DEAD=0   // The game screen will not be shown
} PLAYER_STATUS;

typedef struct {
    int score;      // Score of the player
    double lives;      // Number of remaining lives
    PLAYER_STATUS status;  // See enum PLAYER_STATUS
} PLAYER;

#define MAX_NUM_PLAYER 1    // There can only be a single player

// The function returns the number of lives the player has remaining
double get_player_lives();

// The function returns the score of the player
int get_player_score();

// Initializes the player object
void player_init();

// Initializes/Draws the GUI on the LCD
void gui_init();

/** The function gets the distance from the checkpoint/registration zone to the nearest note in the lane specified by index
    @param index The index in the structure containing the note objects of the note to be checked
*/
float get_distance(int index);

// Function to make sure all the Note objects in the structure containing the notes is up to date
void update_values();

// The function returns a boolean stating whether the player has lost the game or not. Function also checks to see if a note has passed the registration zone
bool detect_note_miss();

/** The function detects whether a note is close enough to the checkpoint to be a hit or not. Returns a boolean to determine if the player has lost all their lives as well.
    @param index The lane in which the notes are to be looked for.
*/
bool detect_note_hit(int index);

// The function determines whether or not the player has lost all their lives or not. Returns a boolean which describes whether the player has lost or not.
bool detect_lose_conditions();

#endif //PLAYER_H