#include "mbed.h"
#include "uLCD_4DGL.h"
#include "player.h"
#include "note_public.h"
#include <math.h>

extern int note_speed;  // Note speed
extern int note_interval; // Interval on which notes are created
extern uLCD_4DGL uLCD;  // LCD display
extern Serial pc;       // For debugging 

PLAYER CURRENT_PLAYER;  // Player object
NOTE note_array[MAX_NUM_NOTE];  // Structure containing the Note objects

void player_init() {            // Initializes the player object with default values
    CURRENT_PLAYER.score = 0;
    CURRENT_PLAYER.lives = 20;
    CURRENT_PLAYER.status = ALIVE;
}

void gui_init() {               // Draws the GUI on the LCD
        uLCD.locate(0,0);
        uLCD.line(43,0,43,128,GREEN);           //Lines separating the lanes
        uLCD.line(86,0,86,128,GREEN);           //Lines separating the lanes
        uLCD.circle(108,128-15,10,WHITE);       //Left note
        uLCD.filled_circle(108,128-15,4,WHITE); //Left note
        uLCD.circle(65,128-15,10,WHITE);        //Middle note
        uLCD.filled_circle(65,128-15,4,WHITE);  //Middle note
        uLCD.circle(22,128-15,10,WHITE);        //Right note
        uLCD.filled_circle(22,128-15,4,WHITE);  //Right note
        for(int i = 5;i<10;i++)                 //Loop used to fill in the notes with appropriate color
        {
            uLCD.circle(108,128-15,i,GREEN);
            uLCD.circle(65,128-15,i,RED);
            uLCD.circle(22,128-15,i,0xFFFF00);
        }
}

double get_player_lives() {                     // Gets number of lives player has remaining
    
    return(CURRENT_PLAYER.lives); 
}

int get_player_score() {                        // Gets score of player
    pc.printf("Player's Score: %i\n\r",CURRENT_PLAYER.score);
    return(CURRENT_PLAYER.score);
    }

void update_values(){                           // Updates the structure containing the Note object data
    for(int index=0;index<MAX_NUM_NOTE;index++)
        {
        note_array[index]=note_get_info(index);
        //pc.printf("The y value of note %i is %d\n\r",index,note_array[index].y); FOR DEBUGGING PURPOSES
        }
}

bool detect_lose_conditions(){                  // Detects when the game is over by checking the player's lives
    bool game_over = false;
    if(CURRENT_PLAYER.lives <= 0){
        game_over=true;
    }
    return(game_over);
}

float get_distance(int index){                      // Detects distance between notes in the lane and the note registration zone
    float distance = 0;
    int y2 = note_array[index].y;
    distance = abs(y2-(128.0-15.0));                // 113.0 is the location of the center of the registration zone in the y direction
    //pc.printf("The Y value for note %i is %i \n\r",index,y2);                           FOR DEBUGGING PURPOSES
    //pc.printf("The distance between the note and the checkpoint is: %f\n\r",distance);  FOR DEBUGGING PURPOSES
    return (distance);
    }
    
bool detect_note_miss(){                            // Detects when notes go past the checkpoint, also will check to see if player has lost all their lives
        bool gameOver = false;                      // Assume the player has not lost the game yet
        update_values();                            // Make sure the location data for all notes is current
        for(int index=0;index<5;index++){
                if((note_array[index].y >=(128-10)) && (note_array[index].y != 128))    // If the note has passed the registration/checkpoint zone
                    { 
                        note_set_missed(index);                                                 // Set note as missed
                        note_update_position();                                                 // Update its status 
                        gui_init();                                                             // Redraw the GUI 
                        CURRENT_PLAYER.lives -= 2;                                              // Lose 2 lives for a missed note
                        gameOver = detect_lose_conditions();                                    // Determine if this has lost the player the game
                        //pc.printf("Note went past registration zone!\n\r");                   // FOR DEBUGGING PURPOSES
                        //break;                                                                  
                    }
        }
        return(gameOver);
}
                
bool detect_note_hit(int lane){                     // Detects when a note is hit, is called whenever a direction is input on the joystick
        bool gameOver = false;                      // Assume player has not lost the game yet
        update_values();                            // Make sure the location data for all notes is current
        int minDistance = 128;                      // We only want to look at the closest note in the lane we care about
        int indexToCheck;                           // We only need to look at one note per function call
        for(int i=0;i<5;i++)
        {
            //pc.printf("Checking note %i, current lane: %i \n\r",i,note_array[i].lane); FOR DEBUGGING PURPOSES
            if(note_array[i].lane+1 == (lane+1))
            {
                if(get_distance(i) < minDistance)
                {
                    minDistance = get_distance(i);  // Make sure we get the note with the least distance to the checkpoint
                    indexToCheck=i;                 // This is the note we want to check if we hit
                }
            }
        }
        //pc.printf("Found a match!"); FOR DEBUGGING PURPOSES
        double distance = get_distance(indexToCheck);  // Check distance of selected note from checkpoint zone
        if(distance <= 4.0){                // If note is close enough, proceed
        note_set_played(indexToCheck);                 // Set note status to NOTE_PLAYED
        note_update_position();             // Update note position
        gui_init();                         // Redraw the GUI
        CURRENT_PLAYER.lives += 1.2;        // Player gets 1.2 lives back for each note hit
        CURRENT_PLAYER.score += 1.0;        // Player gets 1 point for every note hit
        //pc.printf("Note hit!\n\r");       FOR DEBUGGING PURPOSES
        }
        else if(distance > 4)               // If note is not close enough, proceed with miss protocol
        {             
            CURRENT_PLAYER.lives -=1.0;         // If a note is missed in this manner, player loses 1 life
            gameOver = detect_lose_conditions();// Check to see if this has caused the player to lose all their lives and the game
            //pc.printf("Note missed...\n\r");  DEBUGGING PURPOSES
        }
        return(gameOver);
}

                    