#ifndef NOTE_PUBLIC_H
#define NOTE_PUBLIC_H

//The note status
typedef enum {
    NOTE_MISSED=3, //note has been missed
    NOTE_PLAYED=2,//note has been played
    NOTE_ACTIVE=1,//note is active
    NOTE_DEACTIVE=0//note is no longer active
} NOTE_STATUS;

// The structure to store the information of a note
typedef struct {
    int x;                   // The x-coordinate of note's current position
    int y;                   // The y-coordinate of note's current position
    double source_x;           // The x-coordinate of the note's origin
    int tick;                  // The note's internal tick
    int color;                  // The note's color
    int lane;                   // Which lane is the note in
    NOTE_STATUS status;   // The note status, see NOTE_STATUS
} NOTE;

#define MAX_NUM_NOTE 5

/** This function draws the notes onto the screen
    Call note_generator() repeatedly in game-loop
*/
void note_generator(void);

/** The function set the status of note to be NOTE_PLAYED
    @param index The index in note_record. It must be smaller than MAX_NUM_NOTE.
*/
void note_set_played(int index);

/** The function sets the status of note to be NOTE_MISSED
    @param index The index in note_record. It must be smaller than MAX_NUM_NOTE.
*/

void note_set_missed(int index);

/** Get the information of a note
    @param index The index in note_record. It must be smaller than MAX_NUM_NOTE.
    @return The structure of note information
*/

NOTE note_get_info(int index);

/** Set the speed of notes, Speed has range of 1-8 with 1 being fastest and 8 being slowest
*/
void set_note_speed(int speed);

/** Set the interval that the notes occur, interval has range of 1-100 with 1 being created in
    very quick succession and 100 being created very slowly after one another
*/
void set_note_interval(int interval);

/** The function set the color of note to be color
    @param color The color in note_record.
*/

void set_note_color(int index, int color);

//The function updates the position of the notes on the board
void note_update_position(void);

#endif //NOTE_PUBLIC_H