#include "note_private.h"
extern Serial pc;

NOTE note_record[MAX_NUM_NOTE];
int note_tick=0;            // Internal note tick, used to make the note move at the appropriate speed
int note_interval = 25;     // The interval on which notes are created. Higher number is more frequent
int note_speed = 4;         // The speed at which the notes travel

// See the comments in note_public.h
void note_generator(void){
    note_tick++;
    // only create the notes at certain ticks
    if((note_tick % note_interval)==0 || note_tick==0){
        note_create();
    }
    
    // update the notes and draw them
    note_update_position();
}

// set note speed (default speed is 4)
void set_note_speed(int speed){
    if(speed>=1 && speed<=8){  
        note_speed = speed;
    }
}

// set note interval (default interval is 25)
void set_note_interval(int interval){
    if(interval>=1 && interval<=100){
        note_interval = interval;
    }
}

// See the comments in note_public.h
NOTE note_get_info(int index){
    return note_record[index];
}

// See the comments in note_public.h
void note_set_played(int index){
    note_record[index].status = NOTE_PLAYED;
    //pc.printf("Note %i has been changed to played",index); FOR DEBUGGING PURPOSES
}

// See the comments in note_public.h
void note_set_missed(int index){
    note_record[index].status = NOTE_MISSED;
    //pc.printf("Note %i has been changed to missed",index); FOR DEBUGGING PURPOSES
}

// See the comments in hote_public.h
void set_note_color(int index, int color){
    note_record[index].color = color;
}

/** This function finds an empty slot of note_record, and actives it.
*/
void note_create(void){
    int i,laneIndex;
    int startingPoints[3] = {22,65,108};    // The three possibilities for the X coordinate of the center of the note
    int colors[3] = {0xFFFF00,RED,GREEN};   // The three possibilities for the color of the note
    for(i=0;i<MAX_NUM_NOTE;i++){
        if(note_record[i].status == NOTE_DEACTIVE){ // Only create new notes in a space where there is a deactive note
            laneIndex = (rand() % 3);               // Randomly choose which lane to put the note in
            note_record[i].y = 0;                   // Initialize the note's Y value
            //each note has its own tick
            note_record[i].tick = 0;
            //set a random source for the note
            note_record[i].source_x = startingPoints[laneIndex];
            note_record[i].lane = laneIndex;
            //pc.printf("Note %i is in lane %i \n\r",i,laneIndex); FOR DEBUGGING PURPOSES
            //set appropriate color for note
            note_record[i].color = colors[laneIndex];
            //the note starts at its source
            note_record[i].x = note_record[i].source_x;
            //the note must be set to active
            note_record[i].status = NOTE_ACTIVE;
            break;
        }
    }
}

/** This function update the position of all notes and draws them
*/
void note_update_position(void){
    int i;
    double delta_y;
    //controls how fast the note will move
    int rate = note_speed * 25;
    for(i=0;i<MAX_NUM_NOTE;i++){
        if(note_record[i].status == NOTE_ACTIVE){
            // update note position
            delta_y = 200/rate;
            note_draw(note_record[i], BLACK);                               // Draw over old location of note
            note_record[i].y = (int)((delta_y*(note_record[i].tick%rate))); // Update the Y value of the note
            //pc.printf("Note %i has a y value of %i \n\r",i,note_record[i].y); FOR DEBUGGING PURPOSES
            note_draw(note_record[i], note_record[i].color);                 // Draw note in its new location
            //update note's internal tick
            note_record[i].tick++;
        }       
        else if((note_record[i].status == NOTE_PLAYED) || (note_record[i].status == NOTE_MISSED)){  // If the status of the note is not active
            // clear the note off the screen
            note_draw(note_record[i], BLACK);
            // we are done with this note, mark as deactive
            note_record[i].status = NOTE_DEACTIVE;
            //resets the note's internal tick
            note_record[i].tick = 0;
            //resets the note's y position 
            note_record[i].y = 128;
        }
        
    }
}

/** This function draws a note.
    @param note The note to be drawn
    @param color The color of the note
*/
void note_draw(NOTE note, int color){
    int current_x,current_y;
    current_x = note.x;
    current_y = note.y;
    if(color != BLACK)              // If we arent erasing a note
    {
    uLCD.filled_circle(current_x, current_y,4, WHITE);
    uLCD.circle(current_x, current_y,10,WHITE);
    for(int i = 5;i<10;i++)
        {
            uLCD.circle(current_x,current_y,i,color);
        }
    }
    else
    {
        uLCD.filled_circle(current_x,current_y,10,BLACK);
        
        }
}



