#include "mbed.h"
#include "rtos.h"
#include "SDFileSystem.h"
#include "uLCD_4DGL.h"
#include "wave_player.h"
#include "SongPlayer.h"
#include "note_public.h"
#include "player.h"
#include "Nav_Switch.h"
#include <stdlib.h>
#include <time.h>
#include <string>
#include <list>

AnalogOut DACout(p18); // used to play sound on speaker

//wave player plays a *.wav file to D/A and a PWM
wave_player waver(&DACout);
SongPlayer mySpeaker(p21);

uLCD_4DGL uLCD(p13,p14,p11); // serial tx, serial rx, reset pin;
Serial pc(USBTX, USBRX);    // for debugging
 
SDFileSystem sd(p5, p6, p7, p8, "sd"); //SD card setup

Mutex mtx;  // for rtos

Nav_Switch myNav( p26, p29, p28, p30, p27); //pin order on Sparkfun breakout; this is for joystick
 

volatile int currentDirection;      // current direction of the joystick
 
void controls_thread(void const *argument)
{
 // CONTROLS CHECKING (JOYSTICK) GO HERE

 while(1) {
        if((myNav & 0x0F) == 14){
        // Up on joystick
        currentDirection = 1;
        }    
        else if((myNav & 0x0F) == 13){
        // Down on joystick
        currentDirection = 2;
        }
        else if((myNav & 0x0F) == 11){
        // Left on joystick
        currentDirection = 3;
        }
        else if((myNav & 0x0F)== 7){
        // Right on joystick
        currentDirection = 4;
        }
        else
        currentDirection = 0;
 //pc.printf("Value of (myNav & 0x0F) is %i\n\r",(myNav & 0x0F)); FOR DEBUGGING PURPOSES
 //pc.printf("Value of currentDirection is %i\n\r",currentDirection); FOR DEBUGGING PURPOSES
 Thread::wait(100); // ADJUST THIS TO SET HOW FAST INPUTS FROM JOYSTICK ARE 'CLOCKED' IN
 }
 }
 
 
int main() {
        //FILE *greenNote;
        //FILE *yellowNote;
        //FILE *redNote;
        //greenNote=fopen("/sd/wavfiles/bassDrum.wav","r");
        //redNote=fopen("/sd/wavfiles/highHat.wav","r");
        //yellowNote=fopen("/sd/wavfiles/snareDrum.wav","r");
        
        //INITIALIZE IMPORTANT VARIABLES
        float greenNote[2]= {440.0,0.0}; // Tone played when green direction is pressed on joystick
        float redNote[2] = {261.626,0.0}; // Tone played when red direction is pressed on joystick
        float yellowNote[2] = {196,0.0}; // Tone played when yellow direction is pressed on joystick
        float duration[2]= {0.1, 0.0};  // Duration of tone (set to .1 seconds)
        bool gameOver = false;          // Ends game when this is true
        Thread thread1(controls_thread); // Thread handling controls (joystick)
        
        
        //INITIALIZE THE PLAYER
        player_init();
        //INITIALIZE THE GUI
        gui_init();
        
  while (gameOver==false) {     // Main game loop
      
    
      
      
      
      //START THE NOTE GENERATOR AND KEEP TRACK OF NOTES
        note_generator();
        detect_note_miss();
          if(currentDirection==4) //LEFT ON JOYSTICK
            {
                mtx.lock();
                uLCD.filled_circle(108,128-15,4,BLUE);  //Make center of note area light up blue momentarily to show you are trying to hit a note there
                mySpeaker.PlaySong(greenNote,duration);   //Play tone when you try to hit a note
                detect_note_hit(2);                     // Detect note hit in this lane
                //uLCD.filled_circle(108,128-15,4,WHITE);
                //pc.printf("detect_note_hit function called on button 1\n\r"); FOR DEBUGGING PURPOSES
                mtx.unlock();
            }
        else if(currentDirection==1) //UP ON JOYSTICK
            {
                mtx.lock();
                uLCD.filled_circle(65,128-15,4,BLUE);   //Make center of note area light up blue momentarily to show you are trying to hit a note there
                mySpeaker.PlaySong(redNote,duration);   //Play tone when you try to hit a note
                detect_note_hit(1);                     // Detect note hit in this lane
                //uLCD.filled_circle(65,128-15,4,WHITE);
                //pc.printf("detect_note_hit function called on button 2\n\r"); FOR DEBUGGING PURPOSES
                mtx.unlock();
            }
        else if(currentDirection==3) //RIGHT ON JOYSTICK
            {
                 mtx.lock();
                 uLCD.filled_circle(22,128-15,4,BLUE);      //Make center of note area light up blue momentarily to show you are trying to hit a note there
                 mySpeaker.PlaySong(yellowNote,duration);   //Play tone when you try to hit a note
                 detect_note_hit(0);                         // Detect note hit in this lane
                 //uLCD.filled_circle(22,128-15,4,WHITE);
                 //pc.printf("detect_note_hit function called on button 3\n\r"); FOR DEBUGGING PURPOSES
                 mtx.unlock();
            }
        else if(currentDirection==0) //FINGER COMING OFF KEY
            {
                uLCD.filled_circle(22,128-15,4,WHITE);
                uLCD.filled_circle(65,128-15,4,WHITE);
                uLCD.filled_circle(108,128-15,4,WHITE);
            }
        gameOver = detect_lose_conditions();
      }
      uLCD.printf("\n\n\n\n\n     Game Over\n\n");            //Displays the game over screen
      uLCD.printf("   Your Score: %i",get_player_score()); //Displays the score of the player once they have lost
}