#include "mbed.h"

#define NUM_OCTAVE  (7) // Number of octaves
#define NUM_NOTE (7)    // Number of notes in each octave

//Types of waveforms

enum WaveType{ sine, square, sawtooth};

#define PI 3.14159265

//Note Frequencies
#define C1 (33)
#define D1  (37)
#define E1  (41)
#define F1  (44)
#define G1  (49)
#define A1  (55)
#define B1  (62)
 
#define C2  (65)
#define D2  (73)
#define E2  (82)
#define F2  (87)
#define G2  (98)
#define A2  (110)
#define B2  (125)
 
#define C3  (131)
#define D3  (147)
#define E3  (165)
#define F3  (175)
#define G3  (196)
#define A3  (220)
#define B3  (247)
 
#define C4  (262)
#define D4  (294)
#define E4  (330)
#define F4  (349)
#define G4  (392)
#define A4  (440)
#define B4  (494)
 
#define C5  (523)
#define D5  (587)
#define E5  (659)
#define F5  (698)
#define G5  (784)
#define A5  (880)
#define B5  (988)
 
#define C6  (1047)
#define D6  (1175)
#define E6  (1319)
#define F6  (1397)
#define G6  (1568)
#define A6  (1760)
#define B6  (1976)
 
#define C7  (2093)
#define D7  (2349)
#define E7  (2637)
#define F7  (2794)
#define G7  (3136)
#define A7  (3520)
#define B7  (3951)

// Key Bindings

#define C_NOTE_KEY 'Z'
#define D_NOTE_KEY 'X'
#define E_NOTE_KEY 'C'
#define F_NOTE_KEY 'V'
#define G_NOTE_KEY 'B'
#define A_NOTE_KEY 'N'
#define B_NOTE_KEY 'M'
#define RAISE_OCTAVE_KEY 'O'
#define LOWER_OCTAVE_KEY 'L'
//#define RAISE_ATTACK_KEY 'Q'
//#define LOWER_ATTACK_KEY 'A'
//#define RAISE_DELAY_KEY 'W'
//#define LOWER_DELAY_KEY 'S'
#define RAISE_DURATION_KEY 'E'
#define LOWER_DURATION_KEY 'D'
#define RAISE_ADSR_KEY 'R'
#define LOWER_ADSR_KEY 'F'
#define CHANGE_WAVESHAPE_UP 'T'
#define CHANGE_WAVESHAPE_DOWN 'G'