/*
 * mbed STINGR library
 * Copyright (c) 2018
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

#ifndef MBED_STINGR_H
#define MBED_STINGR_H

#include "mbed.h"
#include "rtos.h"

class Stingr {

public:

    // Constructor
    Stingr();
    
    // Accessors
    const char* get_resp() const;
    
    // Mutators
    void setPacketByte(int incomingByte);
    
    // Serial Packet processing functions
    void clearPacket();
    void printPacket();
    void waitCTS();          
    void postCommand();
    void command(char* com); 
    void execute(char* com);
    
    // STINGR command functions
    void query_ESN();                   // command 'a'
    void query_Bursts();                // command 'b'
    void query_Firmware();              // command 'c'
    void query_Setup();                 // command 'd'
    void query_Hardware();              // command 'e'
    void NAK_command();                 // command 'f'
    void _setup(char* b);               // command 'g'
    void send_Data(char* b);            // command 'h'
    void abort_Transmission();          // command 'i'
    
    // Additional functions
    uint16_t ModRTU_CRC(char* buf, int len);
    
    //*TEST
    void respuesta();
    void PC_communication(); 
    
    int flag;
    int incomingByte;
    int num;
    
    int incomingByteR;
    char incomingByteX;
    char strx[200];
    
    Thread t1;
    Thread t2;
    
private:
    char _resp[200];
    int _packet[15]; 
};

#endif

