#include "mbed.h"                   //Se declara la librería mbed.
#include "rtos.h"

DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);
Serial pc(USBTX, USBRX, 9600);      // tx, rx Conunicación Serial con la PC
//DigitalIn CTS(p7, PullUp);          // Pin Digital de entrada "CTS" en modo Pull-Up, para encontrarse normalmente a VCC cuando no haya un pulso. 
//DigitalOut RTS(p8, 1);              // Pin Digital de Salida "RTS"; Predefinido para valer 1 en su estado inactivo dentro del código.

DigitalIn CTS(p11, PullUp);          // Pin Digital de entrada "CTS" en modo Pull-Up, para encontrarse normalmente a VCC cuando no haya un pulso. 
DigitalOut RTS(p12, 1);              // Pin Digital de Salida "RTS"; Predefinido para valer 1 en su estado inactivo dentro del código.

Serial device(p13, p14, 9600);       // tx, rx Comunicación Serial con el Módulo STX3
int flag=1;                         // Declaración de la Bandera.
int incomingByte=0;
Thread thread;

int packet[15]; //int or char
int num = 0;

void clearPacket()
{
    num = 0;
    for(int i = 0; i < 15 ; i++)
        packet[i] = 0;
}

void printPacket()
{
    pc.printf("\nprintPacket(): ");
    for(int i = 0; i < 15 ; i++)
    {
        pc.printf("%u",packet[i]);  // Format specifier
        pc.printf(" ");
    }
}

void respuesta()
{
    while(1)
    {
        if(device.readable()) 
        {   // Se esperan datos provenientes del TX del módulo STX3
            incomingByte = device.getc();
            packet[num] = incomingByte;
            pc.printf("%X",incomingByte);  // Format specifier
            pc.printf(" ");
            num++;
        }
    }
}

void waitCTS()
{
    Thread::wait(200);                                                    // Se da un tiempo para que el analizador se estabilice
    incomingByte=0;
    //pc.printf("El valor de CTS es %d\n\r",CTS.read());        // Se lee el valor de la variable CTS, la cual debe ser 1
    //pc.printf("El valor de RTS es %d\n\r",RTS.read());        // Se lee el valor de la variable RTS, la cual debe ser 1
    RTS=0;                                                      // Se manda un pulso en bajo en RTS, para inicial el proceso de transmisión
    
    while(flag==1)
    {// Flag inicialmente vale 1, así que el ciclo while cambiará hasta que esa condición no se cumpla           
        flag=CTS.read();        // Cuando entra el ciclo, se iguala flag a CTS, el cual cuando cambie a 0 provocará que termine el while (máx 125 ms)
        //pc.printf("El valor de flag es %d\n\r", flag);    // Se imprime el valor de flag, para identificar cuando termina el ciclo while
    }
}

void postCommand()
{
    Thread::wait(10);                // Se esperan .1 segundos una vez que se terminaron de hacer las transmisiones
    //El tiempo total de transmisión es; el wait previo a las transmisiones, el tiempo que tarda el Mu en enviar los datos y el wait posterior a la transmisión
    RTS=1;
    Thread::wait(150);
    //pc.printf("\n\rCTS: %d\n\r",CTS.read());
    flag=1;
}


bool queryESN();
bool abortTransmission();
bool queryFirmware();

int queryBursts();
long int querySetup();

void sendData();
void _setup();
void queryHardware();
void NAKcommand();
        
int main() 
{ 
    int bursts = 0;
    int long numSetup = 0;
    thread.start(respuesta);
       
    while(1) 
    {
        switch (pc.getc())
        {
            case '1':
                if (queryESN() == true)
                    pc.printf("\nQuery ESN is correct. VALID\n");
                else
                    pc.printf("\nNAK response. INVALID");        
                break;
                  
            case '2':
                bursts = queryBursts();
                if (bursts != 99)
                {
                    pc.printf("\nBursts Remaining: ");
                    pc.printf("%u",bursts); 
                    pc.printf("\n");
                }
                else 
                    pc.printf("\nNAK response. INVALID"); 
                break;
                
            case '3':
                if (queryFirmware() == true)
                    pc.printf("\nQuery ESN is correct. VALID\n"); 
                else
                    pc.printf("NAK. INVALID");
                break;
                
            case '4':
                numSetup = querySetup();
                if (numSetup == NULL)
                    pc.printf("NAK");
                            
                //Print Channel 
                pc.printf("\n RF Channel: ");
                pc.printf("%u",numSetup/(10000000));                // RF channel
                numSetup = numSetup - (numSetup/10000000)*10000000; // Truncate RF Digits
                //Print Bursts
                pc.printf("\n # of Bursts: ");
                pc.printf("%u",numSetup/(100000));                  // Bursts Per Message
                numSetup = numSetup - (numSetup/100000)*100000;     // Truncate Burst Digits
                //Print Min Interval
                pc.printf("\n Min Burst Interval: ");
                pc.printf("%u",numSetup/1000*5);                    // Min Interval
                numSetup = numSetup - (numSetup/1000)*1000;         // Truncate Min Interval
                pc.printf(" seconds");
                //Print Max Interval
                pc.printf("\n Max Burst Interval: ");
                pc.printf("%u",numSetup*5);                         // Max Interval
                pc.printf(" seconds\n");
                
                break;
                
            case '5':
                queryHardware();
                break;
            case '6':
                NAKcommand();             
                break;
            case '7':
                _setup();             
                break;
            case '8':
                sendData();               
                break;
            case '9':
                if (abortTransmission() == true)
                    pc.printf("\nTransmission successfully aborted.\n");
                else
                    pc.printf("\nNAK response. INVALID");        
                break;
        }
    }        
}
                           
//0x00 Send Data
void sendData()
{
    led4=!led4;
    pc.printf("\n\r0x00 Send Data\nCommand: AA 0E 00 01 02 03 04 05 06 07 08 09 BE E8\n\r");
    waitCTS();
    Thread::wait(10);                // SEND DATA
    device.putc(0XAA);      
    device.putc(0X0E);
    device.putc(0X00);
    device.putc(0X01);
    device.putc(0X02);
    device.putc(0X03);
    device.putc(0X04);
    device.putc(0X05);
    device.putc(0X06);
    device.putc(0X07);
    device.putc(0X08);
    device.putc(0X09);
    device.putc(0XBE);
    device.putc(0XE8);    
    postCommand();
}

//0x01 Query ESN
bool queryESN()
{
    led1=!led1;
    pc.printf("\n\n\r0x01 Query ESN\nCommand: AA 05 01 50 D5\n\r");
    pc.printf("Response: ");
    waitCTS();
    Thread::wait(10);
     
    device.putc(0XAA);      
    device.putc(0X05);
    device.putc(0X01);
    device.putc(0X50);
    device.putc(0XD5);  
    
    postCommand();
    printPacket();
    if (packet[3] ==   0 && // 0x00
        packet[4] ==  41 && // 0x29
        packet[5] ==  67 && // 0x43
        packet[6] == 179)   // 0xB3
    {
        clearPacket();
        return true;    
    }
    clearPacket();
    return false;
}

//0x03 Abort Transmission
bool abortTransmission()
{
    led1=!led1;
    pc.printf("\n\r0x03 Abort Transmission\nCommand: AA 05 03 42 F6\n\r");
    pc.printf("Response: ");
    waitCTS();
    Thread::wait(10);               
    device.putc(0XAA);      
    device.putc(0X05);
    device.putc(0X03);
    device.putc(0X42);
    device.putc(0XF6);
    
    postCommand();
    printPacket();
    if (packet[0] == 170 && // 0xAA
        packet[1] ==   5 && // 0x05
        packet[2] ==   3 && // 0x03
        packet[3] ==  66 && // 0x42
        packet[4] == 246)   // 0xF6
    {
        clearPacket();
        return true;    
    }
    clearPacket();
    return false;
}

//0x04 Query Bursts
int queryBursts()
{
    //int bursts = 99;
    led2=!led2;
    pc.printf("\n\r0x04 Query Burst Remaining\nCommand: AA 05 04 FD 82\n\r");
    pc.printf("Response: ");
    waitCTS();
    Thread::wait(10);
                    
    device.putc(0XAA);      
    device.putc(0X05);
    device.putc(0X04);
    device.putc(0XFD);
    device.putc(0X82);
    
    postCommand();
    printPacket();
    
    //If NAK response
    if (packet[0] == 170 && // 0xAA
        packet[1] ==   5 && // 0x05
        packet[2] == 255 && // 0xFF
        packet[3] == 161 && // 0xA1
        packet[4] == 203)   // 0xCB
    {
        clearPacket();
        return 99;    
    }
    clearPacket();
    return packet[3];
}

//0x05 Query Firmware
bool queryFirmware()
{
    led3=!led3;
    pc.printf("\n\r0x05 Query Firmware Version\nCommand: AA 05 05 74 93\n\r");
    pc.printf("Response: ");
    waitCTS();
    Thread::wait(10);               
    device.putc(0XAA);      
    device.putc(0X05);
    device.putc(0X05);
    device.putc(0X74);
    device.putc(0X93);        
    
    postCommand();
    printPacket();
    if (packet[3] == 1 && // 0x01
        packet[4] == 3)   // 0x03
    {
        clearPacket();
        return true;    
    }
    clearPacket();
    return false;
}

//0x06 Setup
void _setup()
{
    led3=!led3;
    pc.printf("\n\r0x06 Setup\nCommand: AA 0E 06 00 00 00 00 00 03 18 30 00 CE 9C\n\r");
    pc.printf("Response: ");
    waitCTS();
    Thread::wait(10);   
    
    /*           
    // 3 Bursts, 2 minutes, 4 minutes
    device.putc(0XAA);      
    device.putc(0X0E);
    device.putc(0X06);
    device.putc(0X00);
    device.putc(0X00);
    device.putc(0X00);
    device.putc(0X00);
    device.putc(0X00);
    device.putc(0X03);  // 3 Bursts
    device.putc(0X18);  // 2 minutes
    device.putc(0X30);  // 4 minutes
    device.putc(0X00);
    device.putc(0XCE);  // CRC1
    device.putc(0X9C);  // CRC2
    */
    
    /*
    // 3 Bursts, 10 seconds, 15 seconds
    device.putc(0XAA);      
    device.putc(0X0E);
    device.putc(0X06);
    device.putc(0X00);
    device.putc(0X00);
    device.putc(0X00);
    device.putc(0X00);
    device.putc(0X00);
    device.putc(0X03);  // 3 Bursts
    device.putc(0X02);  // 10 seconds
    device.putc(0X03);  // 15 seconds
    device.putc(0X00);
    device.putc(0XEB);  // CRC1
    device.putc(0XF6);  // CRC2
    */
    
    
    
    // 3 Bursts, 5 seconds, 10 seconds
    device.putc(0XAA);      
    device.putc(0X0E);
    device.putc(0X06);
    device.putc(0X00);
    device.putc(0X00);
    device.putc(0X00);
    device.putc(0X00);
    device.putc(0X00);
    device.putc(0X03);  // 3 Bursts
    device.putc(0X01);  // 5 seconds
    device.putc(0X02);  // 10 seconds
    device.putc(0X00);
    device.putc(0X57);  // CRC1
    device.putc(0X00);  // CRC2
    
    
    /*
    // 1 Burst, 10 seconds, 15 seconds
    device.putc(0XAA);      
    device.putc(0X0E);
    device.putc(0X06);
    device.putc(0X00);
    device.putc(0X00);
    device.putc(0X00);
    device.putc(0X00);
    device.putc(0X00);
    device.putc(0X01);  // 1 Burst
    device.putc(0X02);  // 10 seconds
    device.putc(0X03);  // 15 seconds
    device.putc(0X00);
    device.putc(0X9D);  // CRC1
    device.putc(0XCF);  // CRC2
    */
    
    
    // 1 Burst, 5 seconds, 10 seconds
    /*
    device.putc(0XAA);      
    device.putc(0X0E);
    device.putc(0X06);
    device.putc(0X00);
    device.putc(0X00);
    device.putc(0X00);
    device.putc(0X00);
    device.putc(0X00);
    device.putc(0X01);  // 1 Burst
    device.putc(0X01);  // 5 seconds
    device.putc(0X02);  // 10 seconds
    device.putc(0X00);
    device.putc(0X21);  // CRC1
    device.putc(0X39);  // CRC2
    */
    
    
    // 3 Bursts, 10 seconds, 20 seconds
    /*
    device.putc(0XAA);      
    device.putc(0X0E);
    device.putc(0X06);
    device.putc(0X00);
    device.putc(0X00);
    device.putc(0X00);
    device.putc(0X00);
    device.putc(0X00);
    device.putc(0X03);  // 3 Bursts
    device.putc(0X02);  // 10 seconds
    device.putc(0X04);  // 20 seconds
    device.putc(0X00);  
    device.putc(0XE3);  // CRC1
    device.putc(0XBB);  // CRC2
    */
    
    // 1 Burst, 30 seconds, 60 seconds
    /*
    device.putc(0XAA);      
    device.putc(0X0E);
    device.putc(0X06);
    device.putc(0X00);
    device.putc(0X00);
    device.putc(0X00);
    device.putc(0X00);
    device.putc(0X00);
    device.putc(0X01);  // 1 Burst
    device.putc(0X06);  // 30 seconds
    device.putc(0X0C);  // 60 seconds
    device.putc(0X00);  
    device.putc(0X34);  // CRC1
    device.putc(0X2F);  // CRC2
    */
    
    // 2 Bursts, 5 seconds, 10 seconds
    /*
    device.putc(0XAA);      
    device.putc(0X0E);
    device.putc(0X06);
    device.putc(0X00);
    device.putc(0X00);
    device.putc(0X00);
    device.putc(0X00);
    device.putc(0X00);
    device.putc(0X02);  // 2 Bursts
    device.putc(0X01);  // 5 seconds
    device.putc(0X02);  // 10 seconds
    device.putc(0X00);  
    device.putc(0XEC);  // CRC1
    device.putc(0X1C);  // CRC2
    */
    
    // 2 Bursts, 10 seconds, 15 seconds
    /*
    device.putc(0XAA);      
    device.putc(0X0E);
    device.putc(0X06);
    device.putc(0X00);
    device.putc(0X00);
    device.putc(0X00);
    device.putc(0X00);
    device.putc(0X00);
    device.putc(0X02);  // 2 Bursts
    device.putc(0X02);  // 5 seconds
    device.putc(0X03);  // 10 seconds
    device.putc(0X00);  
    device.putc(0X50);  // CRC1
    device.putc(0XEA);  // CRC2
    */
    
    // 3 Bursts, 5 seconds, 10 seconds
    /*
    device.putc(0XAA);      
    device.putc(0X0E);
    device.putc(0X06);
    device.putc(0X00);
    device.putc(0X00);
    device.putc(0X00);
    device.putc(0X00);
    device.putc(0X00);
    device.putc(0X02);  // 2 Bursts
    device.putc(0X18);  // 5 seconds
    device.putc(0X30);  // 15 seconds
    device.putc(0X00);  
    device.putc(0X75);  // CRC1
    device.putc(0X80);  // CRC2
    */
    
    // 3 Bursts, 5 seconds, 10 seconds 
    /*
    device.putc(0XAA);      
    device.putc(0X0E);
    device.putc(0X06);
    device.putc(0X00);
    device.putc(0X00);
    device.putc(0X00);
    device.putc(0X00);
    device.putc(0X00);
    device.putc(0X03);  // 3 Bursts
    device.putc(0X01);  // 5 seconds
    device.putc(0X02);  // 10 seconds
    device.putc(0X00);  
    device.putc(0X57);  // CRC1
    device.putc(0X00);  // CRC2
    */
    postCommand();
    
}

//0x07 Query Setup
long int querySetup()
{
    int numSetup = 0;
    led4=!led4;
    pc.printf("\n\r0x07 Query Setup\nCommand: AA 05 07 66 B0\n\r");
    pc.printf("Response: ");
    waitCTS();
    Thread::wait(10);
                    
    device.putc(0XAA);      
    device.putc(0X05);
    device.putc(0X07);
    device.putc(0X66);
    device.putc(0XB0);
    
    postCommand();
    
    //If NAK response
    if (packet[0] == 170 && // 0xAA
        packet[1] ==   5 && // 0x05
        packet[2] == 255 && // 0xFF
        packet[3] == 161 && // 0xA1
        packet[4] == 203)   // 0xCB
    {
        clearPacket();
        return NULL;    
    }
    numSetup = packet[7]*10000000 + packet[8]*100000 + packet[9]*1000 + packet[10];
    clearPacket();
    return numSetup;
}

//0x09 Query Hardware
void queryHardware()
{
    led1=!led1;
    pc.printf("\n\r0x09 Query Hardware Version\nCommand: AA 05 09 18 59\n\r");
    pc.printf("Response: ");
    waitCTS();
    Thread::wait(10);                
    
    device.putc(0XAA);      
    device.putc(0X05);
    device.putc(0X09);
    device.putc(0X18);
    device.putc(0X59);
    
    postCommand();
    printPacket();
    clearPacket();
    pc.printf("\n");
}

//NAK Command
void NAKcommand()
{
    led2=!led2;
    pc.printf("\n\rXxXX NAK\nCommand: AA 05 07 66 B1\n\r");
    pc.printf("Response: ");
    waitCTS();
    Thread::wait(10);  
                  
    device.putc(0XAA);      
    device.putc(0X05);
    device.putc(0X07);
    device.putc(0X66);
    device.putc(0XB1);
    
    postCommand();
    printPacket();
    clearPacket();
    pc.printf("\n");
}