#include "mbed.h"                   
#include "rtos.h"
#include "Stingr.h"

Serial stingrUART(p13, p14, 9600);  // tx, rx Comunicación Serial con el STINGR
Serial pc(USBTX, USBRX, 9600);      // tx, rx Comunicación Serial con la PC
I2CSlave slave(p9, p10);            // sda, scl

const int BUF_LEN = 200;
const int I2C_ADDR = 0x1E;
const int I2C_FREQ = 400000;

Stingr stingr;

int main() 
{     
// I2C variables
    slave.frequency(I2C_FREQ);      // 400 MHz interface
    slave.address(I2C_ADDR);        // slave address
    
// local vars
    char buf[BUF_LEN];              // read array from master
        
// I2C communication
    while(1) 
    {
        int state = slave.receive();
        switch(state)
        {
// Master reads from slave
            case I2CSlave::ReadAddressed:              
                slave.write(stingr.get_resp(), strlen(stingr.get_resp()) + 1);      
                printf("Writing to Master:\t<<- %s\n", stingr.get_resp()); 
                break;
// Master writes to slave
            case I2CSlave::WriteAddressed:
                slave.read(buf, 200);                   // Read up to 200 characters from Master
                printf("\n\nReading from Master:\t->> %s\n", buf);
                stingr.command(buf);
                break;
        }
    }     
} 
