#include "mbed.h"                   //Se declara la librería mbed.
#include "rtos.h"

I2CSlave slave(p9, p10); //sda,scl
DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);
Serial pc(USBTX, USBRX, 9600);      // tx, rx Conunicación Serial con la PC

// Pin Digital de entrada "CTS" en modo Pull-Up, para encontrarse normalmente a VCC cuando no haya un pulso. 
DigitalIn CTS(p11, PullUp);     //p7 proto // p11 AguilaBoard

// Pin Digital de Salida "RTS"; Predefinido para valer 1 en su estado inactivo dentro del código.
DigitalOut RTS(p12, 1);         //p8 proto // p12 AguilaBoard   

Serial stingr(p13, p14, 9600);      // tx, rx Comunicación Serial con el Módulo STX3

int flag=1;                         // Declaración de la Bandera.
int incomingByte=0;
Thread thread;
int packet[15]; //int or char
int num = 0;

void clearPacket();
void printPacket();
void respuesta();
void waitCTS();
void postCommand();

bool queryESN();
bool abortTransmission();
bool queryFirmware();
bool queryHardware();
int queryBursts();
long int querySetup();
bool sendData(char* s);
void _setup();

void NAKcommand();
uint16_t ModRTU_CRC(char * buf, int len);
void combine(char* s, char c);
        
int main() 
{ 
    //i2c variables
    slave.frequency(400000);
    char buf[200];
    char msg[200];
    slave.address(0x1E);
    
    int bursts = 0;
    int long numSetup = 0;
    thread.start(respuesta);
    
    while(1)
    {
        int i = slave.receive();
        
        switch(i)
        {
            // WRITING RESPONSES
            // Slave writes to Master. Master reads.
            case I2CSlave::ReadAddressed: 
                slave.write(msg, strlen(msg) + 1); // Includes null char
                slave.stop();
                printf("Writing to Master:\t<<- %s\n", msg);
                break;
             
            // READING COMMANDS
            // Master writes to Slave. Slave reads.
            case I2CSlave::WriteAddressed: 
                slave.read(buf, 200); //Read up to 30 characters from Master
                //slave.stop();
                printf("\n\nReading from Master:\t->> %s\n", buf);
                char j = buf[0];
                
                switch(j)
                {
                    case '0':   //Handshake
                    {
                        // if 'a' is received
                        pc.printf("Received I2C handshake transmission from Master\n");
                        strncpy(msg,"I2C Success",sizeof(msg));
                        break;    
                    }
                    case 'a':
                    {
                        if (queryESN() == true)
                        {
                            pc.printf("\nQuery ESN is correct. VALID\n");
                            strncpy(msg,"Query ESN is correct",sizeof(msg));
                        }
                        else
                        {
                            pc.printf("\nNAK response. INVALID\n");    
                            strncpy(msg,"NAK response (Query ESN)",sizeof(msg));    
                        }
                        break;
                    }
                    case 'b':
                    {
                        bursts = queryBursts();
                        if (bursts != 99)
                        {
                            char qry[2];
                            sprintf(qry,"%d",bursts); 
                            char strt[] = "Bursts Remaining is ";   
                            strcat(strt,qry);
                            
                            pc.printf("\nBursts Remaining: \t");
                            pc.printf("%u",bursts); 
                            pc.printf("\n");
                            
                            strncpy(msg,strt,sizeof(msg));
                        }
                        else 
                        {
                            pc.printf("\nNAK response. INVALID"); 
                            strncpy(msg,"NAK response (Query Bursts)",sizeof(msg));
                        }
                        break;
                    }
                    case 'c':
                    {
                        if (queryFirmware() == true)
                        {
                            pc.printf("\nResponse Processing:\tQuery Firmware is correct. VALID\n");
                            pc.printf(" Firmware Version: 1.3\n");
                            strncpy(msg,"Query Firmware is correct",sizeof(msg)); 
                        }
                        else
                        {
                            pc.printf("NAK. INVALID");
                            strncpy(msg,"NAK response (Query Firmware)",sizeof(msg));
                        }
                        break;
                    }
                    case 'd':
                    {
                        numSetup = querySetup();
                        if (numSetup == NULL)
                            pc.printf("NAK");
                        
                        char qryRF[1];
                        char qryBursts[2];
                        char qryMin[3];
                        char qryMax[3];

                        char strt[] = "";   
                            
                        //Print Channel 
                        pc.printf("\n RF Channel: ");
                        pc.printf("%u",numSetup/(10000000)); 
                        int rfprint = numSetup/(10000000);                  // RF channel
                        sprintf(qryRF,"%d",rfprint);
                        strcat(strt,qryRF);
                        numSetup = numSetup - (numSetup/10000000)*10000000; // Truncate RF Digits
                        
                        //Print Bursts
                        pc.printf("\n # of Bursts: ");
                        pc.printf("%u",numSetup/(100000));                  // Bursts Per Message
                        int burprint = numSetup/(100000);
                        sprintf(qryBursts,"%d",burprint);
                        strcat(strt,qryBursts);
                        numSetup = numSetup - (numSetup/100000)*100000;     // Truncate Burst Digits
                        
                        //Print Min Interval
                        pc.printf("\n Min Burst Interval: ");
                        pc.printf("%u",numSetup/1000*5);                    // Min Interval
                        int minprint = numSetup/1000*5;
                        sprintf(qryMin,"%d",minprint);
                        strcat(strt,qryMin);
                        numSetup = numSetup - (numSetup/1000)*1000;         // Truncate Min Interval
                        pc.printf(" seconds");
                        
                        //Print Max Interval
                        pc.printf("\n Max Burst Interval: ");
                        pc.printf("%u",numSetup*5);
                        int maxprint = numSetup*5;                          // Max Interval
                        sprintf(qryMax,"%d",maxprint);
                        strcat(strt,qryMax);
                        pc.printf(" seconds\n");
                        
                        strncpy(msg,strt,sizeof(msg));
                        
                        break;
                    }
                    case 'e':
                    {
                        if (queryHardware() == true)
                        {
                            pc.printf("\nResponse Processing:\tQuery Hardware is correct. VALID\n");
                            pc.printf(" Device Code: 01\n");
                            pc.printf(" CPU Revision: 62\n");
                            pc.printf(" Radio Revision: 62\n");
                            strncpy(msg,"Query Hardware is correct",sizeof(msg)); 
                        }
                        else
                        {
                            pc.printf("NAK. INVALID");
                            strncpy(msg,"NAK response (Query Hardware)",sizeof(msg));
                        }
                        break;
                    }
                    case 'f':
                    {
                        NAKcommand();  
                        strncpy(msg,"NAK response",sizeof(msg));            
                        break;
                    }
                    case 'g':
                    {
                        _setup();   
                        strncpy(msg,"Setup changed",sizeof(msg));           
                        break;
                    }
                    case 'h':
                    {
                        int cnt = 0; //Counter for all the characters before pressing "Return" key
                        
                        //This loop counts all characters before the "Return" key in the buffer
                        for (int k = 0; k < 200; k++)
                        {
                            if(buf[k] == '\n') 
                                break;
                            cnt++; 
                        }  
                        
                        pc.printf("0x00\t\t\tSend Data\n\r");
                        cnt--; //Decrement total by 1. Don't count 8.
                        pc.printf("Data Packet length: \t%u\n",cnt);     //Decrement total by 1
                        
                        char str[cnt];  //Declare str array. str will copy buf but without '8'
                        //Define str array. str will copy buf but without '8'
                        for (int k = 0; k < cnt; k++)
                            str[k] = buf[k+1]; //Starts 1 index after '8'.
                        
                        //Declare str1 array. str1 copies str but with
                        //the correct datalength by truncating the extra characters
                        //found in str        
                        char str1[cnt]; 
                        strncpy(str1,str,cnt); //truncation of extra characters
                        str1[cnt] = '\0'; //Null character
                        
                        pc.printf("Data Packet: \t\t%s \n",str1);
                        
                        //Execute Command "Send Data"
                        //sendData(str1); 
                        if (sendData(str1) == true)
                        {
                            pc.printf("\nSend Data is successful. VALID\n");
                            strncpy(msg,"Send Data is successful",sizeof(msg));
                        }
                        else
                        {
                            pc.printf("\nNAK response. INVALID");  
                            strncpy(msg,"NAK response (Send Data)",sizeof(msg));
                        }            
                        break;
                    }
                    case 'i':
                    {
                        if (abortTransmission() == true)
                        {
                            pc.printf("\nResponse Processing:\tTransmission successfully aborted.\n");
                            strncpy(msg,"Transmission successfully aborted.",sizeof(msg));
                        }
                        else
                        {
                            pc.printf("\nResponse Processing:\tNAK response. INVALID");   
                            strncpy(msg,"NAK response (Abort Transmission)",sizeof(msg));     
                        }
                        break; //break case '9'
                    }
                } // switch(j) loop ends
                break; //break write addressed
        } // switch(i) loop ends
        //for(int i = 0; i < 30; i++) buf[i] = 0;    // Clear buffer
    } // while(1) loop ends      
} // main loop ends

void clearPacket()
{
    num = 0;
    for(int i = 0; i < 15 ; i++)
        packet[i] = 0;
}

void printPacket()
{
    pc.printf("\nResponse(Decimal): \t");
    for(int i = 0; i < 15 ; i++)
    {
        pc.printf("%u",packet[i]);  // Format specifier
        pc.printf(" ");
    }
}

void respuesta()
{
    while(1)
    {
        if(stingr.readable()) 
        {   // Se esperan datos provenientes del TX del módulo STX3
            incomingByte = stingr.getc();
            packet[num] = incomingByte;
            pc.printf("%X",incomingByte);  // Format specifier
            pc.printf(" ");
            num++;
        }
    }
}

void waitCTS()
{
    Thread::wait(200);                                                    // Se da un tiempo para que el analizador se estabilice
    incomingByte=0;
    //pc.printf("El valor de CTS es %d\n\r",CTS.read());        // Se lee el valor de la variable CTS, la cual debe ser 1
    //pc.printf("El valor de RTS es %d\n\r",RTS.read());        // Se lee el valor de la variable RTS, la cual debe ser 1
    RTS=0;                                                      // Se manda un pulso en bajo en RTS, para inicial el proceso de transmisión
    
    while(flag==1)
    {// Flag inicialmente vale 1, así que el ciclo while cambiará hasta que esa condición no se cumpla           
        flag=CTS.read();        // Cuando entra el ciclo, se iguala flag a CTS, el cual cuando cambie a 0 provocará que termine el while (máx 125 ms)
        //pc.printf("El valor de flag es %d\n\r", flag);    // Se imprime el valor de flag, para identificar cuando termina el ciclo while
    }
}

void postCommand()
{
    Thread::wait(10);                // Se esperan .1 segundos una vez que se terminaron de hacer las transmisiones
    //El tiempo total de transmisión es; el wait previo a las transmisiones, el tiempo que tarda el Mu en enviar los datos y el wait posterior a la transmisión
    RTS=1;
    Thread::wait(150);
    //pc.printf("\n\rCTS: %d\n\r",CTS.read());
    flag=1;
}
                           
//0x00 Send Data
bool sendData(char* b) //char* s
{
    led4=!led4;
    waitCTS();
    Thread::wait(10);                
    
    size_t n = strlen(b);   //Measure size of b. This includes the zeros
    int number = n+3;
    int len = n+5;
    char header[3] = {0xAA,len,0x00};  //Define header information
    char vec[number];
    //pc.printf("number = %u\n",number);
    
    //store all in vec
    for(int k = 0; k < 3; k++)
       vec[k] = header[k];
    for(int k = 3; k < number; k++)
       vec[k] = b[k-3];
       
    pc.printf("Command(HEX):\t\t");
    //Print b characters in HEX
    for(int k = 0; k < number; k++)   
        pc.printf("%X ",vec[k]); 
    
    char *t = (char *)vec;    //a
    char crc1 = ModRTU_CRC(t,t[1]-2)&0xFF;
    char crc2 = ModRTU_CRC(t,t[1]-2)>>8;
    
    pc.printf("%X ",crc1); //%X print char in HEX format
    pc.printf("%X ",crc2); //%X print char in HEX format
    pc.printf("\nResponse(HEX):\t\t");
    
    //Send Command to STINGR
    for(int k = 0; k < number; k++)
        stingr.putc(vec[k]);
    stingr.putc(crc1);
    stingr.putc(crc2);
    
      
    postCommand();
    printPacket();
    
    //If NAK response
    if (packet[0] == 170 && // 0xAA
        packet[1] ==   5 && // 0x05
        packet[2] == 255 && // 0xFF
        packet[3] == 161 && // 0xA1
        packet[4] == 203)   // 0xCB
    {  
        clearPacket();
        pc.printf("\n");
        return false;  
    }
    clearPacket();
    pc.printf("\n");
    return true;
}

//0x01 Query ESN
bool queryESN()
{
    led1=!led1;
    pc.printf("\r0x01\t\t\tQuery ESN\n");
    pc.printf("Command(HEX):\t\tAA 5 1 50 D5\n\r");
    pc.printf("Response(HEX):\t\t");
    waitCTS();
    Thread::wait(10);
     
    stingr.putc(0XAA);      
    stingr.putc(0X05);
    stingr.putc(0X01);
    stingr.putc(0X50);
    stingr.putc(0XD5);  
    
    postCommand();
    printPacket();
    if (packet[3] ==   0 && // 0x00
        packet[4] ==  41 && // 0x29
        packet[5] ==  72 && // 0x48      //0x43 STINGR TLE
        packet[6] == 254)   // 0xFE      //0xB3 STINGR TLE 
    {
        clearPacket();
        return true;    
    }
    clearPacket();
    return false;
}

//0x03 Abort Transmission
bool abortTransmission()
{
    led1=!led1;
    pc.printf("\r0x03\t\t\tAbort Transmission\n");
    pc.printf("Command(HEX):\t\tAA 5 3 42 F6\n\r");
    pc.printf("Response(HEX):\t\t");
    waitCTS();
    Thread::wait(10);               
    stingr.putc(0XAA);      
    stingr.putc(0X05);
    stingr.putc(0X03);
    stingr.putc(0X42);
    stingr.putc(0XF6);
    
    postCommand();
    printPacket();
    if (packet[0] == 170 && // 0xAA
        packet[1] ==   5 && // 0x05
        packet[2] ==   3 && // 0x03
        packet[3] ==  66 && // 0x42
        packet[4] == 246)   // 0xF6
    {
        clearPacket();
        return true;    
    }
    clearPacket();
    return false;
}

//0x04 Query Bursts
int queryBursts()
{
    int bursts = 99;
    
    led2=!led2;
    pc.printf("\r0x04\t\t\tQuery Burst Remaining\n");
    pc.printf("Command(HEX):\t\tAA 5 4 FD 82\n\r");
    pc.printf("Response(HEX):\t\t");
    waitCTS();
    Thread::wait(10);
                    
    stingr.putc(0XAA);      
    stingr.putc(0X05);
    stingr.putc(0X04);
    stingr.putc(0XFD);
    stingr.putc(0X82);
    
    postCommand();
    printPacket();
    
    //If NAK response
    if (packet[0] == 170 && // 0xAA
        packet[1] ==   5 && // 0x05
        packet[2] == 255 && // 0xFF
        packet[3] == 161 && // 0xA1
        packet[4] == 203)   // 0xCB
    {
        clearPacket();
        return bursts;    
    }
    bursts = packet[3];
    clearPacket();
    return bursts;
}

//0x05 Query Firmware
bool queryFirmware()
{
    led3=!led3;
    pc.printf("\r0x05\t\t\tQuery Firmware Version\n");
    pc.printf("Command(HEX):\t\tAA 5 5 74 93\n\r");
    pc.printf("Response(HEX):\t\t");
    waitCTS();
    Thread::wait(10);               
    stingr.putc(0XAA);      
    stingr.putc(0X05);
    stingr.putc(0X05);
    stingr.putc(0X74);
    stingr.putc(0X93);        
    
    postCommand();
    printPacket();
    if (packet[3] == 1 && // 0x01
        packet[4] == 3)   // 0x03
    {
        clearPacket();
        return true;    
    }
    clearPacket();
    return false;
}

//0x06 Setup
void _setup()
{
    led3=!led3;
    pc.printf("\r0x06\t\t\tSetup\n");
    pc.printf("Command(HEX):\t\tAA 0E 06 00 00 00 00 00 03 18 30 00 CE 9C\n\r");
    pc.printf("Response(HEX):\t\t");
    waitCTS();
    Thread::wait(10);              
    stingr.putc(0XAA);      
    stingr.putc(0X0E);
    stingr.putc(0X06);
    stingr.putc(0X00);
    stingr.putc(0X00);
    stingr.putc(0X00);
    stingr.putc(0X00);
    stingr.putc(0X00);
    stingr.putc(0X03);
    stingr.putc(0X18);
    stingr.putc(0X30);
    stingr.putc(0X00);
    stingr.putc(0XCE);
    stingr.putc(0X9C);
    
    postCommand();
    printPacket();
    
    pc.printf("\n");
    clearPacket();
}

//0x07 Query Setup
long int querySetup()
{
    int numSetup = 0;
    led4=!led4;
    pc.printf("\r0x07\t\t\tQuery Setup\n");
    pc.printf("Command(HEX):\t\tAA 5 7 66 B0\n\r");
    pc.printf("Response(HEX):\t\t");
    waitCTS();
    Thread::wait(10);
                    
    stingr.putc(0XAA);      
    stingr.putc(0X05);
    stingr.putc(0X07);
    stingr.putc(0X66);
    stingr.putc(0XB0);
    
    postCommand();
    
    //If NAK response
    if (packet[0] == 170 && // 0xAA
        packet[1] ==   5 && // 0x05
        packet[2] == 255 && // 0xFF
        packet[3] == 161 && // 0xA1
        packet[4] == 203)   // 0xCB
    {
        clearPacket();
        return NULL;    
    }
    numSetup = packet[7]*10000000 + packet[8]*100000 + packet[9]*1000 + packet[10];
    clearPacket();
    return numSetup;
}

//0x09 Query Hardware
bool queryHardware()
{
    led1=!led1;
    pc.printf("\r0x09\t\t\tQuery Hardware Version\n");
    pc.printf("Command(HEX):\t\tAA 5 9 18 59\n\r");
    pc.printf("Response(HEX):\t\t");
    waitCTS();
    Thread::wait(10);                
    
    stingr.putc(0XAA);      
    stingr.putc(0X05);
    stingr.putc(0X09);
    stingr.putc(0X18);
    stingr.putc(0X59);
    
    postCommand();
    printPacket();
    
    
    if (packet[5] == 143 && // 0x8F
        packet[6] == 98  && // 0x62
        packet[7] == 98)    // 0x62
    {
        clearPacket();
        return true;    
    }
    
    
    clearPacket();
    pc.printf("\n");
    return false;
}

//NAK Command
void NAKcommand()
{
    led2=!led2;
    pc.printf("\rXxXX\t\t\tNAK\n");
    pc.printf("Command(HEX):\t\tAA 5 7 66 B1\n\r");
    pc.printf("Response(HEX):\t\t");
    waitCTS();
    Thread::wait(10);  
                  
    stingr.putc(0XAA);      
    stingr.putc(0X05);
    stingr.putc(0X07);
    stingr.putc(0X66);
    stingr.putc(0XB1);
    
    postCommand();
    printPacket();
    clearPacket();
    pc.printf("\n");
}

uint16_t ModRTU_CRC(char * buf, int len)
{
  unsigned char i;
  unsigned short data;
  uint16_t crc = 0xFFFF;
 
  do{
    data = (unsigned int)0x00FF & *buf++;
    crc = crc ^ data;

    for(i = 8; i > 0; i--)
    {
      if(crc & 0x0001)
        crc = (crc >> 1) ^ 0x8408;
      else
        crc >>=1;  
    }
    
  }while (--len);
  
  crc = ~crc;
  
  // Note, this number has low and high bytes swapped, so use it accordingly (or swap bytes)
  return (crc);  
}

void combine(char* s, char c) 
{
  int len = strlen(s);
  s[len] = c;
  s[len+1] = '\0';
}
