#include "mbed.h"                   // Se declara la librería mbed.
#include "rtos.h"

// Serial communication to PC
Serial pc(USBTX, USBRX, 9600);      

// STINGR connections
DigitalIn CTS(p7, PullUp);          // Entrada "CTS" en modo Pull-Up, para encontrarse normalmente a VCC cuando no haya un pulso. 
DigitalOut RTS(p8, 1);              // Salida "RTS"; Predefinido para valer 1 en su estado inactivo dentro del código.
Serial device(p9, p10, 9600);       // tx, rx Comunicación Serial con el Módulo STINGR

// Declared functions
//void stx3();          // stx3() and waitCTS() appear to be same functions                            
uint16_t ModRTU_CRC(char *buf, int len);    // returns CRC bytes
void respuesta();
void waitCTS(); 

// Global variables
int flag = 1;           // Declaración de la Bandera.
int incomingByte = 0;   // Used to collect bytes from STINGR responses
Thread thread;          // Declaration to run threads
int packet[15];         // STINGR response array
int num = 0;            // packet[15] index variable
AnalogIn ain(p20);      // Initialize pin for analog input 
int counter = 0;
        
        
int main() 
{
    // SETUP___________________________________________________________________ 
    //thread.start(stx3);
    thread.start(respuesta);    // STINGR responses to commands
    
    // Send Setup Command
    waitCTS();
    
    device.putc(0XAA);       
    device.putc(0X0E);
    device.putc(0X06);
    device.putc(0X00);
    device.putc(0X00);
    device.putc(0X00);
    device.putc(0X00);
    
    device.putc(0X00); //RF Channel (A)
    device.putc(0X01); //Bursts (1)
    device.putc(0X01); //Interval min (5 seconds)
    device.putc(0X02); //Interval max (10 seconds)
    
    device.putc(0X00); 
    device.putc(0X21);  // CRC 1
    device.putc(0X39);  // CRC 2
    // Post Command --------------------------
    Thread::wait(10); //comment?               // Se esperan .1 segundos una vez que se terminaron de hacer las transmisiones
    //El tiempo total de transmisión es; el wait previo a las transmisiones, el tiempo que tarda el Mu en enviar los datos y el wait posterior a la transmisión
    RTS=1;
    Thread::wait(150); //comment?
    pc.printf("\n\rCTS: %d\n\r",CTS.read());
    flag=1;
    // ---------------------------------------
    Thread::wait(3000);
    
    // LOOP____________________________________________________________________
    while(true) 
    {        
        printf("Fault sin pc");
        
        // read the input voltage. represented as a float in the range [0.0, 1.0]
        // scaled by 3300 for a range of [0.0, 3300.0] 
        float voltage = 3300 * ain.read();
        
        // regardless, print the voltage reading (in float format; %f) for debugging 
        printf("voltage [0,3300]: %f \n", voltage);
        
        if(voltage == 0)    
        {
            printf("Fault -- Voltage is 0");
        }
        
        else if(voltage < 400)
        {
            printf("Preheating");  
            //Question: How long does preheating take?
            //If preheating is quick, make a rewritable delay.
            //      5 second delay loops for preheating
            //      30 second delay loops for transmitting 
            //otherwise, there will be an undesirable long 30 second delay
        }
        
        else // (voltage >= 400)
        {  
            int voltage_diference = voltage - 400;  // ?? Why subtract 400
            int ppm = voltage_diference*50.0/16.0;  // ?? voltage to ppm conversion?
            
            // Printing voltage and ppm
            printf("voltage es: %f mV \n", voltage);
            printf("concentracion de C02 en ppm es: %X \n", ppm);
            
            // Wake-up STINGR communication
            //stx3();
            waitCTS();
            
            // Create Command vector -----------------
            // ?? Command length is 7 bytes?
            //      * 3 header bytes, 2 data bytes, 2 CRC bytes? 
            int number = 5; 
            char header[3] = {0xAA,0x07,0x00};  // Define header information
            char vec[number];                   // 3 header bytes, 2 data bytes
            
            // store header to vec
            for(int k = 0; k < 3; k++)
                vec[k] = header[k];
            
            // Break ppm integer(2 bytes) into separate c1,c2 uint8_t(bytes)
            uint8_t c1 = ppm;
            uint8_t c2 = ppm >> 8;
            
            // store data bytes to vec
            vec[3] = c2;
            vec[4] = c1;
    
            // Print characters in HEX (Debugging)
            pc.printf("Command(HEX):\t\t");
            for(int k = 0; k < number; k++)   
                pc.printf("%X ",vec[k]); 
            
            // CRC calculation -----------------------
            char *t = (char *)vec;    
            char crc1 = ModRTU_CRC(t,t[1]-2)&0xFF;
            char crc2 = ModRTU_CRC(t,t[1]-2)>>8;
    
            pc.printf("%X ",crc1); //%X print char in HEX format
            pc.printf("%X ",crc2); //%X print char in HEX format
            pc.printf("\nResponse: ");
            
            // Send Command to STINGR ----------------
            for(int k = 0; k < number; k++)
                device.putc(vec[k]);
            device.putc(crc1);
            device.putc(crc2);  
            
            // Post Command --------------------------
            Thread::wait(10); //comment?               // Se esperan .1 segundos una vez que se terminaron de hacer las transmisiones
            //El tiempo total de transmisión es; el wait previo a las transmisiones, el tiempo que tarda el Mu en enviar los datos y el wait posterior a la transmisión
            RTS=1;
            Thread::wait(150); //comment?
            pc.printf("\n\rCTS: %d\n\r",CTS.read());
            flag=1;
            // ---------------------------------------
            counter++;
                     
        }// else statement ends
        
        if (counter < 30)
        {
            for(int u = 0; u < 2; u++)
                Thread::wait(60000);   // LOOP delay. 1 minuto (Note: units are in milliseconds)
        }
        else
        {
            for(int u = 0; u < 30; u++)
                Thread::wait(60000);   // LOOP delay. 1 minuto (Note: units are in milliseconds)
        }
    }// LOOP (while statement) ends____________________________________________
    
}// main function ends

/*
void stx3()
{
    wait(200);                                                    // Se da un tiempo para que el analizador se estabilice
    incomingByte=0;
    pc.printf("El valor de CTS es %d\n\r",CTS.read());        // Se lee el valor de la variable CTS, la cual debe ser 1
    pc.printf("El valor de RTS es %d\n\r",RTS.read());        // Se lee el valor de la variable RTS, la cual debe ser 1
    RTS=0;   
                                                       // Se manda un pulso en bajo en RTS, para inicial el proceso de transmisión
    while(flag==1)
    {             // Flag inicialmente vale 1, así que el ciclo while cambiará hasta que esa condición no se cumpla           
        flag=CTS.read();        // Cuando entra el ciclo, se iguala flag a CTS, el cual cuando cambie a 0 provocará que termine el while (máx 125 ms)
        pc.printf("El valor de flag es %d\n\r", flag);    // Se imprime el valor de flag, para identificar cuando termina el ciclo while
    }
}
*/

uint16_t ModRTU_CRC(char * buf, int len)
{
  unsigned char i;
  unsigned short data;
  uint16_t crc = 0xFFFF;
 
  do{
    data = (unsigned int)0x00FF & *buf++;
    crc = crc ^ data;

    for(i = 8; i > 0; i--)
    {
      if(crc & 0x0001)
        crc = (crc >> 1) ^ 0x8408;
      else
        crc >>=1;  
    }
    
  }while (--len);
  
  crc = ~crc;
  
  // Note, this number has low and high bytes swapped, so use it accordingly (or swap bytes)
  return (crc);  
}

void respuesta()
{
    while(1)
    {
        if(device.readable()) 
        {   // Se esperan datos provenientes del TX del módulo STX3
            incomingByte = device.getc();
            packet[num] = incomingByte;
            pc.printf("%X",incomingByte);  // Format specifier
            pc.printf(" ");
            num++;
        }
    }
}

void clearPacket() //reuired function for respuesta
{
    num = 0;
    for(int i = 0; i < 15 ; i++)
        packet[i] = 0;
}

void waitCTS()
{
    Thread::wait(200);                                                    // Se da un tiempo para que el analizador se estabilice
    incomingByte=0;
    //pc.printf("El valor de CTS es %d\n\r",CTS.read());        // Se lee el valor de la variable CTS, la cual debe ser 1
    //pc.printf("El valor de RTS es %d\n\r",RTS.read());        // Se lee el valor de la variable RTS, la cual debe ser 1
    RTS=0;                                                      // Se manda un pulso en bajo en RTS, para inicial el proceso de transmisión
    
    while(flag==1)
    {// Flag inicialmente vale 1, así que el ciclo while cambiará hasta que esa condición no se cumpla           
        flag=CTS.read();        // Cuando entra el ciclo, se iguala flag a CTS, el cual cuando cambie a 0 provocará que termine el while (máx 125 ms)
        //pc.printf("El valor de flag es %d\n\r", flag);    // Se imprime el valor de flag, para identificar cuando termina el ciclo while
    }
}

