#include "QSPIBitmap.h"

#include <stdio.h>
#include <string.h>

#include <fstream>




// The default constructor exists purely to satisfy the compiler - it is not intended to be used
QSPIBitmap::QSPIBitmap()
{
    name[0] = '\0';
    
    size = 0;
    debugVar1 = 0;
        
    //data = NULL;
    
    bitmapLoaded = false;
}

QSPIBitmap::QSPIBitmap(char* bitmapName)
{
    strcpy(name, bitmapName);
    
    // Set these when we read the bitmap from the QSPI drive
    size = 0;
    debugVar1 = 0;
    data = NULL;
    
    bitmapLoaded = GetBitmapFromQSPIDrive();
}

QSPIBitmap::~QSPIBitmap()
{   
    if(data) {
        delete [] data;
    }
}

bool QSPIBitmap::ReadBitmapSizeFile(void)
{
    char bitmapSizeFilename[200];
    sprintf(bitmapSizeFilename, "/qspi/%s_BMP.size", name);
    
    char buff[50];
    
    FILE *fpsize = fopen(bitmapSizeFilename, "r");
    if (fpsize != NULL) {
        // We expect the size value to be 6 digits
        fread(buff, 6, 1, fpsize);
        fclose(fpsize);

        buff[6] = '\0';
        
        sscanf(buff, "%d", &size);
        
        return true;
    }
    
    // 'else'...
    
    return false;
}

bool QSPIBitmap::ReadBitmapDataFile(void)
{
    char bitmapDataFilename[200];
    sprintf(bitmapDataFilename, "/qspi/%s_BMP.data", name);

    FILE *fpdata = fopen(bitmapDataFilename, "rb");
    if (fpdata != NULL) {
        fread(data, size, 1, fpdata);
        fclose(fpdata);
        
        return true;
    }
        
    // 'else'...
    
    return false;
}

bool QSPIBitmap::GetBitmapFromQSPIDrive(void)
{
    //TODO: Raise exceptions(?) if any of the below fails
    
    debugVar1 = 1;
    
    if(ReadBitmapSizeFile()) {
        debugVar1 = 3;
    } else {
        debugVar1 = 2;
        return false;
    }
    
    debugVar1 = 4;
    
    // Do not throw an exception if the allocation fails - just leave 'data' set to NULL
    data = new (nothrow) GuiConst_INT8U[size + 10]; // Leave a small margin 'just in case'
// TEST - what if the 'new' fails??
// Answer - looks same as what Andrew saw at PittCon 2017
    
    if(data == NULL) {
        return false;
    }
    
    if(ReadBitmapDataFile()) {
        debugVar1 = 5;
    } else {
        debugVar1 = 6;
        return false;
    }

    debugVar1 = 7;
    
    return true;
}

void QSPIBitmap::DisplayAt(GuiConst_INT16S X, GuiConst_INT16S Y, GuiConst_INT32S transparentColour)
{
    if(bitmapLoaded) {    
        GuiLib_ShowBitmapAt(data, X, Y, transparentColour);
    } else {
        char buff[100];
        sprintf(buff, "Bitmap not loaded - size %d, debugVar1: %d", size, debugVar1);
        
        char bitmapSizeFilename[200];
        sprintf(bitmapSizeFilename, "/qspi/%s_BMP.size", name);
    }
}

