#ifndef QSPIBITMAP_H
#define QSPIBITMAP_H

#include "mbed.h"
#include "DMBoard.h"

#include "GuiLib.h"
#include "GuiDisplay.h"

#include "QSPIFileSystem.h"

class QSPIBitmap
{
public:
    QSPIBitmap();
    
    QSPIBitmap(char* bitmapName);
        
    ~QSPIBitmap();
    
    void DisplayAt(GuiConst_INT16S X, GuiConst_INT16S Y, GuiConst_INT32S transparentColour); 
    
    bool BitmapLoaded(void) { return bitmapLoaded; }
    
private:
    char name[200];
    
    int size;
    int debugVar1;
    
    GuiConst_INT8U* data;
//    GuiConst_INT8U data[10000];
    
    bool ReadBitmapSizeFile(void);
    bool ReadBitmapDataFile(void);
    bool GetBitmapFromQSPIDrive(void);
    bool bitmapLoaded;
};


#endif //QSPIBITMAP_H
