#include "mbed.h"
#include "DMBoard.h"
#include "lpc_swim.h"
#include "lpc_swim_font.h"

#include "GuiLib.h"
#include "GuiDisplay.h"

/*
    Bodge so GuiDisplay.c ('easyGUIFixed' file) can call Thread::wait 
    (giving it an accurate millisecond timer)
*/
extern "C" {
    void EasyGUIWaitMs(GuiConst_INT32U msec)
    {
        Thread::wait(msec);
    }
}

// Defined in GuiDisplay.c - set the display frame address at runtime
extern "C" {
    void GuiDisplay_SetFrameAddress(void *newFrameAddress);
}

/*
    Displays the specified easyGUI 'structure' (or page, to use a more easily understood term).
    
    Args are: the index of the structure to be displayed,
              
    No return code.
*/
void DisplayEasyGuiStructure(int structureIndex)
{
    GuiLib_Clear(); // Don't need this if we have drawn the background bitmap - it covers the entire screen

    GuiLib_ShowScreen(structureIndex, GuiLib_NO_CURSOR, GuiLib_RESET_AUTO_REDRAW);
                        
    GuiLib_Refresh();

} // End of "DisplayEasyGUIStructure"

/*
    Sets up the easyGUI user interface in an acceptable initial state.

    No return code.
*/
void InitEasyGUIDisplay(int initialEasyGUIPage)
{
    // easyGUI stuff - note function calls require 'extern "C"' in relevant header
    
    GuiDisplay_Lock();
    
    GuiLib_Init();
  
    DisplayEasyGuiStructure(initialEasyGUIPage);
    
//    GuiLib_ShowBitmap(GuiStruct_Bitmap_DSC_1836Reduced, 40, 0, -1);
  
    GuiDisplay_Unlock();
}


void InitialiseLPC4088(DMBoard* board, void **frameBufferAddress1, void **frameBufferAddress2)
{
    RtosLog* log = board->logger();
    Display* disp = board->display();
  
    DMBoard::BoardError err;

    do {
        err = board->init();
        if (err != DMBoard::Ok) {
            log->printf("Failed to initialize the board, got error %d\r\n", err);
            break;
        }
       

#define COLOR_FLICKERING_FIX_1
#ifdef COLOR_FLICKERING_FIX_1
        // Possible fix for display flickering on LPC4088
        uint32_t* reg = ((uint32_t*)0x400fc188);
        *reg |= (3<<10);
#undef COLOR_FLICKERING_FIX_1
#endif
        log->printf("\n\nHello World!\n\n");
    
        void* fb = disp->allocateFramebuffer();
        if (fb == NULL) {
            log->printf("Failed to allocate memory for a frame buffer\r\n");
            err = DMBoard::MemoryError;
            break;
        }
    
        *frameBufferAddress1 = fb;

        // Allocate a second frame buffer - what will its address be?
        void* fb2 = disp->allocateFramebuffer();
        *frameBufferAddress2 = fb2;
                
        Display::DisplayError disperr;
//      disperr = disp->powerUp(fb, Display::Resolution_24bit_rgb888);
        // Start display in default mode (16-bit) (24-bit uses too much memory)
#define COLOR_FLICKERING_FIX_2
#ifdef COLOR_FLICKERING_FIX_2
        // Second possible fix for colour flickering problem,
        // suggested by Embedded Artists - specify low frame rate
        disp->powerDown();
        disperr = disp->powerUp(fb, Display::Resolution_16bit_rgb565, FrameRate_Low);
#undef COLOR_FLICKERING_FIX_2
#else
        disperr = disp->powerUp(fb);
#endif
        if (disperr != Display::DisplayError_Ok) {
            log->printf("Failed to initialize the display, got error %d\r\n", disperr);
            break;
        }
        
    } while(false);

    if (err != DMBoard::Ok) {
        log->printf("\nTERMINATING\n");
        wait_ms(2000); // allow RtosLog to flush messages
        mbed_die();
    }  
}

int main()
{
    DMBoard* board = &DMBoard::instance();
    RtosLog* log = board->logger();
    Display* disp = board->display();

    void *frameBuffer1;
    void *frameBuffer2;
    InitialiseLPC4088(board, &frameBuffer1, &frameBuffer2);
    GuiDisplay_SetFrameAddress(frameBuffer1);
  
    InitEasyGUIDisplay(GuiStruct_Demo_0);
    
    while(true) {
    }   
}
