#ifndef THREADSIGNALENUMS_H
#define THREADSIGNALENUMS_H

/*
    Enum values for the different types of thread signal we use in this application.
    
    Centrally defined here so we can be sure there will be no conflicts - i.e. we cannot 
    mistakenly use the same value for two different thread signals.
*/

    typedef enum enumThreadSignals { 
        TOUCH_EVENT = 0xAA, // Alternate bits set
        TIMER_TICK = 0x55,  // ...
        
        STARTED_DOWNLOADING_METHOD = 0xB0,
        FINISHED_DOWNLOADING_METHOD = 0xC0,

        CRUN_COMMAND_SENT = 0xD0,
        CHON_COMMAND_SENT = 0xD1,
        CHOF_COMMAND_SENT = 0xD2,
        ABORT_RUN_COMMAND_SENT = 0xD3,
                
        GC_COMMAND_READY = 0x100,
        GOT_GC_COMMAND = 0x150,
        GC_RESPONSE_READY = 0x200 // This *** must *** have a higher value than all other codes
    } ThreadSignals; 

#endif // THREADSIGNALENUMS_H