#ifndef SIMPLIFIEDTOUCHLISTENER_H
#define SIMPLIFIEDTOUCHLISTENER_H

#include "mbed.h"
#include "DMBoard.h"

#include "ThreadSignalEnums.h"

#define GET_TOUCH_COORDS_AT_TOUCH_TIME

#define MULTI_TOUCH_TECHNIQUE_5 // See GetGCStatusLoop.cpp for the other four

/*
    This class handles the touch panel on the LPC4088. 
    
    It is a greatly simplified version of the original TouchListener class, to minimise the amount of code executed (and functions called)
    in response to the user touching the screen.
    
    When the user touches the 'touch panel', all this class does is send a thread signal to the main thread, nothing else.
    The main thread does the rest.
    
    Requires the ID of the thread it is to signal in response to a touch event, and a pointer to the touch panel.
*/

// Note that SimplifiedTouchListener is a singleton - we do not need or want there to be more than one instance of it
// (there is only one LPC4088, and only one touch panel)
class SimplifiedTouchListener {
public:
    /**
    * Static method to create (if necessary) and retrieve the single SimplifiedTouchListener instance
    */
    static SimplifiedTouchListener * GetInstance(osThreadId newAppThread, TouchPanel* newTouchPanel);

    static void ListenerFunction(void);
    
    bool GotTouchEvent(short *x, short *y, short *z);
    
private:
    static SimplifiedTouchListener * theSimplifiedTouchListener;

    // singleton class -> constructor is private
    SimplifiedTouchListener(osThreadId newAppThread, TouchPanel* newTouchPanel);
    
    TouchPanel* touchPanel;
    bool gotTouchEvent;
    osThreadId appThread;

    static FunctionPointer functionPointer;

// If we get the touch coords in the listener function, as soon as we are notified
// of the touch event, we can be sure that they will match the event.
// Otherwise, we wait for the main thread to respond to our signal, 
// and we get the coords then. We are seeing behaviour that indicates 
// that the coords we obtain may sometimes not be correct (Display (LPC4088) Bug Reports bug #4).
#ifdef GET_TOUCH_COORDS_AT_TOUCH_TIME
    static touch_coordinate_t touchCoords;
#endif // GET_TOUCH_COORDS_AT_TOUCH_TIME

#ifdef MULTI_TOUCH_TECHNIQUE_5
    static Timer touchTimer;
    static const uint32_t touchIntervalMilliSec;
#endif
};

#endif
