#ifndef NUMERICKEYPADHANDLER_H
#define NUMERICKEYPADHANDLER_H

#include "mbed.h"
#include "DMBoard.h"

#include "USBHostGC.h"

#include "GuiLib.h"

typedef void (*ApplyFunctionPtr)(USBDeviceConnected* usbDevice, USBHostGC* usbHostGC);

/*
    This class handles user interaction with the easyGUI "NumericKeypadPage".
    
    Note that this class is a singleton - we do not need or want there to be more than one instance of it
    (we will not show more than one "NumericKeypadPage" to the user at the same time).
*/
class NumericKeypadPageHandler {
public:
    /**
    * Static method to create (if necessary) and retrieve the single NumericKeypadPageHandler instance
    */
    static NumericKeypadPageHandler * GetInstance(USBDeviceConnected* newUsbDevice, USBHostGC* newUsbHostGC);
    
    bool TouchAreaIsOnNumericKeypadPage(int touchAreaIndex);

    bool DealWithTouch(int touchAreaIndex);
    
    void StartEditing(int initialValue, unsigned int placesOfDecimals = 0, bool wantNegative = false);
    void StartEditing(char* initialValue, unsigned int placesOfDecimals = 0, bool wantNegative = false);
    
    void StartEditingInLockMode(unsigned int newValidLockCode, int newPageToDisplayIfLockCodeValid, 
                                GuiConst_TEXT* newEasyGUIVariableForInvalidLockCodeMessage, 
                                char *newInvalidLockCodeMessage);
    
    void SetEasyGUIVariableToEdit(GuiConst_TEXT* easyGUIVariable);
    void SetInternalVariableToEdit(unsigned int* internalVariable);
    
    void SetEasyGUICallingPage(int newCallingPage);
    
    void SetEditVariableRange(int min, int max);
    
    void SetEditVariableName(char *name);
    
    void SetEditVariableUnits(const char *units);
    
    void SetApplyFunctionPtr(ApplyFunctionPtr newApplyFunctionPtr);

    void DisplayEasyGUIPage(void);


private:
    static NumericKeypadPageHandler * theNumericKeypadPageHandlerInstance;

    // singleton class -> constructor is private
    NumericKeypadPageHandler(USBDeviceConnected* newUsbDevice, USBHostGC* newUsbHostGC);
    ~NumericKeypadPageHandler();

    USBDeviceConnected* usbDevice;
    USBHostGC* usbHostGC;
    
    ApplyFunctionPtr applyFunctionPtr;
    
    void DealWithDeleteKey(void);

    void DealWithNumberKey(int touchAreaIndex);
    
    void DealWithDotKey(void);
    
    void DealWithPlusMinusKey(void);
    
    void DealWithApplyKey(void);
    
    void DealWithCancelKey(void);
    
    void DealWithClearKey(void);
    
    GuiConst_TEXT* easyGUIVariableToEdit;
    unsigned int* internalVariableToEdit;
    char editVariableUnits[40];
    
    int easyGUICallingPage;
    
    int minimumValue;
    int maximumValue;
    
    unsigned int allowedDecimalPlaces;
    bool editingFractionalPart;
    unsigned int LengthOfFractionalPart(void);
    void PadFractionalPartWithZeroesIfNecessary(void);
    
    bool allowNegativeNumbers;
    
    bool inLockMode;
    unsigned int validLockCode;
    GuiConst_TEXT* easyGUIVariableForInvalidLockCodeMessage;
    char invalidLockCodeMessage[50];
    int pageToDisplayIfLockCodeValid;
};

#endif // NUMERICKEYPADHANDLER_H