#ifndef GASCALIBRATIONPAGEHANDLER_H
#define GASCALIBRATIONPAGEHANDLER_H

#include "mbed.h"
#include "DMBoard.h"

#include "USBHostGC.h"

#include "GuiLib.h"

/*
    A struct to relate the index of an easyGUI touch area on the 'GasCalibrationPage',
    with the easyGUI variable and our own internal variable to which it corresponds
*/
typedef struct structGasCalibrationEasyGUITouchAreaAndVariables {
    int touchAreaIndex;
    GuiConst_TEXT * easyGUIVariablePtr;
    unsigned int maxValue;
    GuiConst_INTCOLOR * easyGUIBackgroundColorVariablePtr;
    char variableName[41];
} GasCalibrationEasyGUITouchAreaAndVariables;


/*
    This class handles user interaction with the easyGUI "GasCalibrationPage",
    as well as storing the values in QSPI memory.
    
    Note that this class is a singleton - we do not need or want there to be more than one instance of it
    (we do not want multiple values for the carrier gas selection, etc, and nor will we show 
    more than one easyGUI 'GasCalibrationPage' to the user at the same time).
*/
class GasCalibrationPageHandler {
public:
    /**
    * Static method to create (if necessary) and retrieve the single GasCalibrationPageHandler instance
    */
    static GasCalibrationPageHandler * GetInstance(USBDeviceConnected* newUsbDevice, USBHostGC* newUsbHostGC);
    
    bool TouchAreaIsOnCalibrationPage(int touchAreaIndex);

    bool DealWithTouch(int touchAreaIndex);
    
    void DisplayingEasyGUIPage(bool updateEasyGUIVariables);
    
private:
    enum {CARRIER_GAS_HELIUM = 0, CARRIER_GAS_HYDROGEN = 1, CARRIER_GAS_NITROGEN = 2};
    
    static GasCalibrationPageHandler * theGasCalibrationPageHandlerInstance;
    
    static const GuiConst_INTCOLOR inactiveFieldBackgroundColour;
    static const GuiConst_INTCOLOR activeFieldBackgroundColour;
    
    USBDeviceConnected* usbDevice;
    USBHostGC* usbHostGC;
    
    int indexOfValueCurrentlyBeingEdited;
    
    // singleton class -> constructor is private
    GasCalibrationPageHandler(USBDeviceConnected* newUsbDevice, USBHostGC* newUsbHostGC);    
    ~GasCalibrationPageHandler();

    void SaveCarrierGasSelectionToQSPISettings(void);
    void ReadCarrierGasSelectionFromQSPISettings(void);

    void UpdateEasyGUIPage(void);

    void GetCurrentCalibrationFromGC(void);
    void SetCurrentCalibrationInGC(void);
    
    bool GetCalibrationDACAndFlowValuesFromGC(int carrierGasSelection, int valueIndex, char *bufferForDACValue, char *bufferForFlowValue);
    bool SetCalibrationDACAndFlowValuesInGC(int carrierGasSelection, int valueIndex, char *bufferForDACValue, char *bufferForFlowValue);
    
    bool ConstructGasCalibrationGCCommand(bool wantSetCommand, int carrierGasSelection, int valueIndex, bool wantDACCommand, char *commandBuffer);
    void CopyBufferDigitsToCommand(char *commandBuffer, char *digitsBuffer);
    
    enum { COUNT_OF_VARIABLES_FOR_TOUCH_AREAS = 12 };
    GasCalibrationEasyGUITouchAreaAndVariables variablesForTouchArea[COUNT_OF_VARIABLES_FOR_TOUCH_AREAS];
    
    void SetAllFieldBackgroundColoursToInactive(void);

    int GetIndexOfValueToEditForTouchArea(int touchAreaIndex);

    void CopyCommandResponseToBufferWithoutLeadingZeroes(char *commandResponse, char *buffer);
};

#endif // GASCALIBRATIONPAGEHANDLER_H

