#ifndef GASBACKPRESSUREDACPAGEHANDLER_H
#define GASBACKPRESSUREDACPAGEHANDLER_H

#include "mbed.h"
#include "DMBoard.h"

#include "USBHostGC.h"

#include "GuiLib.h"

/*
    This class handles user interaction with the easyGUI "GasBackPressureDACPage",
    as well as storing the values in QSPI memory.
    
    Note that this class is a singleton - we do not need or want there to be more than one instance of it
    (we do not want multiple values for the gain and offset, etc, and nor will we show 
    more than one easyGUI 'GasBackPressureDACPage' to the user at the same time).
*/
class GasBackPressureDACPageHandler {
public:
    /**
    * Static method to create (if necessary) and retrieve the single GasBackPressureDACPageHandler instance
    */
    static GasBackPressureDACPageHandler * GetInstance(USBDeviceConnected* newUsbDevice, USBHostGC* newUsbHostGC);
    
    bool TouchAreaIsOnGasBackPressureDACPage(int touchAreaIndex);

    bool DealWithTouch(int touchAreaIndex);

    void DisplayingEasyGUIPage(bool updateEasyGUIVariables);    

private:

    typedef enum enumActiveField { NONE, GAIN, OFFSET } ActiveField;
    
    static const int minimumGainAndOffsetValue;
    static const int maximumGainAndOffsetValue;
    
    static const GuiConst_INTCOLOR inactiveFieldBackgroundColour;
    static const GuiConst_INTCOLOR activeFieldBackgroundColour;
    
    ActiveField currentlyActiveField;
    
    USBDeviceConnected* usbDevice;
    USBHostGC* usbHostGC;
    
    static GasBackPressureDACPageHandler * theGasBackPressureDACPageHandlerInstance;
    
    // singleton class -> constructor is private
    GasBackPressureDACPageHandler(USBDeviceConnected* newUsbDevice, USBHostGC* newUsbHostGC);    
    ~GasBackPressureDACPageHandler();

    void UpdateEasyGUIPage(void);

    bool GetCurrentGasBackPressureDACValuesFromGC(void);
    
    bool SetCurrentGasBackPressureDACValuesInGC(void);
    
    void SetAllEditableFieldsToInactive(void);

    void SelectActiveField(ActiveField thisField, ActiveField otherField, GuiConst_INTCOLOR *thisFieldBGColour, GuiConst_INTCOLOR* otherFieldBGColour);

    void ConstructSetBackPressureCommand(char *command, char gainOrOffsetCharacter, GuiConst_TEXT* easyGUIVariable);
};

#endif // GASBACKPRESSUREDACPAGEHANDLER_H
