#ifndef GCCOMPONENTSTATUSCOLORAREA_H
#define GCCOMPONENTSTATUSCOLORAREA_H

#include "GuiLib.h"

#include "GCComponentStatusEnums.h"


/*
    Classes to handle the status rectangles - these are rectangles displayed 
    along with each easyGUI "structure" (i.e. page), whose colour shows the status
    of the corresponding component. 
    
    How many rectangles there are, and their size and location, varies from 
    one "structure" to another.
*/

/*
    #define this if we want to make the colour areas look three-dimensional - 
    i.e. a white line to the top and left, black to the bottom and right
*/
#define THREE_DIMENSIONAL

class GCComponentStatusColorArea
{
public:
    GCComponentStatusColorArea();
    
    GCComponentStatusColorArea(GuiConst_INT16S X, GuiConst_INT16S Y, GuiConst_INT16S W, GuiConst_INT16S H);
    
    void SetComponentStatus(GCComponentStatus newStatus) { componentStatus = newStatus; }

    GCComponentStatus GetComponentStatus(void) { return componentStatus; }
    
    GuiConst_INTCOLOR GetCurrentColor(void);
    
    void DisplayComponentStatus(void);
    
    void SetSecondArea(GuiConst_INT16S X2, GuiConst_INT16S Y2, GuiConst_INT16S W2, GuiConst_INT16S H2);
    
    static void DisplayErrorRectangle(void);
    
private:
    
    GuiConst_INT16S x;
    GuiConst_INT16S y;
    GuiConst_INT16S w;
    GuiConst_INT16S h;
    
    bool secondAreaDefined;
    GuiConst_INT16S x2;
    GuiConst_INT16S y2;
    GuiConst_INT16S w2;
    GuiConst_INT16S h2;
    
    GCComponentStatus componentStatus;
    
    static GuiConst_INTCOLOR GetColorForComponentStatus(GCComponentStatus status);
#ifdef THREE_DIMENSIONAL
    static GuiConst_INTCOLOR GetTopBevelColorForComponentStatus(GCComponentStatus status);
    static GuiConst_INTCOLOR GetBottomBevelColorForComponentStatus(GCComponentStatus status);
    static void DisplayBevelledEdgesOnRectangle(GuiConst_INT16S rectangleLeft, GuiConst_INT16S rectangleTop, 
                                                GuiConst_INT16S rectangleRight, GuiConst_INT16S rectangleBottom,
                                                GuiConst_INTCOLOR topBevelColour, GuiConst_INTCOLOR bottomBevelColour);
#endif // THREE_DIMENSIONAL
};

/*
    The status areas for the home page - there are four in all
*/
class HomePageGCComponentStatusColorAreas
{
public:
    HomePageGCComponentStatusColorAreas();
    
    GCComponentStatusColorArea *GetColorArea(GCComponent component);
    
    void SetGCComponentStatus(GCComponent component, GCComponentStatus newStatus);
    
    GCComponentStatus GetGCComponentStatus(GCComponent component);
    
    void DisplayAll(void);
    
    void DisplayEach(bool displayColumnArea, bool displayInjectorArea, bool displayDetectorArea, bool displayGasArea);
    
    GuiConst_INTCOLOR GetComponentCurrentColor(GCComponent component);
    
private:
    enum HomePageColorAreasCount { HOME_PAGE_COLOR_AREAS_COUNT = 4 };

    GCComponentStatusColorArea *colorAreas[HOME_PAGE_COLOR_AREAS_COUNT];
};

/*
    The status areas for all four of the single component pages 
    (Column, Injector, Detector and Gas)
*/
class SingleGCComponentPageStatusColorAreas
{
public:
    SingleGCComponentPageStatusColorAreas();
    
    GCComponentStatusColorArea *GetColorArea(GCComponent component);
    
    void SetGCComponentStatus(GCComponent component, GCComponentStatus newStatus);
    
    GCComponentStatus GetGCComponentStatus(GCComponent component);
    
    void DisplayGCComponentStatus(GCComponent component);
    
private:
    enum SingleGCComponentPageColorAreasCount { SINGLE_PAGE_COLOR_AREAS_COUNT = 4 };

    GCComponentStatusColorArea *colorAreas[SINGLE_PAGE_COLOR_AREAS_COUNT];
};

#endif // GCCOMPONENTSTATUSCOLORAREA_H
