#ifndef DEBUGCOMMANDSPAGEHANDLER_H
#define DEBUGCOMMANDSPAGEHANDLER_H

#include "mbed.h"
#include "DMBoard.h"

#include "USBHostGC.h"

#include "GuiLib.h"

/*
    This class handles user interaction with the easyGUI Debug Commands page. 
    
    Note that this class is a singleton - we do not need or want there to be more than one instance of it
    (we will not show more than one Debug Commands page to the user at the same time).
*/

class DebugCommandsPageHandler {
public:
    /**
    * Static method to create (if necessary) and retrieve the single DebugCommandsPageHandler instance
    */
    static DebugCommandsPageHandler * GetInstance(USBDeviceConnected* newUsbDevice, USBHostGC* newUsbHostGC);
    
    /**
    * Version of the above that does not create the instance. Provided for callers that do not have 
    * the 'usbDevice' and 'usbHostGC' pointers, and that just want access to the instance
    */
    static DebugCommandsPageHandler * GetInstance(void);
    
    bool TouchAreaIsOnDebugCommandsPage(int touchAreaIndex);

    bool DealWithTouch(int touchAreaIndex);
    
private:    
    static DebugCommandsPageHandler * theDebugCommandsPageHandlerInstance;
    
    USBDeviceConnected* usbDevice;
    USBHostGC* usbHostGC;
    
    bool commandJustExecuted;
    
    // singleton class -> constructor is private
    DebugCommandsPageHandler (USBDeviceConnected* newUsbDevice, USBHostGC* newUsbHostGC);    
    ~DebugCommandsPageHandler();
    
    enum { MAX_COMMAND_LENGTH = 8 }; // i.e. the maximum number of characters in a command

    void SendCommandToGCAndDisplayResponse(void); // Command and response are always in the same easyGUI variables
    
    char GetCharCodeForTouchAreaIndex(int touchAreaIndex);

    void DisplayEasyGUIPage(void);
};

#endif // DEBUGCOMMANDSPAGEHANDLER_H