#ifndef COLUMNDHPSUDACPAGEHANDLER_H
#define COLUMNDHPSUDACPAGEHANDLER_H

#include "mbed.h"
#include "DMBoard.h"

#include "USBHostGC.h"

#include "GuiLib.h"


/*
    This class handles user interaction with the easyGUI "PSU_DAC_Page".
    
    Note that this class is a singleton - we do not need or want there to be more than one instance of it
    (we do not want multiple values for the calibration values, etc, and nor will we show 
    more than one easyGUI 'PSU_DAC_Page' to the user at the same time).
*/

class ColumnDHPSUDACPageHandler {
public:
    /**
    * Static method to create (if necessary) and retrieve the single ColumnDHPSUDACPageHandler instance
    */
    static ColumnDHPSUDACPageHandler * GetInstance(USBDeviceConnected* newUsbDevice, USBHostGC* newUsbHostGC);
    
    /**
    * Version of the above that does not create the instance. Provided for callers that do not have 
    * the 'usbDevice' and 'usbHostGC' pointers, and that just want access to the instance
    */
    static ColumnDHPSUDACPageHandler * GetInstance(void);
    
    bool TouchAreaIsOnPSUDACPage(int touchAreaIndex);

    bool DealWithTouch(int touchAreaIndex);
    
    void DisplayingEasyGUIPage(bool updateEasyGUIVariables);

private:    
    static ColumnDHPSUDACPageHandler * theColumnDHPSUDACPageHandlerInstance;
    
    USBDeviceConnected* usbDevice;
    USBHostGC* usbHostGC;
    
    // singleton class -> constructor is private
    ColumnDHPSUDACPageHandler(USBDeviceConnected* newUsbDevice, USBHostGC* newUsbHostGC);    
    ~ColumnDHPSUDACPageHandler();
    
    bool GetCurrentPSUDACValueFromGC(void);
    bool SetCurrentPSUDACValueInGC(void);

    void SendCommandToGCAndGetResponse(char* command, char* response);
    bool SendCommandToGCWithDACKResponse(char *cmd);

    void UpdateEasyGUIPage(void);
};

#endif // COLUMNDHPSUDACPAGEHANDLER_H
