#ifndef COLUMNDHMANUALCALIBRATIONPAGEHANDLER_H
#define COLUMNDHMANUALCALIBRATIONPAGEHANDLER_H

#include "mbed.h"
#include "DMBoard.h"

#include "USBHostGC.h"

#include "GuiLib.h"

/*
    A struct to relate the index of an easyGUI touch area on the 'ColumnDHManualCalibrationPage',
    with the easyGUI variable and our own internal variable to which it corresponds
*/
typedef struct structColumnDHManualCalibrationEasyGUITouchAreaAndVariables {
    int touchAreaIndex;
    GuiConst_TEXT * easyGUIVariablePtr;
    unsigned int maxValue;
    unsigned int placesOfDecimals;
    char variableTitle[41];
    char sprintfFormat[10];
} ColumnDHManualCalibrationEasyGUITouchAreaAndVariables;


/*
    This class handles user interaction with the easyGUI "ColumnDHManualCalibrationPage".
    
    Note that this class is a singleton - we do not need or want there to be more than one instance of it
    (we do not want multiple values for the calibration values, etc, and nor will we show 
    more than one easyGUI 'ColumnDHManualCalibrationPage' to the user at the same time).
*/

class ColumnDHManualCalibrationPageHandler {
public:
    /**
    * Static method to create (if necessary) and retrieve the single ColumnDHManualCalibrationPageHandler instance
    */
    static ColumnDHManualCalibrationPageHandler * GetInstance(USBDeviceConnected* newUsbDevice, USBHostGC* newUsbHostGC);
    
    /**
    * Version of the above that does not create the instance. Provided for callers that do not have 
    * the 'usbDevice' and 'usbHostGC' pointers, and that just want access to the instance
    */
    static ColumnDHManualCalibrationPageHandler * GetInstance(void);
    
    bool TouchAreaIsOnCalibrationPage(int touchAreaIndex);

    bool DealWithTouch(int touchAreaIndex);
    
    void DisplayingEasyGUIPage(bool updateEasyGUIVariables);

private:    
    static ColumnDHManualCalibrationPageHandler * theColumnDHManualCalibrationPageHandlerInstance;
    
    USBDeviceConnected* usbDevice;
    USBHostGC* usbHostGC;
    
    // singleton class -> constructor is private
    ColumnDHManualCalibrationPageHandler(USBDeviceConnected* newUsbDevice, USBHostGC* newUsbHostGC);    
    ~ColumnDHManualCalibrationPageHandler();
    
    void GetCurrentCalibrationFromGC(void);
    void SetCurrentCalibrationInGC(void);

    void SendCommandToGCAndGetResponse(char* command, char* response);
    bool SendCommandToGCWithDACKResponse(char *cmd);

    bool GetColumnTemperaturePointFromGC(int pointNumber, GuiConst_TEXT* easyGUIVariable);
    bool GetColumnResistancePointFromGC(int pointNumber, GuiConst_TEXT* easyGUIVariable);

    bool SetColumnTemperaturePointInGC(int pointNumber, GuiConst_TEXT* easyGUIVariable);
    bool SetColumnResistancePointInGC(int pointNumber, GuiConst_TEXT* easyGUIVariable);

    void UpdateEasyGUIPage(void);

    enum { COUNT_OF_VARIABLES_FOR_TOUCH_AREAS = 6 };
    ColumnDHManualCalibrationEasyGUITouchAreaAndVariables variablesForTouchArea[COUNT_OF_VARIABLES_FOR_TOUCH_AREAS];

    int GetIndexOfValueToEditForTouchArea(int touchAreaIndex);

};

#endif // COLUMNDHMANUALCALIBRATIONPAGEHANDLER_H