#ifndef COLUMNDHAUTOCALIBRATIONPAGEHANDLER_H
#define COLUMNDHAUTOCALIBRATIONPAGEHANDLER_H

#include "mbed.h"
#include "DMBoard.h"

#include "USBHostGC.h"

#include "GuiLib.h"

//#define USE_STABILISATION_TIMER // #define'd if we are using our own stabilisation timer - if not, we are getting the time from the GC

#define USE_ENABLE_SET_BUTTON_FLAG // else - enable/disable based on current and previous calibration state

// enum to make the different calibration state values (returned in response to the GC command "QDCS") more explicit
typedef enum enumCalibrationState { IDLE = 0, STAGE_1 = 1, STAGE_1A = 2, STAGE_2 = 3, STAGE_3 = 4, INVALID = -1 } CalibrationState;
    
/*
    This class handles user interaction with the easyGUI "ColumnDHAutoCalibrationPage",
    as well as storing the values in QSPI memory.
    
    Note that this class is a singleton - we do not need or want there to be more than one instance of it
    (we do not want multiple values for the calibration values, etc, and nor will we show 
    more than one easyGUI 'ColumnDHAutoCalibrationPage' to the user at the same time).
*/

class ColumnDHAutoCalibrationPageHandler {
public:
    /**
    * Static method to create (if necessary) and retrieve the single ColumnDHAutoCalibrationPageHandler instance
    */
    static ColumnDHAutoCalibrationPageHandler * GetInstance(USBDeviceConnected* newUsbDevice, USBHostGC* newUsbHostGC);
    
    /**
    * Version of the above that does not create the instance. Provided for callers that do not have 
    * the 'usbDevice' and 'usbHostGC' pointers, and that just want access to the instance
    */
    static ColumnDHAutoCalibrationPageHandler * GetInstance(void);
    
    bool TouchAreaIsOnCalibrationPage(int touchAreaIndex);

    bool DealWithTouch(int touchAreaIndex);
    
    void DisplayingEasyGUIPage(void);

    void UpdateVolatileEasyGUIVariables(void);

    bool CalibratingNow(void);
    
private:    
    static ColumnDHAutoCalibrationPageHandler * theColumnDHAutoCalibrationPageHandlerInstance;
    
    static const char* notAvailable;
    
    USBDeviceConnected* usbDevice;
    USBHostGC* usbHostGC;
    
    // singleton class -> constructor is private
    ColumnDHAutoCalibrationPageHandler(USBDeviceConnected* newUsbDevice, USBHostGC* newUsbHostGC);    
    ~ColumnDHAutoCalibrationPageHandler();
    
    void UpdateEasyGUIPage(void);

    float calibTemperature[3];
    float calibResistance[3];
    int stabilisationTime;
    
    float actualColumnResistance;
    
    void SetEasyGUICalibrationPointTemperatureFromInternalValue(bool updateBoth);
    void SetEasyGUICalibrationPointResistanceFromInternalValue(void);
    void SetEasyGUIStabilisationTimeFromInternalValue(void);
            
    void ConstructStartCalibrationCommand(char* commandBuffer);
    void ConstructStopCalibrationCommand(char* commandBuffer);
    
    void SendCommandToGCAndGetResponse(char* command, char* response);
    bool SendCommandToGCWithDACKResponse(char *cmd);
    
    CalibrationState GetCalibrationState(void);

    void SetEasyGUICalibrationState(void);
    void SetEasyGUIHeatState(void);
    void SetEasyGUIOvenTemperature(void);
    void ShowSetCalibrationButtonEnabledState(void);
    
    void SetEasyGUICalibrationTimeRemaining(void);

    int GetStabilisationTimeFromGC(void);
    bool SetStabilisationTimeInGC(int value);
    
    float GetColumnTemperaturePointFromGC(int pointIndex);
    float GetColumnResistancePointFromGC(int pointIndex);
    
    void SetColumnTemperaturePointInGC(int pointIndex, float temperatureToSet);
    void SetColumnResistancePointInGC(int pointIndex, float resistanceToSet);
    
    bool TellGCToMeasureColumnResistance(void);
    
    float GetActualColumnResistanceFromGC(void);
    
    float GetCurrentOvenTemperature(void);
    
    void DisplayGettingColumnResistancePage(void);
    void RedisplayColumnCalibrationPage();

    CalibrationState currentCalibrationState;
    CalibrationState previousCalibrationState;

    bool needToGetColumnResistance;
    
#ifdef USE_STABILISATION_TIMER
    Timer stabilisationTimer;
#else
    float GetTimeFromGC(void);
    float gcTimeStabilisationStarted;
#endif

#ifdef USE_ENABLE_SET_BUTTON_FLAG 
    bool enableSetButton;
#endif
};

#endif // COLUMNDHAUTOCALIBRATIONPAGEHANDLER_H
