#ifndef QSPIBITMAP_H
#define QSPIBITMAP_H

#include "mbed.h"
#include "DMBoard.h"

#include "GuiLib.h"
#include "GuiDisplay.h"

#include "QSPIFileSystem.h"

class QSPIBitmap
{
public:
    QSPIBitmap();
    
    QSPIBitmap(char* bitmapName);
        
    ~QSPIBitmap();
    
    void ShowAt(GuiConst_INT16S X, GuiConst_INT16S Y, GuiConst_INT32S transparentColour); 
    void ShowAreaAt(GuiConst_INT16S X, GuiConst_INT16S Y, GuiConst_INT16S AX1, GuiConst_INT16S AY1, GuiConst_INT16S AX2, GuiConst_INT16S AY2, GuiConst_INT32S transparentColour); 
    
    bool BitmapLoaded(void) { return bitmapLoaded; }
    
private:
    char name[200];
    
    int size;
    int debugVar1;
    
    GuiConst_INT8U* data;
//    GuiConst_INT8U data[10000];
    
    bool ReadBitmapSizeFile(void);
    bool ReadBitmapDataFile(void);
    bool GetBitmapFromQSPIDrive(void);
    bool bitmapLoaded;
};


class QSPIBitmaps
{
public:
    QSPIBitmaps();
    
    void SetupArray(void);

    void ClearArray(void);

    void DisplayAllHomePageBitmaps(void);

    void DisplayColumnComponentBitmap(void);
    void DisplayDetectorComponentBitmap(void);
    void DisplayInjectorComponentBitmap(void);
    void DisplayGasComponentBitmap(void);
    
    void DisplayBootScreenBitmap(void);
    void DisplayBlankBackgroundBitmap(void);
    
    void DisplayUpArrowBitmap(GuiConst_INT16S X, GuiConst_INT16S Y);
    void DisplayDownArrowBitmap(GuiConst_INT16S X, GuiConst_INT16S Y);
    
    bool AllBitmapsLoaded(void);
    
private:
    bool arraySetUp;
    
    enum QSPIBitmapIndices { HOME_COLUMN_BITMAP = 0,
                             HOME_DETECTOR_BITMAP = 1,
                             HOME_INJECTOR_BITMAP = 2,
                             HOME_GAS_BITMAP = 3,
                             COMPONENT_COLUMN_BITMAP = 4,
                             COMPONENT_DETECTOR_BITMAP = 5,
                             COMPONENT_INJECTOR_BITMAP = 6,
                             COMPONENT_GAS_BITMAP = 7,
                             BOOT_SCREEN_BITMAP = 8,
                             BLANK_BACKGROUND_BITMAP = 9,
                             UP_ARROW_BITMAP = 10,
                             DOWN_ARROW_BITMAP = 11,
                             QSPIBITMAP_COUNT = 12 }; // 'QSPIBITMAP_COUNT' must always be last - it tells the class how large its array should be
    
    QSPIBitmap* qspibmArray[QSPIBITMAP_COUNT];
    
    void DisplayBitmapAtIfLoaded(int bitmapIndex, GuiConst_INT16S X, GuiConst_INT16S Y, GuiConst_INT32S transparentColour);
};

#endif //QSPIBITMAP_H
