#ifndef PROGRESSBAR_H
#define PROGRESSBAR_H

#include "GuiLib.h"
#include "GuiDisplay.h"


typedef enum { vertical, horizontal } progressBarOrientation;

class ProgressBar
{
public:
    ProgressBar();
    ProgressBar(int x, int y, int w, int h, progressBarOrientation o, double newCalibratedRange, GuiConst_INTCOLOR brColor, GuiConst_INTCOLOR bkColor, GuiConst_INTCOLOR brdColor);
    
    progressBarOrientation GetOrientation(void) { return orientation; }
    
    void UpdateCalibratedPosition(double newCalibratedPosition, bool forceFullDisplay);
    
    double GetCalibratedPosition(void) { return (barPosition * calibrationFactor); }
    
    void SetCalibratedRange(double newCalibratedRange);
    double GetCalibratedRange(void) { return calibratedRange; }
    
    void DisplayBarComplete(bool forceFullDisplay);

private:
    int barX, barY; // This is the top left corner, in both orientations.
    int barW, barH; // The width and height.
    // The above apply to the (fixed) box containing the slider bar, not to the bar itself.
    
    GuiConst_INTCOLOR barColor;
    GuiConst_INTCOLOR backColor;
    GuiConst_INTCOLOR borderColor;
    
    progressBarOrientation orientation;
    
    int barPosition; // The RH end of the bar (horizontal), or top of the bar (vertical) - in display units (i.e. pixels)
                     // ** relative to the bottom (vertical) or left hand end (horizontal) of the bar as zero **
    int previousBarPositionDisplayed; // -1 if we have not yet displayed the bar
    
    double calibratedRange;
    double calibrationFactor; // calibratedPosition = (barPosition * calibrationFactor),
                              // which is equivalent to: calibrationFactor = (calibratedRange / barW)
    
    void DisplayNewPosition(void);
    
    void DisplayFullBar(void);
    void DisplayBarChangeOnly(void);
    
    // If this is false, we do not fill the background (at all) when we (re)draw the bar.
    // This is an advantage when we are using a bitmap as the background - 
    // we do not have to redraw parts of the bitmap.
    // *** This is OK as long as the bar always increases in length (which it should do,       ***
    // *** for a progress bar, unless the process we are representing somehow goes backwards). ***
    bool fillBackground;
};

#endif // PROGRESSBAR_H
