#ifndef GCREALTIMECLOCK_H
#define GCREALTIMECLOCK_H

#include "mbed.h"
#include "DMBoard.h"

#include "USBHostGC.h"

/*
    This class contains functions that deal with the real time clock [RTC] 
    in the GC. All the functions are static, and this class cannot be instantiated.
*/

class GCRealTimeClock {
public: 
    static bool GetGCClockTime(USBDeviceConnected* usbDevice, USBHostGC* usbHostGC, time_t *clockTime);
    static bool SetLPC4088RealTimeClockToMatchGC(USBDeviceConnected* usbDevice, USBHostGC* usbHostGC);

private:
    // Private constructor - so this class cannot be instantiated
    GCRealTimeClock();
    
    static bool GetTimeFieldsFromGC(USBDeviceConnected* usbDevice, 
                                    USBHostGC* usbHostGC, 
                                    char *gcSecondsResponse, 
                                    char *gcMinutesResponse, 
                                    char *gcHoursResponse, 
                                    char *gcDateResponse, 
                                    char *gcMonthResponse, 
                                    char *gcYearResponse);
                                    
    static void MakeTimeValueFromGCTimeFields(struct tm *timeValue,
                                              char *gcSecondsResponse, 
                                              char *gcMinutesResponse, 
                                              char *gcHoursResponse, 
                                              char *gcDateResponse, 
                                              char *gcMonthResponse, 
                                              char *gcYearResponse);

};

#endif // GCREALTIMECLOCK_H
