#ifndef ETHERNETKEYPADHANDLER_H
#define ETHERNETKEYPADHANDLER_H

#include "mbed.h"
#include "DMBoard.h"

#include "USBHostGC.h"

#include "GuiLib.h"

typedef struct structActiveOctetOutline { unsigned int X1; unsigned int Y1; unsigned int X2; unsigned int Y2; } ActiveOctetOutline;

/*
    This class handles user interaction with the easyGUI "EthernetKeypadPage".
    
    Note that this class is a singleton - we do not need or want there to be more than one instance of it
    (we will not show more than one "EthernetKeypadPage" to the user at the same time).
*/
class EthernetKeypadPageHandler {
public:
    /**
    * Static method to create (if necessary) and retrieve the single EthernetKeypadPageHandler instance
    */
    static EthernetKeypadPageHandler * GetInstance(USBDeviceConnected* newUsbDevice, USBHostGC* newUsbHostGC);
    
    bool TouchAreaIsOnEthernetKeypadPage(int touchAreaIndex);

    bool DealWithTouch(int touchAreaIndex);
    
    // Three member functions for the caller to tell us what we are editing.
    // All three of these must be called, and StartEditing must be last
    void SetEasyGUIOctetVariablesToEdit(GuiConst_TEXT* easyGUIOctet1, GuiConst_TEXT* easyGUIOctet2, GuiConst_TEXT* easyGUIOctet3, GuiConst_TEXT* easyGUIOctet4);
    void SetInternalOctetVariablesToEdit(unsigned int *internalOctet1, unsigned int *internalOctet2, unsigned int *internalOctet3, unsigned int *internalOctet4);
    void StartEditing(char *title);

private:
    static EthernetKeypadPageHandler * theEthernetKeypadPageHandlerInstance;
    
    static const int minimumOctetValue;
    static const int maximumOctetValue;
    
    static const GuiConst_INTCOLOR inactiveOctetBackgroundColour;
    static const GuiConst_INTCOLOR activeOctetBackgroundColour;

    GuiConst_TEXT *callerEasyGUIOctetPtr[4];
    unsigned int *callerInternalOctetPtr[4];
    
    ActiveOctetOutline activeOctetOutline[4];
    
    int indexOfOctetBeingEdited;
    unsigned int currentOctetValues[4];
    GuiConst_TEXT *easyGUIOctetValues[4];
    GuiConst_INTCOLOR *easyGUIOctetBackgroundColourVariables[4];

    // singleton class -> constructor is private
    EthernetKeypadPageHandler(USBDeviceConnected* newUsbDevice, USBHostGC* newUsbHostGC);
    ~EthernetKeypadPageHandler();

    USBDeviceConnected* usbDevice;
    USBHostGC* usbHostGC;
    
    void DealWithDeleteKey(void);

    void DealWithNumberKey(int touchAreaIndex);
    
    void DealWithApplyKey(void);
    
    void DealWithCancelKey(void);
    
    void DealWithClearKey(void);
    
    void DealWithDotKey(void);
    
    void UpdateEasyGUIPage(void);

    void UpdateEasyGUIOctetValues(void);
    
    void UpdateEasyGUIBackgroundsForCurrentOctetSelection(void);
    
    void DrawOutlineAroundActiveOctet(void);
    
    int easyGUICallingPage;
};

#endif // ETHERNETKEYPADHANDLER_H
