#ifndef EASYGUITOUCHAREAINDICES_H
#define EASYGUITOUCHAREAINDICES_H

/*
    Enum values for all the touch areas we have defined in the corresponding easyGUI project - C:/easyGUI Projects/GC500_5inch.gui
    
    Centrally defined here to try and make sure there are no conflicts - 
    i.e. we that we are not mistakenly using the same value for two (or more) different touch areas.
    Note, however, that C++ does not stop you having two or more enum entries with the same numerical value - 
    we have to check this manually - but at least having them all here in one enum should make this easier.
    
    It also helps that using an enum name instead of a literal number makes the code
    more descriptive and easier to understand.
    
    Note also that if we change or add more touch areas in the easyGUI project,
    this enum will have to be updated manually - we cannot (AFAIK) get these values
    from the easyGUI code at runtime.
*/

typedef enum enumEasyGUITouchAreaIndex {   HOME_BUTTON = 1,
                                           SETTINGS_BUTTON = 2,
                                           INJECTOR_TOUCH_AREA_1 = 3,
                                           DETECTOR_TOUCH_AREA_1 = 4,
                                           COLUMN_TOUCH_AREA_1 = 5,
                                           GAS_TOUCH_AREA_1 = 6,
                                           INJECTOR_TOUCH_AREA_2 = 7,
                                           DETECTOR_TOUCH_AREA_2 = 8,
                                           COLUMN_TOUCH_AREA_2 = 9,
                                           GAS_TOUCH_AREA_2 = 10,
                                           DOOR_ACTUATOR_AREA_1 = 51,
                                           DOOR_ACTUATOR_AREA_2 = 52,
                                           
                                           RUN_BUTTON = 100,
                                           
                                           HEAT_ON_BUTTON = 1000,
                                           
                                           ABORT_RUN_YES = 801,
                                           ABORT_RUN_NO = 802,
                                           
                                           COLUMN_PAGE1_LEFT_ARROW = 500,
                                           COLUMN_PAGE1_RIGHT_ARROW = 501,
                                           COLUMN_PAGE2_LEFT_ARROW = 502,
                                           COLUMN_PAGE2_RIGHT_ARROW = 503,
                                           COLUMN_PROFILE_LEFT_ARROW = 504,
                                           COLUMN_PROFILE_RIGHT_ARROW = 505,
                                           COLUMN_METHOD_LEFT_ARROW = 506,
                                           COLUMN_METHOD_RIGHT_ARROW = 507,
                                           COLUMN_METHOD_SCROLL_UP = 508,
                                           COLUMN_METHOD_SCROLL_DOWN = 509,

                                           COLUMN_PAGE1_EDIT_COLUMN_MAX_TEMP = 513,
                                           COLUMN_DH_PAGE1_EDIT_COLUMN_MAX_TEMP = 514,
                                           COLUMN_PAGE2_EDIT_COLUMN_MAX_TEMP = 515,
                                           
                                           COLUMN_DH_PAGE1_LEFT_ARROW = 550,
                                           COLUMN_DH_PAGE1_RIGHT_ARROW = 551,
                                           COLUMN_DH_PAGE2_LEFT_ARROW = 552,
                                           COLUMN_DH_PAGE2_RIGHT_ARROW = 553,
                                           COLUMN_DH_PROFILE_LEFT_ARROW = 554,
                                           COLUMN_DH_PROFILE_RIGHT_ARROW = 555,
                                           COLUMN_DH_CALIB_LEFT_ARROW = 556,
                                           COLUMN_DH_CALIB_RIGHT_ARROW = 557,
                                           
                                           COLUMN_DH_AUTO_CALIB_LEFT_ARROW = 566,
                                           COLUMN_DH_AUTO_CALIB_RIGHT_ARROW = 567,
                                           COLUMN_DH_AUTO_CALIB_INC_CALIB_TEMP = 568,
                                           COLUMN_DH_AUTO_CALIB_DEC_CALIB_TEMP = 569,
                                           COLUMN_DH_AUTO_CALIB_START_CALIBRATION = 570,
                                           COLUMN_DH_AUTO_CALIB_INC_STABILISATION_TIME = 571,
                                           COLUMN_DH_AUTO_CALIB_DEC_STABILISATION_TIME = 572,
                                           COLUMN_DH_AUTO_CALIB_GET_STABILISATION_TIME = 573,
                                           COLUMN_DH_AUTO_CALIB_SET_STABILISATION_TIME = 574,
                                           COLUMN_DH_AUTO_CALIB_SELECT_POINT_1 = 575,
                                           COLUMN_DH_AUTO_CALIB_SELECT_POINT_2 = 576,
                                           COLUMN_DH_AUTO_CALIB_SELECT_POINT_3 = 577,
                                           COLUMN_DH_AUTO_CALIB_SET_CURRENT_CALIBRATION = 578,
                                           MIN_COLUMN_DH_AUTO_CALIB_TOUCHINDEX = COLUMN_DH_AUTO_CALIB_LEFT_ARROW,              // These must be kept up-to-date with the above (and they must have no 
                                           MAX_COLUMN_DH_AUTO_CALIB_TOUCHINDEX = COLUMN_DH_AUTO_CALIB_SET_CURRENT_CALIBRATION, // non-directly heated column auto calibration parameters inserted between them)
                                           
                                           COLUMN_DH_MANUAL_CALIB_LEFT_ARROW = 580,
                                           COLUMN_DH_MANUAL_CALIB_RIGHT_ARROW = 581,
                                           COLUMN_DH_MANUAL_CALIB_SET = 582,
                                           COLUMN_DH_MANUAL_CALIB_GET = 583,
                                           COLUMN_DH_MANUAL_CALIB_EDIT_TEMP1 = 584,
                                           COLUMN_DH_MANUAL_CALIB_EDIT_TEMP2 = 585,
                                           COLUMN_DH_MANUAL_CALIB_EDIT_TEMP3 = 586,
                                           COLUMN_DH_MANUAL_CALIB_EDIT_RES1 = 587,
                                           COLUMN_DH_MANUAL_CALIB_EDIT_RES2 = 588,
                                           COLUMN_DH_MANUAL_CALIB_EDIT_RES3 = 589,
                                           MIN_COLUMN_DH_MANUAL_CALIB_TOUCHINDEX = COLUMN_DH_MANUAL_CALIB_SET,       // These must be kept up-to-date with the above (and they must have no 
                                           MAX_COLUMN_DH_MANUAL_CALIB_TOUCHINDEX = COLUMN_DH_MANUAL_CALIB_EDIT_RES3,  // non-directly heated column manual calibration parameters inserted between them)
                                           
                                           COLUMN_DH_SENSOR_CALIB_LEFT_ARROW = 610,
                                           COLUMN_DH_SENSOR_CALIB_RIGHT_ARROW = 611,
                                           COLUMN_DH_SENSOR_CALIB_SET = 612,
                                           COLUMN_DH_SENSOR_CALIB_GET = 613,
                                           COLUMN_DH_SENSOR_CALIB_EDIT_VOLTAGE_GAIN = 614,
                                           COLUMN_DH_SENSOR_CALIB_EDIT_VOLTAGE_OFFSET = 615,
                                           COLUMN_DH_SENSOR_CALIB_EDIT_CURRENT_GAIN = 616,
                                           COLUMN_DH_SENSOR_CALIB_EDIT_CURRENT_OFFSET = 617,
                                           MIN_COLUMN_DH_SENSOR_CALIB_TOUCHINDEX = COLUMN_DH_SENSOR_CALIB_SET,                 // These must be kept up-to-date with the above (and they must have no 
                                           MAX_COLUMN_DH_SENSOR_CALIB_TOUCHINDEX = COLUMN_DH_SENSOR_CALIB_EDIT_CURRENT_OFFSET, // non-directly heated column sensor calibration parameters inserted between them)
                                           
                                           COLUMN_DH_PSU_DAC_LEFT_ARROW = 630,
                                           COLUMN_DH_PSU_DAC_RIGHT_ARROW = 631,
                                           COLUMN_DH_PSU_DAC_EDIT_DAC_VALUE = 632,
                                           COLUMN_DH_PSU_DAC_SET_DAC_VALUE = 633,
                                           COLUMN_DH_PSU_DAC_GET_DAC_VALUE = 634,
                                           MIN_COLUMN_DH_PSU_DAC_TOUCHINDEX = COLUMN_DH_PSU_DAC_EDIT_DAC_VALUE,  // These must be kept up-to-date with the above (and they must have no 
                                           MAX_COLUMN_DH_PSU_DAC_TOUCHINDEX = COLUMN_DH_PSU_DAC_GET_DAC_VALUE,   // non-directly heated column PSU DAC parameters inserted between them)

                                           COLUMN_OVEN_FAN_LEFT_ARROW = 640,
                                           COLUMN_OVEN_FAN_RIGHT_ARROW = 641,
                                           COLUMN_OVEN_FAN_NORMAL = 642,
                                           COLUMN_OVEN_FAN_COOLING = 643,

                                           COLUMN_OVEN_NUDGE_AND_DAMP_LEFT_ARROW = 650,
                                           COLUMN_OVEN_NUDGE_AND_DAMP_RIGHT_ARROW = 651,
                                           COLUMN_OVEN_NUDGE_AND_DAMP_SET = 652,
                                           COLUMN_OVEN_NUDGE_AND_DAMP_GET = 653,
                                           COLUMN_OVEN_NUDGE_FACTOR_EDIT = 654,
                                           COLUMN_OVEN_DAMP_FACTOR_EDIT = 655,
                                           COLUMN_OVEN_RAMP_NUDGE_FACTOR_EDIT = 656,
                                           COLUMN_OVEN_RAMP_DAMP_FACTOR_EDIT = 657,
                                           COLUMN_OVEN_TEMP_OFFSET_EDIT = 658,
                                           MIN_COLUMN_OVEN_NUDGE_AND_DAMP_TOUCHINDEX = COLUMN_OVEN_NUDGE_AND_DAMP_SET,  // These must be kept up-to-date with the above (and they must have no 
                                           MAX_COLUMN_OVEN_NUDGE_AND_DAMP_TOUCHINDEX = COLUMN_OVEN_TEMP_OFFSET_EDIT,    // non-column oven nudge and damp parameters inserted between them)

                                           COLUMN_DH_NUDGE_AND_DAMP_LEFT_ARROW = 660,
                                           COLUMN_DH_NUDGE_AND_DAMP_RIGHT_ARROW = 661,
                                           COLUMN_DH_NUDGE_AND_DAMP_SET = 662,
                                           COLUMN_DH_NUDGE_AND_DAMP_GET = 663,
                                           COLUMN_DH_NUDGE_FACTOR_EDIT = 664,
                                           COLUMN_DH_DAMP_FACTOR_EDIT = 665,
                                           COLUMN_DH_RAMP_NUDGE_FACTOR_EDIT = 666,
                                           COLUMN_DH_RAMP_DAMP_FACTOR_EDIT = 667,
                                           MIN_COLUMN_DH_NUDGE_AND_DAMP_TOUCHINDEX = COLUMN_DH_NUDGE_AND_DAMP_SET,     // These must be kept up-to-date with the above (and they must have no 
                                           MAX_COLUMN_DH_NUDGE_AND_DAMP_TOUCHINDEX = COLUMN_DH_RAMP_DAMP_FACTOR_EDIT,  // non-directly heated column nudge and damp parameters inserted between them)

                                           FAN_POWER_LEFT_ARROW = 670,
                                           FAN_POWER_RIGHT_ARROW = 671,
                                           FAN_POWER_SET = 672,
                                           FAN_POWER_GET = 673,
                                           FAN_POWER_NORMAL_EDIT = 674,
                                           FAN_POWER_COOLING_EDIT = 675,
                                           FAN_POWER_DH_CALIB_EDIT = 676,
                                           FAN_POWER_MINIMUM_EDIT = 677,
                                           MIN_FAN_POWER_TOUCHINDEX = FAN_POWER_SET,            // These must be kept up-to-date with the above (and they must have no 
                                           MAX_FAN_POWER_TOUCHINDEX = FAN_POWER_MINIMUM_EDIT ,  // non-fan power parameters inserted between them)


                                           CLEAR_ERRORS_BUTTON = 600,

                                           GAS_PROFILE_LEFT_ARROW = 300,
                                           GAS_PROFILE_RIGHT_ARROW = 301,
                                           GAS_INFO_LEFT_ARROW = 302,
                                           GAS_INFO_RIGHT_ARROW = 303,
                                           GAS_CALIB_LEFT_ARROW = 304,
                                           GAS_CALIB_RIGHT_ARROW = 305,
                                           GAS_BACKPRESSURE_DAC_LEFT_ARROW = 306,
                                           GAS_BACKPRESSURE_DAC_RIGHT_ARROW = 307,
                                           GAS_CHANNEL_DAC_AND_ADC_LEFT_ARROW = 308,
                                           GAS_CHANNEL_DAC_AND_ADC_RIGHT_ARROW = 309,
                                           GAS_METHOD_LEFT_ARROW = 310,
                                           GAS_METHOD_RIGHT_ARROW = 311,
                                           GAS_METHOD_SCROLL_UP = 312,
                                           GAS_METHOD_SCROLL_DOWN = 313,
                                           
                                           GAS_SAVER_RETURN_TO_READY = 400,

                                           INJECTOR_PAGE1_LEFT_ARROW = 700,
                                           INJECTOR_PAGE1_RIGHT_ARROW = 701,
                                           INJECTOR_PROFILE_LEFT_ARROW = 702,
                                           INJECTOR_PROFILE_RIGHT_ARROW = 703,
                                           INJECTOR_METHOD_LEFT_ARROW = 704,
                                           INJECTOR_METHOD_RIGHT_ARROW = 705,
                                           INJECTOR_METHOD_SCROLL_UP = 708,
                                           INJECTOR_METHOD_SCROLL_DOWN = 709,

                                           INJECTOR_NUDGE_AND_DAMP_LEFT_ARROW = 710,
                                           INJECTOR_NUDGE_AND_DAMP_RIGHT_ARROW = 711,
                                           INJECTOR_NUDGE_AND_DAMP_SET = 712,
                                           INJECTOR_NUDGE_AND_DAMP_GET = 713,
                                           INJECTOR_NUDGE_FACTOR_EDIT = 714,
                                           INJECTOR_DAMP_FACTOR_EDIT = 715,
                                           MIN_INJECTOR_NUDGE_AND_DAMP_TOUCHINDEX = INJECTOR_NUDGE_AND_DAMP_SET,  // These must be kept up-to-date with the above (and they must have no 
                                           MAX_INJECTOR_NUDGE_AND_DAMP_TOUCHINDEX = INJECTOR_DAMP_FACTOR_EDIT ,   // non-injector nudge and damp parameters inserted between them)

                                           DETECTOR_NUDGE_AND_DAMP_LEFT_ARROW = 810,
                                           DETECTOR_NUDGE_AND_DAMP_RIGHT_ARROW = 811,
                                           DETECTOR_NUDGE_AND_DAMP_SET = 812,
                                           DETECTOR_NUDGE_AND_DAMP_GET = 813,
                                           DETECTOR_NUDGE_FACTOR_EDIT = 814,
                                           DETECTOR_DAMP_FACTOR_EDIT = 815,
                                           MIN_DETECTOR_NUDGE_AND_DAMP_TOUCHINDEX = DETECTOR_NUDGE_AND_DAMP_SET,  // These must be kept up-to-date with the above (and they must have no 
                                           MAX_DETECTOR_NUDGE_AND_DAMP_TOUCHINDEX = DETECTOR_DAMP_FACTOR_EDIT ,   // non-detector nudge and damp parameters inserted between them)

                                           AUXILIARY_NUDGE_AND_DAMP_LEFT_ARROW = 950,
                                           AUXILIARY_NUDGE_AND_DAMP_RIGHT_ARROW = 951,
                                           AUXILIARY_NUDGE_AND_DAMP_SET = 952,
                                           AUXILIARY_NUDGE_AND_DAMP_GET = 953,
                                           AUXILIARY_NUDGE_FACTOR_EDIT = 954,
                                           AUXILIARY_DAMP_FACTOR_EDIT = 955,
                                           MIN_AUXILIARY_NUDGE_AND_DAMP_TOUCHINDEX = AUXILIARY_NUDGE_AND_DAMP_SET,  // These must be kept up-to-date with the above (and they must have no 
                                           MAX_AUXILIARY_NUDGE_AND_DAMP_TOUCHINDEX = AUXILIARY_DAMP_FACTOR_EDIT ,   // non-auxiliary nudge and damp parameters inserted between them)

                                           DEBUG_COMMANDS_SEND = 9000,
                                           DEBUG_COMMANDS_DELETE = 9001,
                                           DEBUG_COMMANDS_CLEAR = 9002,
                                           DEBUG_COMMANDS_0 = 9010, // The character key IDs *must* be consecutive
                                           DEBUG_COMMANDS_1 = 9011,
                                           DEBUG_COMMANDS_2 = 9012,
                                           DEBUG_COMMANDS_3 = 9013,
                                           DEBUG_COMMANDS_4 = 9014,
                                           DEBUG_COMMANDS_5 = 9015,
                                           DEBUG_COMMANDS_6 = 9016,
                                           DEBUG_COMMANDS_7 = 9017,
                                           DEBUG_COMMANDS_8 = 9018,
                                           DEBUG_COMMANDS_9 = 9019,
                                           DEBUG_COMMANDS_A = 9020, // Note - alphabetical order from here on, 
                                           DEBUG_COMMANDS_B = 9021, // *not* QWERTY keyboard order
                                           DEBUG_COMMANDS_C = 9022,
                                           DEBUG_COMMANDS_D = 9023,
                                           DEBUG_COMMANDS_E = 9024,
                                           DEBUG_COMMANDS_F = 9025,
                                           DEBUG_COMMANDS_G = 9026,
                                           DEBUG_COMMANDS_H = 9027,
                                           DEBUG_COMMANDS_I = 9028,
                                           DEBUG_COMMANDS_J = 9029,
                                           DEBUG_COMMANDS_K = 9030,
                                           DEBUG_COMMANDS_L = 9031,
                                           DEBUG_COMMANDS_M = 9032,
                                           DEBUG_COMMANDS_N = 9033,
                                           DEBUG_COMMANDS_O = 9034,
                                           DEBUG_COMMANDS_P = 9035,
                                           DEBUG_COMMANDS_Q = 9036,
                                           DEBUG_COMMANDS_R = 9037,
                                           DEBUG_COMMANDS_S = 9038,
                                           DEBUG_COMMANDS_T = 9039,
                                           DEBUG_COMMANDS_U = 9040,
                                           DEBUG_COMMANDS_V = 9041,
                                           DEBUG_COMMANDS_W = 9042,
                                           DEBUG_COMMANDS_X = 9043,
                                           DEBUG_COMMANDS_Y = 9044,
                                           DEBUG_COMMANDS_Z = 9045,
                                           MIN_DEBUG_COMMANDS_TOUCHINDEX = DEBUG_COMMANDS_SEND,  // These must be kept up-to-date with the above (and they must have no 
                                           MAX_DEBUG_COMMANDS_TOUCHINDEX = DEBUG_COMMANDS_Z,     // non debug commands touch indices inserted between them)
                                           MIN_DEBUG_COMMANDS_CHAR = DEBUG_COMMANDS_0,
                                           MAX_DEBUG_COMMANDS_CHAR = DEBUG_COMMANDS_Z,


                                           RUNNING_PAGE1_ABORT_RUN = 250,
                                           RUNNING_PAGE1_LEFT_ARROW = 900,
                                           RUNNING_PAGE1_RIGHT_ARROW = 901,
                                           RUNNING_COLUMN_ABORT_RUN = 251,
                                           RUNNING_COLUMN_LEFT_ARROW = 902,
                                           RUNNING_COLUMN_RIGHT_ARROW = 903,
                                           RUNNING_INJECTOR_ABORT_RUN = 252,
                                           RUNNING_INJECTOR_LEFT_ARROW = 904,
                                           RUNNING_INJECTOR_RIGHT_ARROW = 905,
                                           RUNNING_DETECTOR_ABORT_RUN = 253,
                                           RUNNING_DETECTOR_LEFT_ARROW = 906,
                                           RUNNING_DETECTOR_RIGHT_ARROW = 907,
                                           RUNNING_GAS_ABORT_RUN = 254,
                                           RUNNING_GAS_LEFT_ARROW = 908,
                                           RUNNING_GAS_RIGHT_ARROW = 909,
                                           RUNNING_INJECTOR_PROFILE_ABORT_RUN = 255,
                                           RUNNING_INJECTOR_PROFILE_LEFT_ARROW = 910,
                                           RUNNING_INJECTOR_PROFILE_RIGHT_ARROW = 911,
                                           
                                           DETECTOR_IGNITE_BUTTON = 2000,
                                           
                                           NETWORK_PARAMS_APPLY_BUTTON  = 3011,
                                           NETWORK_PARAMS_CANCEL_BUTTON = 3012,
                                           NETWORK_PARAMS_DHCP_BUTTON   = 3013,

                                           NETWORK_PARAMS_PORT_VALUE = 3020,

                                           NETWORK_PARAMS_PORT_EDIT = 3024,

                                           NETWORK_PARAMS_IP1_VALUE = 3030,
                                           NETWORK_PARAMS_IP2_VALUE = 3031,
                                           NETWORK_PARAMS_IP3_VALUE = 3032,
                                           NETWORK_PARAMS_IP4_VALUE = 3033,
                                           
                                           NETWORK_PARAMS_IP_EDIT = 3034,

                                           NETWORK_PARAMS_MASK1_VALUE = 3040,
                                           NETWORK_PARAMS_MASK2_VALUE = 3041,
                                           NETWORK_PARAMS_MASK3_VALUE = 3042,
                                           NETWORK_PARAMS_MASK4_VALUE = 3043,
                                           
                                           NETWORK_PARAMS_MASK_EDIT = 3044,

                                           NETWORK_PARAMS_GATEWAY1_VALUE = 3050,
                                           NETWORK_PARAMS_GATEWAY2_VALUE = 3051,
                                           NETWORK_PARAMS_GATEWAY3_VALUE = 3052,
                                           NETWORK_PARAMS_GATEWAY4_VALUE = 3053,
                                           
                                           NETWORK_PARAMS_GATEWAY_EDIT = 3054,
                                           
                                           MIN_NETWORK_PARAM = NETWORK_PARAMS_APPLY_BUTTON,  // These must be kept up-to-date with the above
                                           MAX_NETWORK_PARAM = NETWORK_PARAMS_GATEWAY_EDIT,  // (and they must have no non-network parameters inserted between them)

                                           SETTINGS_TO_NETWORK_PARAMS_BUTTON = 2003,
                                           NETWORK_PARAMS_RETURN_BUTTON = 2004,
                                           
                                           SETTINGS_TO_SERVICING_PAGE_BUTTON = 4003,
                                           SERVICING_PAGE_RETURN_BUTTON = 4004,
                                           SERVICING_REQUIRED_PAGE_HOME_BUTTON = 4005,
                                           COMPONENT_1_SERVICED = 4006,
                                           COMPONENT_2_SERVICED = 4007,
                                           COMPONENT_3_SERVICED = 4008,
                                           COMPONENT_4_SERVICED = 4009,
                                           COMPONENT_5_SERVICED = 4010,
                                           COMPONENT_6_SERVICED = 4011,
                                           SERVICING_PAGE_GC_CMDS_BUTTON = 4012,
                                           

                                           GAS_CALIB_APPLY_BUTTON = 5011,
                                           GAS_CALIB_CANCEL_BUTTON = 5012,

                                           GAS_CALIB_HELIUM = 5020,  
                                           GAS_CALIB_HYDROGEN = 5021,
                                           GAS_CALIB_NITROGEN = 5022,
                                           
                                           GAS_CALIB_DAC_1_VALUE_EDIT = 5030,
                                           GAS_CALIB_FLOW_1_VALUE_EDIT = 5031,
                                           GAS_CALIB_DAC_2_VALUE_EDIT = 5032,
                                           GAS_CALIB_FLOW_2_VALUE_EDIT = 5033,
                                           GAS_CALIB_DAC_3_VALUE_EDIT = 5034,
                                           GAS_CALIB_FLOW_3_VALUE_EDIT = 5035,
                                           GAS_CALIB_DAC_4_VALUE_EDIT = 5036,
                                           GAS_CALIB_FLOW_4_VALUE_EDIT = 5037,
                                           GAS_CALIB_DAC_5_VALUE_EDIT = 5038,
                                           GAS_CALIB_FLOW_5_VALUE_EDIT = 5039,
                                           GAS_CALIB_DAC_6_VALUE_EDIT = 5040,
                                           GAS_CALIB_FLOW_6_VALUE_EDIT = 5041,
                                           
                                           MIN_GAS_CALIB_TOUCHINDEX = GAS_CALIB_APPLY_BUTTON,      // These must be kept up-to-date with the above
                                           MAX_GAS_CALIB_TOUCHINDEX = GAS_CALIB_FLOW_6_VALUE_EDIT, // (and they must have no non-gas calibration parameters inserted between them)


                                           GAS_BACKPRESSURE_DAC_GAIN_EDIT   = 6011,
                                           GAS_BACKPRESSURE_DAC_OFFSET_EDIT = 6012,

                                           GAS_BACKPRESSURE_DAC_SET = 6013,
                                           GAS_BACKPRESSURE_DAC_GET = 6014,

                                           MIN_GAS_BACKPRESSURE_DAC_TOUCHINDEX = GAS_BACKPRESSURE_DAC_GAIN_EDIT,  // These must be kept up-to-date with the above
                                           MAX_GAS_BACKPRESSURE_DAC_TOUCHINDEX = GAS_BACKPRESSURE_DAC_GET,        // (and they must have no non-gas backpressure DAC parameters inserted between them)


                                           GAS_CHANNEL_DAC_AND_ADC_SET_DAC_VALUE_BUTTON = 7013,
                                           GAS_CHANNEL_DAC_AND_ADC_GET_ADC_VALUE_BUTTON = 7014,
                                           
                                           GAS_CHANNEL_DAC_AND_ADC_DAC_VALUE_EDIT = 7015,

                                           GAS_CHANNEL_DAC_AND_ADC_TOTALFLOW = 7020,  
                                           GAS_CHANNEL_DAC_AND_ADC_BACKPRESSURE = 7021,
                                           GAS_CHANNEL_DAC_AND_ADC_FUEL = 7022,
                                           GAS_CHANNEL_DAC_AND_ADC_AIR = 7023,
                                           
                                           MIN_GAS_CHANNEL_DAC_AND_ADC_TOUCHINDEX = GAS_CHANNEL_DAC_AND_ADC_SET_DAC_VALUE_BUTTON,     // These must be kept up-to-date with the above
                                           MAX_GAS_CHANNEL_DAC_AND_ADC_TOUCHINDEX = GAS_CHANNEL_DAC_AND_ADC_AIR, // (and they must have no non-gas channel DAC parameters inserted between them)
                                           
                                           ENTER_ENGINEERS_LOCK_CODE = 8000,
                                           
                                           SERVICING_HOME = 8001,
                                           
                                           INJECTOR_SERVICING_AREA = 8010,
                                           DETECTOR_SERVICING_AREA = 8011,
                                           COLUMN_SERVICING_AREA = 8012,
                                           GAS_SERVICING_AREA = 8013,


                                           NUMERIC_KEYPAD_BUTTON_0 = 10000, // These *must* be in this order,
                                           NUMERIC_KEYPAD_BUTTON_1 = 10001, // and *must* be consecutive - 
                                           NUMERIC_KEYPAD_BUTTON_2 = 10002, // NumericKeypadPageHandler class 
                                           NUMERIC_KEYPAD_BUTTON_3 = 10003, // relies on this
                                           NUMERIC_KEYPAD_BUTTON_4 = 10004, // ...
                                           NUMERIC_KEYPAD_BUTTON_5 = 10005, // ...
                                           NUMERIC_KEYPAD_BUTTON_6 = 10006, // ...
                                           NUMERIC_KEYPAD_BUTTON_7 = 10007, // ...
                                           NUMERIC_KEYPAD_BUTTON_8 = 10008, // ...
                                           NUMERIC_KEYPAD_BUTTON_9 = 10009, // ...
                                           
                                           NUMERIC_KEYPAD_DELETE_BUTTON = 10010,
                                           
                                           NUMERIC_KEYPAD_APPLY_BUTTON  = 10011,
                                           NUMERIC_KEYPAD_CANCEL_BUTTON = 10012,
                                           
                                           NUMERIC_KEYPAD_CLEAR_BUTTON = 10013,

                                           NUMERIC_KEYPAD_DOT_BUTTON = 10014,
                                           NUMERIC_KEYPAD_PLUS_MINUS_BUTTON = 10015,

                                           MIN_NUMERIC_KEYPAD_TOUCHINDEX = NUMERIC_KEYPAD_BUTTON_0,          // These must be kept up-to-date with the above
                                           MAX_NUMERIC_KEYPAD_TOUCHINDEX = NUMERIC_KEYPAD_PLUS_MINUS_BUTTON, // (and they must have no non-numeric keypad parameters inserted between them)


                                           ETHERNET_KEYPAD_BUTTON_0 = 20000, // These *must* be in this order,
                                           ETHERNET_KEYPAD_BUTTON_1 = 20001, // and *must* be consecutive - 
                                           ETHERNET_KEYPAD_BUTTON_2 = 20002, // EthernetKeypadPageHandler class 
                                           ETHERNET_KEYPAD_BUTTON_3 = 20003, // relies on this
                                           ETHERNET_KEYPAD_BUTTON_4 = 20004, // ...
                                           ETHERNET_KEYPAD_BUTTON_5 = 20005, // ...
                                           ETHERNET_KEYPAD_BUTTON_6 = 20006, // ...
                                           ETHERNET_KEYPAD_BUTTON_7 = 20007, // ...
                                           ETHERNET_KEYPAD_BUTTON_8 = 20008, // ...
                                           ETHERNET_KEYPAD_BUTTON_9 = 20009, // ...
                                           
                                           ETHERNET_KEYPAD_DELETE_BUTTON = 20010,
                                           
                                           ETHERNET_KEYPAD_APPLY_BUTTON  = 20011,
                                           ETHERNET_KEYPAD_CANCEL_BUTTON = 20012,
                                           
                                           ETHERNET_KEYPAD_CLEAR_BUTTON = 20013,

                                           ETHERNET_KEYPAD_DOT_BUTTON = 20014,

                                           MIN_ETHERNET_KEYPAD_TOUCHINDEX = ETHERNET_KEYPAD_BUTTON_0,     // These must be kept up-to-date with the above
                                           MAX_ETHERNET_KEYPAD_TOUCHINDEX = ETHERNET_KEYPAD_DOT_BUTTON, // (and they must have no non-Ethernet keypad parameters inserted between them)

                                         } EasyGUITouchAreaIndex;

#endif // EASYGUITOUCHAREAINDICES_H