#ifndef USBHOSTGCUTILITIES_H
#define USBHOSTGCUTILITIES_H

#include "mbed.h"
#include "DMBoard.h"

#include "USBHostGC.h"

/*
    This is a class containing utility functions for use when talking to the GC over the USB link.
    To avoid having the same functions duplicated in several classes.
    
    For simplicity, all functions are static.
*/

class USBHostGCUtilities {
public:
    static void SendCommandToGCAndGetResponse(USBDeviceConnected* usbDevice, USBHostGC* usbHostGC, char* command, char* response);
    static bool SendCommandToGCWithDACKResponse(USBDeviceConnected* usbDevice, USBHostGC* usbHostGC, char *cmd);

private:
    // Private constructor - so this class cannot be instantiated
    USBHostGCUtilities();

};

#endif // USBHOSTGCUTILITIES_H
