
#include "USBHostGCUtilities.h"

/*
    As described in the header file, this is a class containing utility functions for communicating with the GC,
    to try and reduce the amount of similar code duplicated between classes.
    
    All functions are static.
*/

/*
    As the name implies, sends a command to the GC and returns the response.
    
    Args: pointer to a USBDeviceConnected instance
          pointer to a USBHostGC instance
          pointer to a buffer containing the command, as a null-terminated string
          pointer to a buffer to contain the response, as a null-terminated string
          
    No return code (it is up to the caller to examine the response to see whether 
    the command succeeded or failed)
*/
void USBHostGCUtilities::SendCommandToGCAndGetResponse(USBDeviceConnected* usbDevice, USBHostGC* usbHostGC, char* command, char* response)
{
    while(usbHostGC->ExecutingSetDeviceReport()) {}

    usbHostGC->SetDeviceReport(usbDevice, command, response);
//#define DEBUG_PRINT_HERE
#ifdef DEBUG_PRINT_HERE
    char dbg[100];
    sprintf(dbg, "USB::SendCmd cmd \"%s\", response \"%s\"", command, response);
    SpecialDebugPrint(dbg, 10, 275);
#endif // DEBUG_PRINT_HERE
}


/*
    Sends a command to the GC for which we expect a response of "DACK" if successful,
    "DNAK" or "EPKT" if failure.
    
    Args: pointer to a USBDeviceConnected instance
          pointer to a USBHostGC instance
          a pointer to the command in question, as a null terminated string
    
    Returns true if the GC responded with "DACK", false for anything else
*/
bool USBHostGCUtilities::SendCommandToGCWithDACKResponse(USBDeviceConnected* usbDevice, USBHostGC* usbHostGC, char *cmd)
{
    char response[50];
    SendCommandToGCAndGetResponse(usbDevice, usbHostGC, cmd, response);
    // We expect a response like this: "DACK" for success, "DNAK" for failure, "EPKT" for error
    
    return (response[1] == 'A');
}
