#ifndef USBHOSTGC_H
#define USBHOSTGC_H

#include "lpc_swim.h"
#include "lpc_swim_font.h"

#include "USBHostConf.h"
#include "USBHost.h"

enum GC_IDS {
    GC_VENDOR_ID = 0x0925,
    GC_PRODUCT_ID = 0x1234,  // Earlier sofware versions
    GC_PRODUCT_ID_2 = 0x1235 // Later versions
};

enum GC_MESSAGE_DATA {
    GC_MESSAGE_LENGTH = 10,
    GC_CR = 13             // Make *sure* we use the same value for <CR> as the GC expects
};

// USBHost does not define these - GC assembler code does
#define GET_CONFIGURATION 0x08
#define GC_CONFIGURATION_DESCRIPTOR_LENGTH 0x22

/**
 * A class to communicate with a USB GC.
 *
 */
class USBHostGC : public IUSBEnumerator 
{
public:
    USBHostGC();
    ~USBHostGC();

    void SetDebugWindow(SWIM_WINDOW_T* newDebugWindow) { debugWindow = newDebugWindow; }

    bool DeviceIsGC(void) { return deviceIsGC; }
    
    void NoDeviceConnected(void);
    
    bool AttachGCDevice(USBDeviceConnected* usbDeviceConnected);
    
    void RXHandler(void);
    
    USB_TYPE SetDeviceReport(USBDeviceConnected * dev, const char* report, char* response);  
    
    bool ExecutingSetDeviceReport(void);
  
    
    // From IUSBEnumerator - implement these to make this class non-abstract
    virtual void setVidPid(uint16_t vid, uint16_t pid);
    virtual bool parseInterface(uint8_t intf_nb, uint8_t intf_class, uint8_t intf_subclass, uint8_t intf_protocol); // Must return true if the interface should be parsed
    virtual bool useEndpoint(uint8_t intf_nb, ENDPOINT_TYPE type, ENDPOINT_DIRECTION dir); // Must return true if the endpoint will be used

private:
    void DebugPrint(const char* debugText);
    
    void AllocateReportBuffer(void);

    SWIM_WINDOW_T* debugWindow;
    USBHost* usbHost;

    bool deviceIsGC;
    int intfGC;
    uint8_t* reportBuffer;
    USBEndpoint* intInEndpointGC;
    USBDeviceConnected* usbGCDeviceConnected;
    
    bool volatile responseReceived;
    
    bool volatile alreadyInSetDeviceReport;
};


#endif
