#ifndef SWIMDRAW_H
#define SWIMDRAW_H

/*
    This class encapsulates the 'lpc_swim' functions provided by mbed for drawing on the display.
    We are using these to draw our own profile graphs on our own bitmaps, 
    which should give an improved appearance by comparison with easyGUI.
    
    This class (as usual) is a singleton - there is only one display, after all.
*/

class SwimDraw {
public:
    /**
    * Static method to create (if necessary) and retrieve the single GasCalibrationPageHandler instance
    */
    static SwimDraw * GetInstance(void);
    
    void Initialise(DMBoard* board, void* frameBuffer);
    
    bool DrawLine(COLOR_T lineColour, int32_t xStart, int32_t yStart, int32_t xEnd, int32_t yEnd);
    
    bool DrawRectangle(COLOR_T rectColour, int32_t xStart, int32_t yStart, int32_t xEnd, int32_t yEnd);
    
    
private:
    
    static SwimDraw * theSwimDrawInstance;
    
    // singleton class -> constructor is private
    SwimDraw();    
    ~SwimDraw();

    bool initialised;
    
    SWIM_WINDOW_T swimWindowT;
};

#endif // SWIMDRAW_H
