#include "mbed.h"
#include "DMBoard.h"
#include "lpc_swim.h"
#include "lpc_swim_font.h"

#include "SwimDraw.h"

/*                      
    Note that this class is a singleton - we do not need or want there to be more than one instance of it
    (we do not want multiple values for the carrier gas selection, etc, and nor will we show 
    more than one easyGUI 'GasCalibrationPage' to the user at the same time).
*/
SwimDraw * SwimDraw::theSwimDrawInstance = NULL;


/*
    Singleton class - return the one and only instance, first creating it if necessary.
*/
SwimDraw * SwimDraw::GetInstance(void)
{
    if (theSwimDrawInstance == NULL) {
        theSwimDrawInstance = new SwimDraw();
    }
    
    return theSwimDrawInstance;
}

// Singleton class - private constructor
SwimDraw::SwimDraw()
{
    initialised = false;
}
    
// Private destructor also
SwimDraw::~SwimDraw()
{

}


/*
    Initialise the SwimDraw instance to match the display.
    
    Args: pointer to the current DMBoard
          pointer to the frame buffer
          
    No return code
*/
void SwimDraw::Initialise(DMBoard* board, void* frameBuffer)
{
    // We only initialise once
    
    if(!initialised) {
        
        Display* disp = board->display();
        
        swim_window_open_noclear(&swimWindowT, 
                                 disp->width(), disp->height(),         // full size
                                 (COLOR_T*)frameBuffer,
                                 0,0,disp->width()-1, disp->height()-1, // window position and size
                                 1,                                     // border
                                 WHITE, BLUE, BLACK);                   // colors: pen, backgr, forgr
        
        initialised = true;
    }
}


/*
    Draws a line on the display, using the relevant 'lpc_swim' functions. 
    Caller specifies the line colour and position.
    
    Args: colour
          start X coord
          start Y coord
          end X coord
          end Y coord
          
    Returns true if successful, false if not.
*/
bool SwimDraw::DrawLine(COLOR_T lineColour, int32_t xStart, int32_t yStart, int32_t xEnd, int32_t yEnd)
{
    if (!initialised) {
        return false;
    }
    
    swim_set_pen_color(&swimWindowT, lineColour);
    
    swim_put_line(&swimWindowT, xStart, yStart, xEnd, yEnd);
    
    return true;
}


/*
    Draws a solid rectangle on the display, using the relevant 'lpc_swim' functions. 
    Caller specifies the rectangle colour and position.
    
    Args: colour
          start X coord
          start Y coord
          end X coord
          end Y coord
          
    Returns true if successful, false if not.
*/
bool SwimDraw::DrawRectangle(COLOR_T rectColour, int32_t xStart, int32_t yStart, int32_t xEnd, int32_t yEnd)
{
    if (!initialised) {
        return false;
    }
    
    swim_set_pen_color(&swimWindowT, rectColour);
    swim_set_fill_color(&swimWindowT, rectColour);
    
    swim_put_box(&swimWindowT, xStart, yStart, xEnd, yEnd);

    return true;
}

