#ifndef SETTINGSHANDLER_H
#define SETTINGSHANDLER_H

#include "GuiLib.h"

/*
    This class contains static functions only.
    These functions read and write settings values to QSPI memory.
    
    This is an alternative, more C++ like, way of implementing these functions
    and making them available to the whole application, as opposed to simply having them 
    defined as ordinary C-style functions in main.cpp, with corresponding extern declarations 
    everywhere else.
    
    Earlier attempts to implement the same functionality using more conventional
    object oriented class code led to lockups in totally unrelated areas - 
    until we find out why, stick with this...
    
    Note: a possible explanation for the earlier problems is that, 
    while I had un-commented '#define DM_BOARD_USE_QSPI' in dm_board_config.h, 
    I had *not* un-commented '#define DM_BOARD_USE_QSPI_FS'. This could have led 
    to invalid pointer values being used, etc. Since un-commenting both '#define's, 
    we have had no problems accessing QSPI memory (so far, at least...)
*/
class SettingsHandler {
public:
    static int GetSettingValueFromQSPI(char *settingName, char *settingValueBuff, int valueBuffLen);
    static int PutSettingValueToQSPI(char *settingName, char *settingValueBuff, int valueBuffLen);
    static int GetIntegerValueFromQSPISettings(char *settingName, int defaultValue);
    static void PutIntegerValueToQSPISettings(char *settingName, int value);
    
    static void DisplayQSPIDirectory(GuiConst_INT16S X, GuiConst_INT16S Y);
    
private:
    // Private constructor - so this class cannot be instantiated
    SettingsHandler();
    
    static void FormatQSPIIfRequired(void);
};

#endif // SETTINGSHANDLER_H
