#ifndef GASCHANNELDACANDADCPAGEHANDLER_H
#define GASCHANNELDACANDADCPAGEHANDLER_H

#include "mbed.h"
#include "DMBoard.h"

#include "USBHostGC.h"

#include "GuiLib.h"

/*
    This class handles user interaction with the easyGUI "GasChannelDACAndADCPage",
    as well as storing the values in QSPI memory.
    
    Note that this class is a singleton - we do not need or want there to be more than one instance of it
    (we do not want multiple values for each DAC value, etc, and nor will we show 
    more than one easyGUI 'GasChannelDACAndADCPage' to the user at the same time).
*/
class GasChannelDACAndADCPageHandler {
public:
    /**
    * Static method to create (if necessary) and retrieve the single GasChannelDACAndADCPageHandler instance
    */
    static GasChannelDACAndADCPageHandler * GetInstance(USBDeviceConnected* newUsbDevice, USBHostGC* newUsbHostGC);
    
    bool TouchAreaIsOnGasChannelDACAndADCPage(int touchAreaIndex);

    bool DealWithTouch(int touchAreaIndex);
    
    void DisplayingEasyGUIPage(void);
    
private:
    static const int minimumDACValue;
    static const int maximumDACValue;

    static const GuiConst_INTCOLOR inactiveFieldBackgroundColour;
    static const GuiConst_INTCOLOR activeFieldBackgroundColour;

    // Explicit values here, to ensure that they match the easyGUI variable
    typedef enum enumChannelSelection { TOTAL_FLOW = 1, BACK_PRESSURE = 2, FUEL = 3, AIR = 4 } ChannelSelection;
    
    ChannelSelection channelSelection;
    
    USBDeviceConnected* usbDevice;
    USBHostGC* usbHostGC;
    
    static GasChannelDACAndADCPageHandler * theGasChannelDACAndADCPageHandlerInstance;
    
    // singleton class -> constructor is private
    GasChannelDACAndADCPageHandler(USBDeviceConnected* newUsbDevice, USBHostGC* newUsbHostGC);    
    ~GasChannelDACAndADCPageHandler();

    void SaveGasChannelSelectionToQSPISettings(void);
    void ReadGasChannelSelectionFromQSPISettings(void);

    void UpdateEasyGUIPage(void);

    bool GetGasChannelADCValue(int channel, char* buffer);

    bool SetGasChannelDACValue(int channel, char* buffer);

};

#endif // GASCHANNELDACANDADCPAGEHANDLER_H

