#ifndef GCHEATCONTROL_H
#define GCHEATCONTROL_H

#include "mbed.h"
#include "DMBoard.h"

#include "USBHostGC.h"

/*
    A class to 'encapsulate' the heat control on the GC
    
    Requires a pointer to the USBHostGC instance that corresponds to the GC,
             a pointer to the USBDeviceConnected instance that (also) corresponds to the GC

*/

//#define DEBUG_TEST // If defined, use a local flag only, not the actual GC

class GCHeatControl
{
public:
    GCHeatControl(USBDeviceConnected* newUsbDevice, USBHostGC* newUsbHostGC);    
        
    bool TurnHeatOn(void);
    
    bool TurnHeatOff(void);
    
    bool IsHeatOn(void);
    
private:
    USBDeviceConnected* usbDevice;
    USBHostGC* usbHostGC;
    
#ifdef DEBUG_TEST
    bool heatIsOn;
#endif
};


#endif // GCHEATCONTROL_H