#ifndef GCCOMPONENTTYPEENUMS_H
#define GCCOMPONENTTYPEENUMS_H

/*
    Enums enumerating the possible types of various GC components.
    
    Since the values in each enumeration must match those returned by the corresponding GC command
    to get the component type, they are all specified explicitly. All of them also include 
    a MIN_xxx_TYPE and MAX_xxx_TYPE specifier. As long as we keep these up to date, the code 
    that uses these enumerations should not have to be changed if we simply add more component types.
    
    The values below are taken from page 5 of 18 of the 500 Series GC Communications Protocol, 
    Version 1.0, dated 11/02/16.
*/

    // The values in this enumeration must match those returned by the GC "GDTY" command
    typedef enum enumDetectorType { FID_DETECTOR = 0, 
                                    TCD_DETECTOR = 1,
                                    ECD_DETECTOR = 2,
                                    TXL_DETECTOR = 3,
                                    NO_DETECTOR  = 4,
                                    NPD_DETECTOR = 5,
                                    PID_DETECTOR = 6,
                                    FPD_DETECTOR = 7,
                                    SPDID_DETECTOR = 8,
                                    
                                    MIN_DETECTOR_TYPE = FID_DETECTOR,   // These must be kept up to date...
                                    MAX_DETECTOR_TYPE = SPDID_DETECTOR  // ...with the above
                                  } DetectorType;
                    
    // The values in this enumeration must match those returned by the GC "GCTY" command
    typedef enum enumColumnType { NO_COLUMN = 0, 
                                  CONVENTIONAL_COLUMN = 1,
                                  DIRECTLY_HEATED_COLUMN = 2,
                                  
                                  MIN_COLUMN_TYPE = NO_COLUMN,              // These must be kept up to date...
                                  MAX_COLUMN_TYPE = DIRECTLY_HEATED_COLUMN  // ...with the above
                                } ColumnType;
                    
    // The values in this enumeration must match those returned by the GC "GITY" command
    typedef enum enumInjectorType { NO_INJECTOR = 0, 
                                    TEST_PTV_INJECTOR = 1,
                                    PTV_INJECTOR = 2,
                                    
                                    MIN_INJECTOR_TYPE = NO_INJECTOR,  // These must be kept up to date...
                                    MAX_INJECTOR_TYPE = PTV_INJECTOR  // ...with the above
                                  } InjectorType;
                    
    // The values in this enumeration must match those returned by the GC "GATY" command
    typedef enum enumAuxiliaryType { NO_AUXILIARY = 0, 
                                     FITTED_AUXILIARY = 1,
                                     
                                     MIN_AUXILIARY_TYPE = NO_AUXILIARY,     // These must be kept up to date...
                                     MAX_AUXILIARY_TYPE = FITTED_AUXILIARY  // ...with the above
                                   } AuxiliaryType;
                    
    // The values in this enumeration must match those returned by the GC "GGTY" command
    typedef enum enumGasboxType { MANUAL_GASBOX = 0, 
                                  EPPC_GASBOX = 1,
                                  
                                  MIN_GASBOX_TYPE = MANUAL_GASBOX, // These must be kept up to date...
                                  MAX_GASBOX_TYPE = EPPC_GASBOX    // ...with the above
                                } GasboxType;
                    
    // The values in this enumeration must match those returned by the GC "GCGS" command
    typedef enum enumCarrierGasType { CARRIER_GAS_NITROGEN = 0, 
                                      CARRIER_GAS_HELIUM = 1,
                                      CARRIER_GAS_HYDROGEN = 2,
                                      
                                      MIN_CARRIER_GAS_TYPE = CARRIER_GAS_NITROGEN, // These must be kept up to date...
                                      MAX_CARRIER_GAS_TYPE = CARRIER_GAS_HYDROGEN  // ...with the above
                                    } CarrierGasType;

#endif // GCCOMPONENTTYPEENUMS_H
