#ifndef DETECTORIGNITIONHANDLER_H
#define DETECTORIGNITIONHANDLER_H

#include "mbed.h"
#include "DMBoard.h"

#include "USBHostGC.h"
#include "GCIgnitionStateEnum.h"

#include "GuiLib.h"

/*
    A class to handle the ignition of the detector, in response to the user
    pressing the 'Ignite' button on the easyGUI pages for the FID
    and FPD detector types.

    Note that (as with many other classes in this application) this class is a singleton - 
    we do not need or want there to be more than one instance of it (we do not want 
    multiple ignition attempts going on simultaneously, and nor will we show 
    more than one easyGUI Detector page to the user at the same time).
*/

class DetectorIgnitionHandler {
public:
    /**
    * Static method to create (if necessary) and retrieve the single DetectorIgnitionHandler instance
    */
    static DetectorIgnitionHandler * GetInstance(USBDeviceConnected* newUsbDevice, USBHostGC* newUsbHostGC);
    
    /**
    * Version of the above that does not create the instance. Provided for callers that do not have 
    * the 'usbDevice' and 'usbHostGC' pointers, and that just want access to the instance
    */
    static DetectorIgnitionHandler * GetInstance(void);
    
    bool TouchAreaIsDetectorIgniteButton(int touchAreaIndex);

    bool DealWithTouch(int touchAreaIndex);
    
    static bool Igniting(void) { return igniting; }

private:    
    static DetectorIgnitionHandler * theDetectorIgnitionHandlerInstance;
    
    USBDeviceConnected* usbDevice;
    USBHostGC* usbHostGC;
    
    // singleton class -> constructor is private
    DetectorIgnitionHandler(USBDeviceConnected* newUsbDevice, USBHostGC* newUsbHostGC);    
    ~DetectorIgnitionHandler();
    
    void PerformIgnitionSequence(void);
    
    void SendCommandToGCAndGetResponse(char* command, char* response);
    
    bool TellGCToIgniteDetector(void);

    IgnitionState GetDetectorIgnitionState(void);
    
    void DrawTextOnIgniteButton(char* text, GuiConst_INTCOLOR foreColor, GuiConst_INTCOLOR backColor);
    
    void DrawIgnitionLightingText(void);
    void DrawIgnitionLitText(void);
    void DrawIgnitionNotLitText(void);
    
    static bool igniting;
};

#endif // DETECTORIGNITIONHANDLER_H
