#ifndef COLUMNDHSENSORCALIBRATIONPAGEHANDLER_H
#define COLUMNDHSENSORCALIBRATIONPAGEHANDLER_H

#include "mbed.h"
#include "DMBoard.h"

#include "USBHostGC.h"

#include "GuiLib.h"

/*
    A struct to relate the index of an easyGUI touch area on the 'ColumnDHSensorCalibrationPage',
    with the easyGUI variable and our own internal variable to which it corresponds
*/
typedef struct structColumnDHSensorCalibrationEasyGUITouchAreaAndVariables {
    int touchAreaIndex;
    GuiConst_TEXT * easyGUIVariablePtr;
    int maxValue;
    int minValue;
    bool canBeNegative;
    char variableTitle[41];
} ColumnDHSensorCalibrationEasyGUITouchAreaAndVariables;


/*
    This class handles user interaction with the easyGUI "ColumnDHSensorCalibrationPage".
    
    Note that this class is a singleton - we do not need or want there to be more than one instance of it
    (we do not want multiple values for the calibration values, etc, and nor will we show 
    more than one easyGUI 'ColumnDHSensorCalibrationPage' to the user at the same time).
*/

class ColumnDHSensorCalibrationPageHandler {
public:
    /**
    * Static method to create (if necessary) and retrieve the single ColumnDHSensorCalibrationPageHandler instance
    */
    static ColumnDHSensorCalibrationPageHandler * GetInstance(USBDeviceConnected* newUsbDevice, USBHostGC* newUsbHostGC);
    
    /**
    * Version of the above that does not create the instance. Provided for callers that do not have 
    * the 'usbDevice' and 'usbHostGC' pointers, and that just want access to the instance
    */
    static ColumnDHSensorCalibrationPageHandler * GetInstance(void);
    
    bool TouchAreaIsOnCalibrationPage(int touchAreaIndex);

    bool DealWithTouch(int touchAreaIndex);
    
    void DisplayingEasyGUIPage(bool updateEasyGUIVariables);

private:    
    static ColumnDHSensorCalibrationPageHandler * theColumnDHSensorCalibrationPageHandlerInstance;
    
    USBDeviceConnected* usbDevice;
    USBHostGC* usbHostGC;
    
    // singleton class -> constructor is private
    ColumnDHSensorCalibrationPageHandler(USBDeviceConnected* newUsbDevice, USBHostGC* newUsbHostGC);    
    ~ColumnDHSensorCalibrationPageHandler();
    
    void GetCurrentCalibrationFromGC(void);
    void SetCurrentCalibrationInGC(void);

    void SendCommandToGCAndGetResponse(char* command, char* response);
    bool SendCommandToGCWithDACKResponse(char *cmd);

    bool GetGainCalibrationFromGC(char *cmd, GuiConst_TEXT* easyGUIVariable);
    bool GetOffsetCalibrationFromGC(char *cmd, GuiConst_TEXT* easyGUIVariable);

    bool SetGainCalibrationInGC(char *cmd, GuiConst_TEXT* easyGUIVariable);
    bool SetOffsetCalibrationInGC(char *cmd, GuiConst_TEXT* easyGUIVariable);

    enum { COUNT_OF_VARIABLES_FOR_TOUCH_AREAS = 4 };
    ColumnDHSensorCalibrationEasyGUITouchAreaAndVariables variablesForTouchArea[COUNT_OF_VARIABLES_FOR_TOUCH_AREAS];

    int GetIndexOfValueToEditForTouchArea(int touchAreaIndex);
};

#endif // COLUMNDHSENSORCALIBRATIONPAGEHANDLER_H
