#include "stdio.h"
#include "mbed.h"
#include "string"
#include "ILI932x.h"
#include "DmTouch.h"
#include "Arial24x23.h"

/* Configure the DisplayModule ILI9325 2.4" display for 8-bit bus communication

    mbed pin    display pin
    --------    -----------
    p15         CS (L15)
    p17         RST (L17)
    p16         RS (L4)
    p14         WR (L5)
    p20         RD (L6)
    
    p30         DB8 (L7)
    p29         DB9 (L8)
    p28         DB10 (L9)
    p27         DB11 (L10)
    p26         DB12 (L11)
    p25         DB13 (L12)
    p24         DB14 (L13)
    p23         DB15 (L14)
    
    p1          GND (L1)
    p40         Vin (L2)
    p40         LED Backlight (L19)
    
    Additional connections to add touch response

    mbed pin    display pin
    --------    -----------
    p5          T_MOSI (R11)
    p6          T_MISO (R13)
    p7          T_CLK (R9)
    p8          T_CS (R10)
    p9          T_IRQ (R14)
*/  

PinName dataBus[]= {p30, p29, p28, p27, p26, p25, p24, p23};
ILI932x myLCD(BUS_8, dataBus, p15, p17, p16, p14, p20, "myLCD", 240, 320); // Bus 8 bit, bus pin array, CS, RST, DC, WR, RD, name, xpixels, ypixels
DmTouch touch(DmTouch::DM_TFT24_104, p5, p6, p7, p8, p9);
char orient=3;              // orient horizontal is long axis
bool down, lastDown;        // keeps track of whether or not the screen is/was pressed
Timer t;
DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);
uint16_t tx,ty;         // coordinates for touch screen

int main(){
    
    touch.init();
    t.start();
    myLCD.set_orientation(orient);
    myLCD.background(Black);    // set background to Black
    myLCD.foreground(White);    // set chars to White
    myLCD.fillcircle(80,60,30,Blue);    //creating circles
    myLCD.fillcircle(240,60,30,Red);
    myLCD.fillcircle(80,180,30,Green);
    myLCD.fillcircle(240,180,30,Yellow);
    
   myLCD.set_font((unsigned char*) Arial24x23);
    myLCD.locate(70,50);
    myLCD.printf("1\t");
    myLCD.locate(230,50);
    myLCD.printf("2\t");
    myLCD.locate(70,170);
    myLCD.printf("3\t");
    myLCD.locate(230,170);
    myLCD.printf("4\t");
    
    // Touch screen demo

        touch.setOrientation(orient);       // orient LCD screen
        down = false;
        bool justDown = false;

        t.reset();                          // reset timer
        while (1) {
            
            touch.readTouchData(tx, ty, down);          // read if touch screen is pressed and where
            if (down){
                if(t.read_ms()>200){                    // "debounce
                    if ((110>tx) && (tx>50) && (90>ty) && (ty>30))  // if touch screen is pressed in circle 1
                        led1 = !led1;                               //toggle LED 1
                    if ((270>tx) && (tx>210) && (90>ty) && (ty>30)) // if touch screen is pressed in circle 2
                        led2 = !led2;                               //toggle LED 2
                    if ((110>tx) && (tx>50) && (210>ty) && (ty>150)) // if touch screen is pressed in circle 3
                        led3 = !led3;                               //toggle LED 3
                    if ((270>tx) && (tx>210) && (210>ty) && (ty>150)) // if touch screen is pressed in circle 4
                        led4 = !led4;                               //toggle LED 4
                    
                t.reset();                              // reset timer
                wait(0.04);
                
                }   
                else if (justDown) {                        // if it was just pressed but is no longer pressed
                    
                // necessary to prevent leds from blinking
                myLCD.locate(40, 20);
                myLCD.printf("     ");
                }
                justDown = down;                
            }
        }
                
}