//HJM : 선풍기 에이징 테스트 용 소스임.
//180615 HJM : 선풍기 에이징 용 온도 1개 진동 10개 전송용 테스트 임.
//            CUBEBITE_TEMPERATURE_DISABLE  define 값으로 온도 센서 (연결 및 미연결) 시 설정을 할 수 있음.
//180717 HJM : 인증(온도) 테스트용 소스 버전 관리, 0.1 -> 온도(저온) 테스트
//180717 HJM : 수정 1


#include "mbed.h"
#include "ADXL362.h"
#include "SimpleSpirit1.h"
#include "main.h"


#define FIRMWARE_VERSION_MAJOR        0
#define FIRMWARE_VERSION_MINOR        1
#define FIRMWARE_VERSION_REVISE       0

//#define FIRMWARE_VERSION_PRINT(x)  printf(#x " = %s\n", x);

//*************************************************************************************
//Define : Test, Compile 
//*************************************************************************************
//#define CUBEBITE_DEBUG
//#define HEAVY_DEBUG


/* 180108 cubebite HJM : cubebite Testing define, 1개씩만 켜야 함. */
#define CUBEBITE_RF_SPEED_TEST_SEND_ON
//#define CUBEBITE_RF_SPEED_TEST_RECV_ON
//#define CUBEBITE_RF_SPEED_TEST_SEND_AND_RECV_ON   //HJM : 추후 만들 예정..

/* 180109 cubebite HJM : cubebite Compile define, 1개씩만 켜야 함. */
#define CUBEBITE_BOARD_AD3029LZ


#define CUBEBITE_RF_SETTING_VALUE_PRINT
//#define CUBEBITE_TEMPERATURE_DISABLE


//180411 HJM : 현재 1~3 까지 3대까지 가능 -> 게이트웨이에서 3대까지만 처리하게끔 되어있
//#define CUBEBITE_SENSOR_UUID        1   //3180621 HJM : 온도 및 진동 테스트 용
#define CUBEBITE_SENSOR_UUID        2 //180621 HJM : 철기연 테스트 용, 방대리님 테스트 용
//*************************************************************************************




//HJM : 타이머 인터럽트 테스트 용
#ifdef  CUBEBITE_DEBUG
    DigitalOut led1(LED1);
#endif  




//*************************************************************************************
//HJM SUDO code : 3개 객체 생성->RF, 온도, 진동
//*************************************************************************************



//온도 객체
#ifndef CUBEBITE_TEMPERATURE_DISABLE
I2C i2c(I2C_SDA, I2C_SCL);  //HJM : 테스트 용 임, 서대리님이 클래스 정리해서 줄 예정
#endif

//진동 객체(Accelerometer (mosi, miso, sclk, cs), SPI 1)
ADXL362 adxl362(P1_07, P1_08, P1_06, P1_10); //HJM : 테스트 용 임, 서대리님이 클래스 정리해서 줄 예정

//*************************************************************************************






//*************************************************************************************
//HJM SUDO code : main 사용자 함수 선언
//*************************************************************************************


static void callback_func(int event);   //RF user callback 함수임.
void UserTimerInterrupt(void);          //1초, 타이머 인터럽트 임
int UserTimerInterrupt_Execution(void);
int UserTimerInterrupt_Execution2(void);
//void UserTimerInterrupt2(void);
static int SendData(SimpleSpirit1& myspirit);


//*************************************************************************************








//*************************************************************************************
//(테스트용)HJM SUDO code : 전역 변수, 진동, 온도 쪽 테스트용임. 추후 서대리님이 클래스 재 정의시 없어질 예정
//*************************************************************************************

//RF 객체
    static SimpleSpirit1 &myspirit = SimpleSpirit1::CreateInstance(P0_01, P0_02, P0_00, P1_12 ,P2_08, P1_14);  
                         // P0_01[SPI0_MOSI]
                          // P0_02[SPI0_MISO], 
                          // P0_00[SPI0_CLK], 
                        // P1_12[GPIO 28, RF(GPIO 0)]->IRQ로 설정, 
                        // P2_08[SPI0_CS2], 
                        // P1_14[GPIO 30, RF (SDN)]


//진동
uint16_t vCnt = 0;
uint8_t iCnt = 0;   

//int16_t x16 = 0;
//int16_t y16 = 0;
//int16_t z16 = 0;
int8_t x8 = 0;
int8_t y8 = 0;
int8_t z8 = 0;


int8_t int8tX8Result = 0;
int8_t int8tY8Result = 0;
int8_t int8tZ8Result = 0;


int16_t temp_x16[3] = {0,};
int16_t temp_y16[3] = {0,};
int16_t temp_z16[3] = {0,};

int Comp1_x = 0, Comp2_x = 0;
int Comp1_y = 0, Comp2_y = 0;
int Comp1_z = 0, Comp2_z = 0;

float float_x = 0;
float float_y = 0;
float float_z = 0;     

float G_x = 0;
float G_y = 0;
float G_z = 0;

float  Output = 0;

double dVibOutputSqrt = 0;


//온도
char wReg[2] = {0,};
char rReg[2] = {0,};
int wACK = 0;
int rACK = 0;
int16_t Tem16;
float TempData = 0;

#define busAddr 0x4F

#define ID_DATA_ADDR 0x00
#define ID_CON_ADDR 0x01
#define ID_REG_ADDR 0x07

#define RESET_HW_OFF    1
#define RESET_HW_ON     0

#define SPIRIT1_POWER_OFF    1
#define SPIRIT1_POWER_ON     2


//RF->이거도 클래스 내부에 넣기
static volatile bool bRxDoneFlag = false; 
static volatile bool bTxDoneFlag = false; 
static volatile bool bSendDataFlag = false;

//*************************************************************************************









//HJM : I2C PullUp 용.. RF IRQ 도 이 핀 이지만 사용안하기 때문에 괜찮음.
DigitalOut resetHW(P1_12);
//prit1(P1_11);  //GPIO27

bool iTempFlag = false;
bool isTimerInterruptStarted = false;
bool bIs1SecTimerSet = false;
int iTempInitCount = 0;
bool isTempInitOk = false;

int iMainCounting = 1;
static int iIsResetStartCounting = 0;
//static int iIsResetStartCountingInterrupt = 0;
int main(void)
{    
//*************************************************************************************
//HJM SUDO code : 진동, 온도, RF 초기화
//*************************************************************************************    
    
    //필수!!!
    resetHW.write(RESET_HW_OFF);    
    
    printf("\n\n FIRMWARE_VERSION : %d.%d.%d\n\n", FIRMWARE_VERSION_MAJOR, FIRMWARE_VERSION_MINOR, FIRMWARE_VERSION_REVISE);    
    
    
    
    
//    FIRMWARE_VERSION_PRINT(FIRMWARE_VERSION);
    
    
    
    
    //진동 init_시작
        // set up SPI interface
    adxl362.init_spi();
        // Set up accelerometer
    adxl362.init_adxl362();
    
//    wait_ms(25);
    //진동 init_끝
    
    
    //온도 init_시작    
        //Power supply for the sensor is given from GPIO28(VDD_MCU_B).
        // JMOD Init
#ifndef CUBEBITE_TEMPERATURE_DISABLE       
    printf("[Temperature] Init start");
    
    i2c.frequency(100000);  //100khz
    wReg[0] = ID_CON_ADDR;
    
    while(rReg[0] != 0x03)
    {
        //write 0x00(ID_CON_ADDR) 
        wReg[1] = 0x00;
        wACK = i2c.write(busAddr, wReg, 2);

        //read 0x00(ID_CON_ADDR) 
        wACK = i2c.write(busAddr, wReg, 1);
        rACK = i2c.read(busAddr, rReg, 1);
    
        wait_ms(250);     
        
        //write 0x03(ID_CON_ADDR) 
        wReg[1] = 0x03;
        wACK = i2c.write(busAddr, wReg, 2);

        //read 0x03(ID_CON_ADDR) 
        wACK = i2c.write(busAddr, wReg, 1);
        rACK = i2c.read(busAddr, rReg, 1);
    
        i2c.write(busAddr, wReg, 2);

        if(rReg[0] == 0x03)
        {
//            printf(" (Vib Success!!)\n\n");

            //write 0x00(ID_CON_ADDR) 
            wReg[1] = 0x00;
            wACK = i2c.write(busAddr, wReg, 2);
            isTempInitOk = true;
//            wait_ms(250);     
//            wait_ms(60);     
            wait_ms(150);    
        }
        else if (10 == iTempInitCount)
        {
            isTempInitOk = false;
            break;
        }
        else
        {
            printf(".");
            ++iTempInitCount;
        }
        
//        wait_ms(500);           
//        wait_ms(80);
        wait_ms(200);
    }
#endif    
    printf("(OK)\n");
    //온도 init_끝
    
    
    
    
    //RF init_시작    
//    myspirit.attach_irq_callback(callback_func);      
    if (myspirit.on())
    {
        printf("ERROR.\n");        
    }
    else
    {
        printf("OK.\n"); 
    }    
    //RF init_끝
//*************************************************************************************    
    
    
    
//*************************************************************************************
//HJM SUDO code : 1초 타이머 인터럽트 생성, 1초 간격 호출 함수 : UserTimerInterrupt()
//*************************************************************************************
//    Timeout timeoutUserInterrupt;                         //1번만 실행
    Ticker timeoutUserInterrupt;                            //매번 실행
//    Ticker timeoutUserInterrupt2;                            //매번 실행
//    timeoutUserInterrupt.attach(&UserTimerInterrupt, 1.0); //1 sec 
    timeoutUserInterrupt.attach(&UserTimerInterrupt, 900.0); //15 minuite, reset test
//    timeoutUserInterrupt2.attach(&UserTimerInterrupt2, 1.0); //1 sec
//    timeoutUserInterrupt.attach(&UserTimerInterrupt, 5.0); //test, 5sec
//*************************************************************************************
    
//    wait(1);
    
    
    while(1)
    {
        __WFE();    //HJM : sleep 모드 ON                                
        
        UserTimerInterrupt_Execution();
        UserTimerInterrupt_Execution2();
        
//        myspirit.off();
//        myspirit.on();
        
        //if (0 == (iMainCounting % 10))
//        {
////            myspirit.reset_board();
////            iMainCounting = 0;            
//            iMainCounting = 1;
//            myspirit.off();
//            myspirit.on();    
//        }
        
        if (true == isTimerInterruptStarted)
        {            
            isTimerInterruptStarted = false;
            SendData(myspirit);                                                    
        }        
    }


//    return 0; //unreachable
}

static void callback_func(int event) 
{
#ifdef  CUBEBITE_DEBUG
    printf("[CUBEBITE] callback_func(int event) \n");
#endif
  
    if(event == SimpleSpirit1::RX_DONE) 
    {         
        bRxDoneFlag = 1;
    }
    else if (event == SimpleSpirit1::TX_DONE) 
    {  
        bTxDoneFlag = 1;
    }
}



void UserTimerInterrupt(void)
{
    resetHW.write(RESET_HW_ON);        

    return;    
}



int UserTimerInterrupt_Execution(void)
{
    if (true == isTempInitOk)
    {       
        wReg[0] = ID_DATA_ADDR;            
            
        i2c.write(busAddr, wReg, 1);
        i2c.read(busAddr, rReg, 2);                                            
    
        Tem16 = (rReg[0] << 8) | (rReg[1]);
        Tem16 >>= 5;
        TempData = Tem16;
        
        TempData = TempData *0.125;
    }   
    
    return 0;    
}


volatile int iFunctionCallCounting = 0;
bool isTempOk = false;
int UserTimerInterrupt_Execution2(void)
{
//    printf("UserTimerInterrupt_Execution 호출, dataCount : [%d]\n", dataCount);
    ++iFunctionCallCounting;
    
    if (false == isTimerInterruptStarted)
    {               
        //진동    
        adxl362.ACC_GetXYZ8(&x8, &y8, &z8);                
        if (0 == x8)
        {
            uiSendBuf[dataCount++] = '0';
            uiSendBuf[dataCount++] = 'x';
            uiSendBuf[dataCount++] = '@';            
        }
        else
        {
            int8tX8Result = x8;
                                    
            uiSendBuf[dataCount++] = (uint8_t)int8tX8Result;            
        }        
        if (0 == y8)
        {
            uiSendBuf[dataCount++] = '0';
            uiSendBuf[dataCount++] = 'y';
            uiSendBuf[dataCount++] = '@';
        }
        else
        {
            int8tY8Result = y8;   
            
            uiSendBuf[dataCount++] = (uint8_t)int8tY8Result; 
        }        
        if (0 == z8)
        {
            uiSendBuf[dataCount++] = '0';
            uiSendBuf[dataCount++] = 'z';
            uiSendBuf[dataCount++] = '@';
        }                      
        else
        {
            int8tZ8Result = z8;            
                        
            uiSendBuf[dataCount++] = (uint8_t)int8tZ8Result;   
        }           
    
        wait(0.025); // 25ms, Wait is required in this mode
    
        //온도     
    //        temperature data receive
        if (true == isTempInitOk)
        {       
           // wReg[0] = ID_DATA_ADDR;            
//                
//            i2c.write(busAddr, wReg, 1);
//            i2c.read(busAddr, rReg, 2);                                            
//        
//            Tem16 = (rReg[0] << 8) | (rReg[1]);
//            Tem16 >>= 5;
//            TempData = Tem16;
//            
//            TempData = TempData *0.125;
            
            if (0 == rReg[0])
            {            
                uiSendBuf[dataCount++] = '@';
                uiSendBuf[dataCount++] = '0';            
//                uiSendBuf[dataCount++] = '1';            
            }
            else
            {
                uiSendBuf[dataCount++] = (uint8_t)rReg[0];    
            }
            
            
            
            if (0 == rReg[1])
            {
                uiSendBuf[dataCount++] = '@';
                uiSendBuf[dataCount++] = '0';            
//                uiSendBuf[dataCount++] = '2';            
            }
            else
            {
                uiSendBuf[dataCount++] = (uint8_t)rReg[1];            
            }
        }
        else
        {
            uiSendBuf[dataCount++] = '@';
            uiSendBuf[dataCount++] = '0';
//            uiSendBuf[dataCount++] = '1';
            uiSendBuf[dataCount++] = '@';
            uiSendBuf[dataCount++] = '0';
//            uiSendBuf[dataCount++] = '2';            
        }

        uiSendBuf[dataCount++] = '#';        
        uiSendBuf[dataCount++] = '#';
        
        wait(0.025); // 25ms, Wait is required in this mode
    }
    
    
    
    
    
//    if (iFunctionCallCounting >= 10)    //10번의 측정이 끝나면,
    if (iFunctionCallCounting >= 8)    //8번의 측정이 끝나면, 180703 온도 0도 표현시 버그 발생..
    {
        isTimerInterruptStarted = true;
//        printf("if in!!\n");
        
        uiSendBuf[dataCount++] = '*';        
        uiSendBuf[dataCount++] = '*';
        
        uiSendBuf[dataCount] = CUBEBITE_SENSOR_UUID;
                           
        iFunctionCallCounting = 0;
    }  
    
    return 0;
}















/**
 * @brief  SendData
 * @param  None
 * @retval None
 */
static int SendData(SimpleSpirit1& myspirit)
{
//    ++iMainCounting;
//    printf("iMainCounting : %d\n", iMainCounting);
//    ++iIsResetStartCountingInterrupt;
    
    isTempOk = false;
#ifdef  CUBEBITE_DEBUG
    printf("=========================================\n");
#endif  //CUBEBITE_DEBUG    

#ifdef  CUBEBITE_DEBUG
    printf("[CUBEBITE] SendData() 호출 됨.\n");
#endif  //CUBEBITE_DEBUG    
    
    int iRet;
    
//    while(1 == myspirit.channel_clear());
//    while(myspirit.is_receiving()); /* wait for ongoing RX ends 180110 HJM 아마 이 전에 보내던 거 마저 다 보내려고 하는 거 같다. */
    
    
    
    
    size_t curr_len = strlen((const char*)uiSendBuf) + 1;
//    printf("curr_len : [%d]\n", curr_len);
    
    
    
    iRet = myspirit.send(uiSendBuf, curr_len);
    
    
    dataCount = 0;    
    for (int iTemp = 0; iTemp < TEST_STR_LEN; ++iTemp)
    {
        uiSendBuf[iTemp] = 0;
    }
    
    printf("iIsResetStartCounting : %d\n", iIsResetStartCounting);
    if (10 < iIsResetStartCounting)
    {//HJM : 아예 뻗으면 하드웨어 리셋으로
        iIsResetStartCounting = 0;        
        //180709 HJM : 하드웨어 리셋이 아니고 SPIRIT1 만 리셋하는 걸로 수정
        resetHW.write(RESET_HW_ON);                

        return RADIO_TX_ERR_RESET;
    }


    if (iRet == RADIO_TX_OK)
    {
        iIsResetStartCounting = 0;
        return RADIO_TX_OK;
    }
    else if (iRet == RADIO_TX_ERR)
    {
        myspirit.off();
        myspirit.on();
        //HJM : 테스트 !!, 
//        while(1 == myspirit.channel_clear());
        ++iIsResetStartCounting;
        return RADIO_TX_ERR;        
    }
    else if (iRet == RADIO_TX_COLLISION)
    {     
        return RADIO_TX_COLLISION;
    }
    else if (iRet == RADIO_TX_NOACK)
    {
        ++iIsResetStartCounting;
        return RADIO_TX_NOACK;              
    }
    else if (iRet == RADIO_TX_ERR_RESET)
    {
        printf("RADIO_TX_ERR_RESET return.\n");    
        ++iIsResetStartCounting;    
        
        //소프트웨어 리셋
        myspirit.reset_board();
        myspirit.off();
        myspirit.on();
        
        //180703 HJM : 하드웨어 리셋으로 바꿈
//        resetHW.write(SPIRIT1_POWER_OFF);
        return RADIO_TX_ERR_RESET;
    }
    
    dataCount = 0;
    
    for (int iTemp = 0; iTemp < TEST_STR_LEN; ++iTemp)
    {
        uiSendBuf[iTemp] = 0;
    }
     
    
    
    
    
#ifdef  CUBEBITE_DEBUG
    printf("[CUBEBITE] SendData() 호출 끝.\n");
#endif

    return -10;
}



